use Test::More tests => 1 + 25;

use warnings;
use strict;

use Weather::Bug;
use FindBin;
use lib "$FindBin::Bin/lib";
use Test::Weather::Bug;
use Test::Group;

my %cities = map { $_ => 1 } qw/Houston Bellaire/;
my %zipcodes = map { $_ => 1 }
      qw/77007 77008 77024 77025 77030 77035
         77036 77045 77047 77055 77056 77072
         77077 77081 77083 77401 77033 77019
         77204/;

my $wxbug = Test::Weather::Bug->new( -key => 'FAKELICENSEKEY' );

my @stations = $wxbug->list_stations( 77096 );

is( scalar( @stations ), 25, 'Right number of stations returned' );

my $index = 0;
foreach my $s (@stations)
{
    station_ok( $s, "Station $index" );
    ++$index;
}

# -------
# Utility functions to simplify the testing.
sub station_ok
{
    my $s = shift;
    my $name = shift || 'station_ok';

    test $name => sub {
        isa_ok( $s, 'Weather::Bug::Station' );
        like( $s->id(), qr/^\w\w\w\w\w$/, 'Station id' );
        ok( length $s->name() > 0, 'Station name' );
        is( $s->station_type(), 'WeatherBug', 'Station type' );
        ok( exists $cities{$s->location()->city()}, 'City in list' );
        ok( exists $zipcodes{$s->location()->zipcode()}, 'Zipcode in list' );
        is( $s->location->state(), 'TX', 'State' );
    };
}

