# Generated by default/object.tt
package Paws::SecurityHub::AwsRdsDbClusterSnapshotDetails;
  use Moose;
  has AllocatedStorage => (is => 'ro', isa => 'Int');
  has AvailabilityZones => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ClusterCreateTime => (is => 'ro', isa => 'Str');
  has DbClusterIdentifier => (is => 'ro', isa => 'Str');
  has DbClusterSnapshotIdentifier => (is => 'ro', isa => 'Str');
  has Engine => (is => 'ro', isa => 'Str');
  has EngineVersion => (is => 'ro', isa => 'Str');
  has IamDatabaseAuthenticationEnabled => (is => 'ro', isa => 'Bool');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has LicenseModel => (is => 'ro', isa => 'Str');
  has MasterUsername => (is => 'ro', isa => 'Str');
  has PercentProgress => (is => 'ro', isa => 'Int');
  has Port => (is => 'ro', isa => 'Int');
  has SnapshotCreateTime => (is => 'ro', isa => 'Str');
  has SnapshotType => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StorageEncrypted => (is => 'ro', isa => 'Bool');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsRdsDbClusterSnapshotDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsRdsDbClusterSnapshotDetails object:

  $service_obj->Method(Att1 => { AllocatedStorage => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsRdsDbClusterSnapshotDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AllocatedStorage

=head1 DESCRIPTION

Information about an Amazon RDS DB cluster snapshot.

=head1 ATTRIBUTES


=head2 AllocatedStorage => Int

Specifies the allocated storage size in gibibytes (GiB).


=head2 AvailabilityZones => ArrayRef[Str|Undef]

A list of Availability Zones where instances in the DB cluster can be
created.


=head2 ClusterCreateTime => Str

Indicates when the DB cluster was created, in Universal Coordinated
Time (UTC).

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 DbClusterIdentifier => Str

The DB cluster identifier.


=head2 DbClusterSnapshotIdentifier => Str

The identifier of the DB cluster snapshot.


=head2 Engine => Str

The name of the database engine that you want to use for this DB
instance.


=head2 EngineVersion => Str

The version of the database engine to use.


=head2 IamDatabaseAuthenticationEnabled => Bool

Whether mapping of IAM accounts to database accounts is enabled.


=head2 KmsKeyId => Str

The ARN of the AWS KMS master key that is used to encrypt the database
instances in the DB cluster.


=head2 LicenseModel => Str

The license model information for this DB cluster snapshot.


=head2 MasterUsername => Str

The name of the master user for the DB cluster.


=head2 PercentProgress => Int

Specifies the percentage of the estimated data that has been
transferred.


=head2 Port => Int

The port number on which the DB instances in the DB cluster accept
connections.


=head2 SnapshotCreateTime => Str

Indicates when the snapshot was taken.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 SnapshotType => Str

The type of DB cluster snapshot.


=head2 Status => Str

The status of this DB cluster snapshot.


=head2 StorageEncrypted => Bool

Whether the DB cluster is encrypted.


=head2 VpcId => Str

The VPC ID that is associated with the DB cluster snapshot.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

