/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.tool;

import com.adobe.epubcheck.api.EpubCheck;
import com.adobe.epubcheck.api.EpubCheckFactory;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.nav.NavCheckerFactory;
import com.adobe.epubcheck.opf.DocumentValidator;
import com.adobe.epubcheck.opf.DocumentValidatorFactory;
import com.adobe.epubcheck.opf.OPFCheckerFactory;
import com.adobe.epubcheck.ops.OPSCheckerFactory;
import com.adobe.epubcheck.overlay.OverlayCheckerFactory;
import com.adobe.epubcheck.util.Archive;
import com.adobe.epubcheck.util.DefaultReportImpl;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.FileResourceProvider;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.OPSType;
import com.adobe.epubcheck.util.URLResourceProvider;
import com.adobe.epubcheck.util.XmlReportImpl;
import java.io.File;
import java.util.HashMap;

public class Checker {
    private static String path = null;
    private static String mode = null;
    private static EPUBVersion version = EPUBVersion.VERSION_3;
    private static OPSType opsType;
    private static boolean expanded;
    private static boolean keep;
    private static boolean quietRun;
    private static File fileOut;
    private static HashMap<OPSType, String> modeMimeTypeMap;
    private static HashMap<OPSType, DocumentValidatorFactory> documentValidatorFactoryMap;

    public static int validateFile(GenericResourceProvider resourceProvider, String fileName, String mimeType, EPUBVersion version, Report report) {
        opsType = new OPSType(mode, version);
        DocumentValidatorFactory factory = documentValidatorFactoryMap.get(opsType);
        if (factory == null) {
            System.out.println(Messages.DISPLAY_HELP);
            report.exception(fileName, new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version})));
            throw new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version}));
        }
        DocumentValidator check = factory.newInstance(report, path, resourceProvider, modeMimeTypeMap.get(opsType), version);
        if (check.validate()) {
            if (!quietRun) {
                System.out.println(Messages.NO_ERRORS__OR_WARNINGS);
            }
            return 0;
        }
        System.err.println(Messages.THERE_WERE_ERRORS);
        return 1;
    }

    public static int validateFile(String path, String mimeType, EPUBVersion version, Report report) {
        GenericResourceProvider resourceProvider = path.startsWith("http://") || path.startsWith("https://") ? new URLResourceProvider(path) : new FileResourceProvider(path);
        opsType = new OPSType(mode, version);
        DocumentValidatorFactory factory = documentValidatorFactoryMap.get(opsType);
        if (factory == null) {
            System.out.println(Messages.DISPLAY_HELP);
            report.exception(path, new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version})));
            throw new RuntimeException(String.format(Messages.MODE_VERSION_NOT_SUPPORTED, new Object[]{mode, version}));
        }
        DocumentValidator check = factory.newInstance(report, path, resourceProvider, modeMimeTypeMap.get(opsType), version);
        if (check.validate()) {
            if (!quietRun) {
                System.out.println(Messages.NO_ERRORS__OR_WARNINGS);
            }
            return 0;
        }
        System.err.println(Messages.THERE_WERE_ERRORS);
        return 1;
    }

    public static void main(String[] args) {
        System.exit(Checker.run(args));
    }

    public static int run(String[] args) {
        try {
            Report report;
            Checker.processArguments(args);
            if (expanded) {
                String toolDate;
                Report report2;
                Archive epub = new Archive(path, keep);
                if (fileOut == null) {
                    report2 = new DefaultReportImpl(epub.getEpubName(), quietRun);
                    report2.info(null, FeatureEnum.TOOL_NAME, "epubcheck");
                    report2.info(null, FeatureEnum.TOOL_VERSION, EpubCheck.version());
                    toolDate = EpubCheck.buildDate();
                    if (toolDate != null && !toolDate.startsWith("$")) {
                        report2.info(null, FeatureEnum.TOOL_DATE, toolDate);
                    }
                } else {
                    report2 = new XmlReportImpl(fileOut, epub.getEpubName(), EpubCheck.version());
                    toolDate = EpubCheck.buildDate();
                    if (toolDate != null && !toolDate.startsWith("$")) {
                        report2.info(null, FeatureEnum.TOOL_DATE, toolDate);
                    }
                }
                epub.createArchive();
                EpubCheck check = new EpubCheck(epub.getEpubFile(), report2);
                if (check.validate()) {
                    if (!quietRun) {
                        System.out.println(Messages.NO_ERRORS__OR_WARNINGS);
                    }
                    if (report2 instanceof XmlReportImpl && ((XmlReportImpl)report2).generate() && !quietRun) {
                        System.out.println(Messages.CLI_OUTPUT_XML + fileOut);
                    }
                    return 0;
                }
                System.err.println(Messages.THERE_WERE_ERRORS);
                if (report2 instanceof XmlReportImpl && ((XmlReportImpl)report2).generate() && !quietRun) {
                    System.out.println(Messages.CLI_OUTPUT_XML + fileOut);
                }
                if ((report2.getErrorCount() > 0 || report2.getExceptionCount() > 0) && keep) {
                    System.err.println(Messages.DELETING_ARCHIVE);
                    epub.deleteEpubFile();
                }
                return 1;
            }
            if (fileOut == null) {
                report = mode != null ? new DefaultReportImpl(path, String.format(Messages.SINGLE_FILE, mode, version.toString()), quietRun) : new DefaultReportImpl(path, quietRun);
            } else {
                report = new XmlReportImpl(fileOut, path, EpubCheck.version());
                if (mode != null) {
                    report.info(null, FeatureEnum.EXEC_MODE, String.format(Messages.SINGLE_FILE, mode, version.toString()));
                }
            }
            int returnValue = Checker.validateFile(path, mode, version, report);
            if (report instanceof XmlReportImpl && report.generate() && !quietRun) {
                System.out.println(Messages.CLI_OUTPUT_XML + fileOut);
            }
            return returnValue;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void processArguments(String[] args) {
        path = null;
        mode = null;
        version = EPUBVersion.VERSION_3;
        opsType = null;
        expanded = false;
        keep = false;
        quietRun = false;
        fileOut = null;
        if (args.length < 1) {
            Checker.displayVersion();
            System.err.println(Messages.ARGUMENT_NEEDED);
            System.err.println(Messages.DISPLAY_HELP);
            System.err.println("");
            System.err.println(Messages.END_OF_EXECUTION);
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-version") || args[i].equals("-v")) {
                if (i + 1 < args.length) {
                    if (args[++i].equals("2.0") || args[i].equals("2")) {
                        version = EPUBVersion.VERSION_2;
                        continue;
                    }
                    if (args[i].equals("3.0") || args[i].equals("3")) {
                        version = EPUBVersion.VERSION_3;
                        continue;
                    }
                    Checker.displayVersion();
                    System.err.println(Messages.DISPLAY_HELP);
                    throw new RuntimeException(new InvalidVersionException(InvalidVersionException.UNSUPPORTED_VERSION));
                }
                Checker.displayVersion();
                System.err.println(Messages.DISPLAY_HELP);
                throw new RuntimeException(String.format(Messages.AFTER_ARGUMENT_EXPECTED, "-v or -version", "version"));
            }
            if (args[i].equals("-mode")) {
                if (i + 1 < args.length) {
                    if ((mode = args[++i]).equals("exp")) {
                        expanded = true;
                        continue;
                    }
                    expanded = false;
                    continue;
                }
                Checker.displayVersion();
                System.err.println(Messages.DISPLAY_HELP);
                throw new RuntimeException(String.format(Messages.AFTER_ARGUMENT_EXPECTED, "-mode", "type"));
            }
            if (args[i].equals("-save")) {
                keep = true;
                continue;
            }
            if (args[i].equals("-quiet") || args[i].equals("-q")) {
                quietRun = true;
                continue;
            }
            if ("-out".equals(args[i])) {
                if (i + 1 >= args.length) continue;
                fileOut = new File(args[++i]);
                continue;
            }
            if (args[i].equals("-help") || args[i].equals("--help") || args[i].equals("-?")) {
                Checker.displayHelp();
                continue;
            }
            path = args[i];
        }
        if (path != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < path.length(); ++i) {
                if (path.charAt(i) == '\\') {
                    sb.append('/');
                    continue;
                }
                sb.append(path.charAt(i));
            }
            path = sb.toString();
        }
        Checker.displayVersion();
        if (path == null) {
            System.err.println(Messages.DISPLAY_HELP);
            System.err.println(Messages.NO_FILE_SPECIFIED);
            System.err.println(Messages.END_OF_EXECUTION);
            System.exit(1);
        } else if (path.matches(".+\\.[Ee][Pp][Uu][Bb]")) {
            if (mode != null || version != EPUBVersion.VERSION_3) {
                System.err.println(Messages.MODE_VERSION_IGNORED);
                mode = null;
            }
        } else if (mode == null) {
            System.out.println(Messages.DISPLAY_HELP);
            throw new RuntimeException(Messages.MODE_REQUIRED);
        }
    }

    public static void displayHelp() {
        System.out.println("When running this tool, the first argument should be the name (with the path) of the file to check.");
        System.out.println("If checking a non-epub file, the epub version of the file must be specified using -v and the type of the file using -mode.");
        System.out.println("The default version is: 3.0.");
        System.out.println(" ");
        System.out.println("Modes and versions supported: ");
        System.out.println("-mode opf -v 2.0    // For single OPF file validation (EPUB 2)");
        System.out.println("-mode opf -v 3.0    // For single OPF file validation (EPUB 3)");
        System.out.println("-mode xhtml -v 2.0  // For single XHTML file validation (EPUB 2)");
        System.out.println("-mode xhtml -v 3.0  // For single XHTML file validation (EPUB 3)");
        System.out.println("-mode svg -v 2.0    // For single SVG file validation (EPUB 2)");
        System.out.println("-mode svg -v 3.0    // For single SVG file validation (EPUB 3)");
        System.out.println("-mode nav -v 3.0    // For single 'Navigation Document' validation");
        System.out.println("-mode mo  -v 3.0    // For single 'Media Overlays' validation");
        System.out.println("-mode exp           // For validating expanded EPUB archives");
        System.out.println(" ");
        System.out.println("This tool also accepts the following flags:");
        System.out.println("-save \t      = saves the epub created from the expanded epub (-mode exp)");
        System.out.println("-quiet \t      = no message sent to stdout, only errors in stderr");
        System.out.println("-out <file>   = ouput an assessment XML document in file (experimental)");
        System.out.println("-? or -help   = displays this help message");
        System.out.println(" ");
    }

    public static void displayVersion() {
        if (!quietRun) {
            System.out.println("Epubcheck Version " + EpubCheck.version() + "\n");
        }
    }

    static {
        expanded = false;
        keep = false;
        quietRun = false;
        HashMap<OPSType, Object> map = new HashMap<OPSType, Object>();
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_2), "application/xhtml+xml");
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_3), "application/xhtml+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_2), "image/svg+xml");
        map.put(new OPSType("svg", EPUBVersion.VERSION_3), "image/svg+xml");
        map.put(new OPSType("mo", EPUBVersion.VERSION_3), "application/smil+xml");
        map.put(new OPSType("nav", EPUBVersion.VERSION_3), "nav");
        modeMimeTypeMap = map;
        map = new HashMap();
        map.put(new OPSType(null, EPUBVersion.VERSION_2), EpubCheckFactory.getInstance());
        map.put(new OPSType(null, EPUBVersion.VERSION_3), EpubCheckFactory.getInstance());
        map.put(new OPSType("opf", EPUBVersion.VERSION_2), OPFCheckerFactory.getInstance());
        map.put(new OPSType("opf", EPUBVersion.VERSION_3), OPFCheckerFactory.getInstance());
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_2), OPSCheckerFactory.getInstance());
        map.put(new OPSType("xhtml", EPUBVersion.VERSION_3), OPSCheckerFactory.getInstance());
        map.put(new OPSType("svg", EPUBVersion.VERSION_2), OPSCheckerFactory.getInstance());
        map.put(new OPSType("svg", EPUBVersion.VERSION_3), OPSCheckerFactory.getInstance());
        map.put(new OPSType("mo", EPUBVersion.VERSION_3), OverlayCheckerFactory.getInstance());
        map.put(new OPSType("nav", EPUBVersion.VERSION_3), NavCheckerFactory.getInstance());
        documentValidatorFactoryMap = map;
    }
}

