use Mojo::Base -strict;

use Test::More;
use Mojolicious::Lite;
use Test::Mojo;

plugin 'NoReferrer' => { content => 'no-referrer' };

get '/' => sub {
    my $c = shift;
    $c->render( 'index' );
};

my $t = Test::Mojo->new;
$t->get_ok('/')->status_is(200)->content_like( qr{<meta name="referrer" content="no-referrer">} );

done_testing();

__DATA__
@@ index.html.ep
% layout 'default';

@@ layouts/default.html.ep
<html>
  <head>
  </head>
</html>
