/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.session.remote;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.openqa.selenium.grid.session.remote.SessionCodec;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.internal.JsonToWebElementConverter;

class ProtocolConverter
implements SessionCodec {
    private static final ImmutableSet<String> IGNORED_REQ_HEADERS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("connection")).add("keep-alive")).add("proxy-authorization")).add("proxy-authenticate")).add("proxy-connection")).add("te")).add("trailer")).add("transfer-encoding")).add("upgrade")).build();
    private final HttpClient client;
    private final CommandCodec<HttpRequest> downstream;
    private final CommandCodec<HttpRequest> upstream;
    private final ResponseCodec<HttpResponse> downstreamResponse;
    private final ResponseCodec<HttpResponse> upstreamResponse;
    private final JsonToWebElementConverter converter;

    public ProtocolConverter(URL upstreamUrl, CommandCodec<HttpRequest> downstream, ResponseCodec<HttpResponse> downstreamResponse, CommandCodec<HttpRequest> upstream, ResponseCodec<HttpResponse> upstreamResponse) {
        this.downstream = downstream;
        this.upstream = upstream;
        this.downstreamResponse = downstreamResponse;
        this.upstreamResponse = upstreamResponse;
        this.client = HttpClient.Factory.createDefault().createClient(upstreamUrl);
        this.converter = new JsonToWebElementConverter(null);
    }

    @Override
    public void handle(HttpRequest req, HttpResponse resp) throws IOException {
        Command command = this.downstream.decode(req);
        Map parameters = (Map)this.converter.apply(command.getParameters());
        command = new Command(command.getSessionId(), command.getName(), parameters);
        HttpRequest request = this.upstream.encode(command);
        HttpResponse res = this.makeRequest(request);
        Response decoded = this.upstreamResponse.decode(res);
        HttpResponse response = this.downstreamResponse.encode(HttpResponse::new, decoded);
        this.copyToServletResponse(response, resp);
    }

    @VisibleForTesting
    HttpResponse makeRequest(HttpRequest request) throws IOException {
        return this.client.execute(request);
    }

    private void copyToServletResponse(HttpResponse response, HttpResponse resp) throws IOException {
        resp.setStatus(response.getStatus());
        for (String name : response.getHeaderNames()) {
            if (IGNORED_REQ_HEADERS.contains(name.toLowerCase())) continue;
            for (String value : response.getHeaders(name)) {
                resp.addHeader(name, value);
            }
        }
        resp.setContent(response.consumeContentStream());
    }
}

