/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buf;
    protected int count;

    public HsqlByteArrayOutputStream() {
        this(128);
    }

    public HsqlByteArrayOutputStream(int n) {
        if (n < 128) {
            n = 128;
        }
        this.buf = new byte[n];
    }

    public HsqlByteArrayOutputStream(byte[] byArray) {
        this.buf = byArray;
    }

    public final void writeShort(int n) {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public final void writeInt(int n) {
        if (this.count + 4 > this.buf.length) {
            this.ensureRoom(4);
        }
        this.buf[this.count++] = (byte)(n >>> 24);
        this.buf[this.count++] = (byte)(n >>> 16);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public final void writeLong(long l) {
        this.writeInt((int)(l >>> 32));
        this.writeInt((int)l);
    }

    public final void writeBytes(String string) {
        int n = string.length();
        this.ensureRoom(n);
        for (int i = 0; i < n; ++i) {
            this.buf[this.count++] = (byte)string.charAt(i);
        }
    }

    public final void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.ensureRoom(1);
        this.buf[this.count++] = (byte)n;
    }

    public void writeChar(int n) throws IOException {
        this.ensureRoom(2);
        this.buf[this.count++] = (byte)(n >>> 8);
        this.buf[this.count++] = (byte)n;
    }

    public void writeChars(String string) throws IOException {
        int n = string.length();
        this.ensureRoom(n * 2);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.buf[this.count++] = (byte)(c >>> 8);
            this.buf[this.count++] = (byte)c;
        }
    }

    public void writeUTF(String string) throws IOException {
        int n = string.length();
        if (n > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(n * 3 + 2);
        int n2 = this.count;
        this.count += 2;
        StringConverter.writeUTF(string, this);
        int n3 = this.count - n2 - 2;
        if (n3 > 65535) {
            this.count = n2;
            throw new UTFDataFormatException();
        }
        this.buf[n2++] = (byte)(n3 >>> 8);
        this.buf[n2] = (byte)n3;
    }

    public void flush() throws IOException {
        super.flush();
    }

    public void write(int n) {
        this.ensureRoom(1);
        this.buf[this.count] = (byte)n;
        ++this.count;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.ensureRoom(n2);
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    public void close() throws IOException {
    }

    public void fill(int n, int n2) {
        this.ensureRoom(n2);
        for (int i = 0; i < n2; ++i) {
            this.buf[this.count++] = (byte)n;
        }
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    protected void ensureRoom(int n) {
        int n2 = this.count + n;
        if (n2 > this.buf.length) {
            byte[] byArray = new byte[n2 + n2 / 2 + 256 & 0xFFFFFF00];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    protected void reset(int n) {
        this.count = 0;
        if (n > this.buf.length) {
            this.buf = new byte[n];
        }
    }
}

