package Business::EDI::CodeList::MessageReleaseNumber;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {return "0054";}
my $usage       = 'B';

# * 0054  Message release number
# Desc: Release number within the current message version number.
# Repr: an..3

my %code_hash = (
'1' => [ 'First release',
    'User message approved and issued in the first release of the year of the UNTDID (United Nations Trade Data Interchange Directory); valid for directories published prior to March 1990. Service message approved and issued as the first release of the message within a version of ISO 9735; valid for version 4 of IS0 9735 and later.' ],
'2' => [ 'Second release',
    'User message approved and issued in the second release of the year of the UNTDID (United Nations Trade Data Interchange Directory); valid for directories published prior to March 1990.  Service message approved and issued as the second release of the message within a version of ISO 9735; valid for version 4 of IS0 9735 and later.' ],
'902' => [ 'Trial release 1990',
    'Message approved and issued in the 1990 status 1 (trial) release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'911' => [ 'Trial release 1991',
    'Message approved and issued in the 1991 status 1 (trial) release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'912' => [ 'Standard release 1991',
    'Message approved and issued in the 1991 status 2 (standard) release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'921' => [ 'Trial release 1992',
    'Message approved and issued in the 1992 status 1 (trial) release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'932' => [ 'Standard release 1993',
    'Message approved and issued in the 1993 status 2 (standard) release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'00A' => [ 'Release 2000 - A',
    'Message approved and issued in the first 2000 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'00B' => [ 'Release 2000 - B',
    'Message approved and issued in the second 2000 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'01A' => [ 'Release 2001 - A',
    'Message approved and issued in the first 2001 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'01B' => [ 'Release 2001 - B',
    'Message approved and issued in the second 2001 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'01C' => [ 'Release 2001 - C',
    'Message approved and issued in the third 2001 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'02A' => [ 'Release 2002 - A',
    'Message approved and issued in the first 2002 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'02B' => [ 'Release 2002 - B',
    'Message approved and issued in the second 2002 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'03A' => [ 'Release 2003 - A',
    'Message approved and issued in the first 2003 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'03B' => [ 'Release 2003 - B',
    'Message approved and issued in the second 2003 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'04A' => [ 'Release 2004 - A',
    'Message approved and issued in the first 2004 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'04B' => [ 'Release 2004 - B',
    'Message approved and issued in the second 2004 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'05A' => [ 'Release 2005 - A',
    'Message approved and issued in the first 2005 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'05B' => [ 'Release 2005 - B',
    'Message approved and issued in the second 2005 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'06A' => [ 'Release 2006 - A',
    'Message approved and issued in the first 2006 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'06B' => [ 'Release 2006 - B',
    'Message approved and issued in the second 2006 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'07A' => [ 'Release 2007 - A',
    'Message approved and issued in the first 2007 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'07B' => [ 'Release 2007 - B',
    'Message approved and issued in the second 2007 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'08A' => [ 'Release 2008 - A',
    'Message approved and issued in the first 2008 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'08B' => [ 'Release 2008 - B',
    'Message approved and issued in the second 2008 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'09A' => [ 'Release 2009 - A',
    'Message approved and issued in the first 2009 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'09B' => [ 'Release 2009 - B',
    'Message approved and issued in the second 2009 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'10A' => [ 'Release 2010 - A',
    'Message approved and issued in the first 2010 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'93A' => [ 'Release 1993 - A',
    'Message approved and issued in the 1993 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'94A' => [ 'Release 1994 - A',
    'Message approved and issued in the first 1994 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'94B' => [ 'Release 1994 - B',
    'Message approved and issued in the second 1994 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'95A' => [ 'Release 1995 - A',
    'Message approved and issued in the first 1995 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'95B' => [ 'Release 1995 - B',
    'Message approved and issued in the second 1995 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'96A' => [ 'Release 1996 - A',
    'Message approved and issued in the first 1996 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'96B' => [ 'Release 1996 - B',
    'Message approved and issued in the second 1996 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'97A' => [ 'Release 1997 - A',
    'Message approved and issued in the first 1997 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'97B' => [ 'Release 1997 - B',
    'Message approved and issued in the second 1997 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'98A' => [ 'Release 1998 - A',
    'Message approved and issued in the first 1998 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'98B' => [ 'Release 1998 - B',
    'Message approved and issued in the second 1998 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'99A' => [ 'Release 1999 - A',
    'Message approved and issued in the first 1999 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
'99B' => [ 'Release 1999 - B',
    'Message approved and issued in the second 1999 release of the UNTDID (United Nations Trade Data Interchange Directory).' ],
);
sub get_codes { return \%code_hash; }

1;
