package Google::Ads::AdWords::v201109::CampaignTargetSelector;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %campaignIds_of :ATTR(:get<campaignIds>);

__PACKAGE__->_factory(
    [ qw(        campaignIds

    ) ],
    {
        'campaignIds' => \%campaignIds_of,
    },
    {
        'campaignIds' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'campaignIds' => 'campaignIds',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109::CampaignTargetSelector

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CampaignTargetSelector from the namespace https://adwords.google.com/api/adwords/cm/v201109.

A campaign targeting selector to specify which targets to return. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * campaignIds




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109::CampaignTargetSelector
   campaignIds =>  $some_value, # long
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

