package Google::Ads::AdWords::v201806::CampaignBidModifier;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %campaignId_of :ATTR(:get<campaignId>);
my %criterion_of :ATTR(:get<criterion>);
my %campaignName_of :ATTR(:get<campaignName>);
my %advertisingChannelType_of :ATTR(:get<advertisingChannelType>);
my %bidModifier_of :ATTR(:get<bidModifier>);

__PACKAGE__->_factory(
    [ qw(        campaignId
        criterion
        campaignName
        advertisingChannelType
        bidModifier

    ) ],
    {
        'campaignId' => \%campaignId_of,
        'criterion' => \%criterion_of,
        'campaignName' => \%campaignName_of,
        'advertisingChannelType' => \%advertisingChannelType_of,
        'bidModifier' => \%bidModifier_of,
    },
    {
        'campaignId' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
        'criterion' => 'Google::Ads::AdWords::v201806::Criterion',
        'campaignName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'advertisingChannelType' => 'Google::Ads::AdWords::v201806::AdvertisingChannelType',
        'bidModifier' => 'SOAP::WSDL::XSD::Typelib::Builtin::double',
    },
    {

        'campaignId' => 'campaignId',
        'criterion' => 'criterion',
        'campaignName' => 'campaignName',
        'advertisingChannelType' => 'advertisingChannelType',
        'bidModifier' => 'bidModifier',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::CampaignBidModifier

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CampaignBidModifier from the namespace https://adwords.google.com/api/adwords/cm/v201806.

Represents a bid-modifiable only criterion at the campaign level. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * campaignId


=item * criterion


=item * campaignName


=item * advertisingChannelType


=item * bidModifier




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

