/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import java.security.AccessControlException;
import java.util.ArrayList;
import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.KeySpec;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.ObsKeyState;
import org.couchbase.mock.memcached.Storage;
import org.couchbase.mock.memcached.VBucketInfo;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryObserveCommand;
import org.couchbase.mock.memcached.protocol.BinaryObserveResponse;
import org.couchbase.mock.memcached.protocol.ObserveCode;

public class ObserveCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        BinaryObserveCommand command = (BinaryObserveCommand)cmd;
        Storage storage = server.getStorage();
        ArrayList<ObsKeyState> states = new ArrayList<ObsKeyState>();
        for (KeySpec spec : command.getKeySpecs()) {
            ObsKeyState kState;
            ObserveCode code;
            VBucketInfo vbInfo = storage.getVBucketInfo(spec.vbId);
            if (!vbInfo.hasAccess(server)) {
                throw new AccessControlException("not my vbucket");
            }
            Item cached = storage.getCached(spec);
            Item persisted = storage.getPersisted(spec);
            if (cached == null) {
                code = persisted == null ? ObserveCode.NOT_FOUND : ObserveCode.LOGICALLY_DELETED;
                kState = new ObsKeyState(spec, code, 0L);
            } else {
                code = persisted == null ? ObserveCode.NOT_PERSISTED : (persisted.getCas() != cached.getCas() ? ObserveCode.NOT_PERSISTED : ObserveCode.PERSISTED);
                kState = new ObsKeyState(cached, code);
            }
            states.add(kState);
        }
        client.sendResponse(new BinaryObserveResponse(cmd, states));
    }
}

