### 05-stagefailure.t #########################################################
# This file tests the handing of stage failure

### Includes ##################################################################

# Safe Perl
use warnings;
use strict;
use Carp;

use Test::More tests => 6;
use Test::Exception;

use HPCI;

my $cluster = $ENV{HPCI_CLUSTER} || 'uni';

my $group = HPCI->group( cluster => $cluster, base_dir => 'scratch', name => 'T_Failure' );

ok($group, "Group created.");

my $stage1 = $group->stage(
	name => 'Stage1',
	modules_to_load => ['Perl-BL'],
	resources_required => {
		h_vmem => '2G'
		},
	command => "exit 0",
	extra_sge_args_string => ''
	);

ok($stage1, "Stage 1 created.");

my $stage2 = $group->stage(
	name => 'Stage2',
	modules_to_load => ['Perl-BL'],
	resources_required => {
		h_vmem => '2G'
		},
	command => "exit 1",
	extra_sge_args_string => ''
	);

ok($stage2, "Stage 2 created.");

my $stage3 = $group->stage(
	name => 'Stage3',
	modules_to_load => ['Perl-BL'],
	resources_required => {
		h_vmem => '2G'
		},
	command => "exit 0",
	extra_sge_args_string => ''
	);

ok($stage3, "Stage 3 created.");

my $stage4 = $group->stage(
	name => 'Stage4',
	modules_to_load => ['Perl-BL'],
	resources_required => {
		h_vmem => '2G'
		},
	command => "exit 0",
	extra_sge_args_string => ''
	);

ok($stage4, "Stage 4 created.");

my $stage5 = $group->stage(
	name => 'Stage5',
	modules_to_load => ['Perl-BL'],
	resources_required => {
		h_vmem => '2G'
		},
	command => "exit 0",
	extra_sge_args_string => ''
	);

ok($stage5, "Stage 5 created.");

# order: (1,2), (3,4,5)
# 2,3,4 in any order, 1 is first, 5 is last
$group->add_deps(
	pre_reqs => [ $stage1, $stage2 ],
	deps     => [ $stage3, $stage4, $stage5 ]
);

$group->execute();

1;
