package HPCI::CommandScript;

### INCLUDES ######################################################################################

# safe Perl
use warnings;
use strict;
use Carp;

use Moose::Role;
use MooseX::Types::Path::Class qw(Dir File);

after 'BUILD' => sub {
	my $self = shift;
	my $csn = $self->script_file;
	open my $fh, '>', $csn
		or $self->_croak("Cannot create script ($csn): $!");
	print $fh '#!', $self->command_shell, "\n",
	    "\n",
		"set -x\n",
		"# This autogenerated script is to be run on a ", $self->cluster, " cluster.\n",
		"\n",
		;

	for my $meth (@{ $self->_command_expansion_methods }) {
		$self->$meth($fh) if $self->can($meth);
	}

	print $fh $self->command, "\n";
	close $fh;
	chmod(0755, $csn);

	print("Rendered: '$csn'\n");
	return $csn;
};

has 'script_file' => (
	is      => 'ro',
	isa     => File,
	coerce  => 1,
	lazy    => 1,
	default => sub {
		my $self   = shift;
		return $self->stage_dir->file( 'script.sh' );
	},
);

has '_command_expansion_methods' => (
	is       => 'rw',
	isa      => 'ArrayRef[Str]',
	lazy     => 1,
	init_arg => undef,
	default  => sub { [ 'print_env_settings' ] },
);

has 'command_shell' => (
	is      => 'ro',
	isa     => 'Str',
	lazy    => 1,
	default => '/bin/bash',
);

1;
