# JIRA::REST

A thin wrapper around Jira's REST APIs

## What's this about?

[Jira](http://www.atlassian.com/software/jira) is a proprietary bug tracking
system from [Atlassian](http://www.atlassian.com/software/jira/).

This module implements a thin wrapper around Jira's REST APIs:

- [Jira Core REST API](https://docs.atlassian.com/jira/REST/server/)

This rich API superseded the old [Jira SOAP
API](http://docs.atlassian.com/software/jira/docs/api/rpc-jira-plugin/latest/com/atlassian/jira/rpc/soap/JiraSoapService.html)
which isn't supported anymore as of Jira version 7.

- [Jira Service Desk REST API](https://docs.atlassian.com/jira-servicedesk/REST/server/)

This API deals with the objects of the Jira Service Desk application.

- [Jira Software REST API](https://docs.atlassian.com/jira-software/REST/server/)

This API deals with the objects of the Jira Software application.

## Getting Help

In order to ask questions or to report problems, please, [file an issue at
GitHub](https://github.com/gnustavo/JIRA-REST/issues).

## Copyright & License

JIRA::REST is copyright (c) 2013-2021 of [CPQD](http://www.cpqd.com.br/).

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself. About the only thing you
can't do is pretend that you wrote code that you didn't.

## Enjoy!

Gustavo Chaves <gnustavo@cpan.org>
