#!/usr/bin/perl

package eBay::API::XML::Call::GetSellerPayments::GetSellerPaymentsResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetSellerPaymentsResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetSellerPayments::GetSellerPaymentsResponseType

=head1 DESCRIPTION

Returns a summary of pending or paid payments that Half.com created for the seller
identified by the authentication token in the request. Only returns payments that
occurred within a particular pay period. Each payment is for one transaction for
one item in one order. An order can contain transactions for multiple items from
multiple sellers, but this call only retrieves payments that are relevant to one
seller. Payments are only issued for items and transactions that the seller has
confirmed (see the Half.com online help for details). The financial value of a
payment is typically based on an amount that a buyer paid to Half.com for a
transaction, plus the shipping cost the buyer paid to Half.com for the item, minus
Half.com's commission. For most sellers, each month contains two pay periods: One
from the 1st to the 15th of the month, and one from the 16th to the last day of
the month. Payments are submitted to the seller's financial institution a certain
number of days after the current pay period ends (see the Half.com online help for
details).



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetSellerPayments::GetSellerPaymentsResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::PaginationResultType;
use eBay::API::XML::DataType::SellerPaymentType;


my @gaProperties = ( [ 'HasMorePayments', 'xs:boolean', '', '', '' ]
	, [ 'PageNumber', 'xs:int', '', '', '' ]
	, [ 'PaginationResult', 'ns:PaginationResultType', ''
	     ,'eBay::API::XML::DataType::PaginationResultType', '1' ]
	, [ 'PaymentsPerPage', 'xs:int', '', '', '' ]
	, [ 'ReturnedPaymentCountActual', 'xs:int', '', '', '' ]
	, [ 'SellerPayment', 'ns:SellerPaymentType', '1'
	     ,'eBay::API::XML::DataType::SellerPaymentType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setHasMorePayments()

If true, there are more payments yet to be retrieved. Additional
GetSellerPayments calls with higher page numbers or more entries per page
must be made to retrieve these payments. If false, no more payments are
available or no payments match the request (based on the payment status
and time filter).

#    Argument: 'xs:boolean'

=cut

sub setHasMorePayments {
  my $self = shift;
  $self->{'HasMorePayments'} = shift
}

=head2 isHasMorePayments()

  Returned: Always
#    Returns: 'xs:boolean'

=cut

sub isHasMorePayments {
  my $self = shift;
  return $self->{'HasMorePayments'};
}


=head2 setPageNumber()

Indicates which page of data holds the current result set. Will be the
same as the value specified in the Pagination.PageNumber input. (If the
input is higher than the total number of pages, the call fails with an
error.) If no payments are returned, the value is 0. If payments are
returned, the first page number is 1.

#    Argument: 'xs:int'

=cut

sub setPageNumber {
  my $self = shift;
  $self->{'PageNumber'} = shift
}

=head2 getPageNumber()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getPageNumber {
  my $self = shift;
  return $self->{'PageNumber'};
}


=head2 setPaginationResult()

Contains information regarding the pagination of data (if pagination is used),
including total number of pages and total number of entries.

#    Argument: 'ns:PaginationResultType'

=cut

sub setPaginationResult {
  my $self = shift;
  $self->{'PaginationResult'} = shift
}

=head2 getPaginationResult()

  Returned: Always
#    Returns: 'ns:PaginationResultType'

=cut

sub getPaginationResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'PaginationResult'
		,'eBay::API::XML::DataType::PaginationResultType');
}


=head2 setPaymentsPerPage()

Indicates the number of payments that can be returned per page of data
(i.e., per call). This is the same as the value specified in the
Pagination.EntriesPerPage input (or the default value, if EntriesPerPage
was not specified). This is not necessarily the actual number of payments
returned per page (see ReturnedPaymentCountActual).

#    Argument: 'xs:int'

=cut

sub setPaymentsPerPage {
  my $self = shift;
  $self->{'PaymentsPerPage'} = shift
}

=head2 getPaymentsPerPage()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getPaymentsPerPage {
  my $self = shift;
  return $self->{'PaymentsPerPage'};
}


=head2 setReturnedPaymentCountActual()

Indicates the total number of payments returned (i.e., the number of
SellerPayment entries returned.

#    Argument: 'xs:int'

=cut

sub setReturnedPaymentCountActual {
  my $self = shift;
  $self->{'ReturnedPaymentCountActual'} = shift
}

=head2 getReturnedPaymentCountActual()

  Returned: Always
#    Returns: 'xs:int'

=cut

sub getReturnedPaymentCountActual {
  my $self = shift;
  return $self->{'ReturnedPaymentCountActual'};
}


=head2 setSellerPayment()

Information about a single payment that matches the criteria in the
request. A payment is between Half.com and a seller. Each payment is for
one transaction for one item in one order. An order can contain
transactions for multiple items from multiple sellers, but this call only
retrieves payments that are relevant to one seller. The financial value of
a payment is typically based on an amount that a buyer paid to Half.com
for a transaction, plus the shipping cost the buyer paid for the item,
minus Half.com's commission. Payments can also describe refunds that the
seller has issued. Multiple SellerPayment entries can be returned per page
of results. Typically, they are returned in reverse chronological order
(most recent PaidTime first). Only returned if payments exist that match
the request.

#    Argument: reference to an array  
                      of 'ns:SellerPaymentType'

=cut

sub setSellerPayment {
  my $self = shift;
  $self->{'SellerPayment'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSellerPayment()

  Returned: Conditionally
#    Returns: reference to an array  
                      of 'ns:SellerPaymentType'

=cut

sub getSellerPayment {
  my $self = shift;
  return $self->_getDataTypeArray('SellerPayment');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
