#!/usr/bin/perl

package eBay::API::XML::Call::GetMyeBayBuying::GetMyeBayBuyingResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMyeBayBuyingResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMyeBayBuying::GetMyeBayBuyingResponseType

=head1 DESCRIPTION

Returns items from All Buying or All Favorites in the user's My eBay account.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMyeBayBuying::GetMyeBayBuyingResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::BidGroupArrayType;
use eBay::API::XML::DataType::BuyingSummaryType;
use eBay::API::XML::DataType::ItemType;
use eBay::API::XML::DataType::MyeBayFavoriteSearchListType;
use eBay::API::XML::DataType::MyeBayFavoriteSellerListType;
use eBay::API::XML::DataType::PaginatedItemArrayType;
use eBay::API::XML::DataType::PaginatedOrderTransactionArrayType;


my @gaProperties = ( [ 'BestOfferList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'BidAssistantList', 'ns:BidGroupArrayType', ''
	     ,'eBay::API::XML::DataType::BidGroupArrayType', '1' ]
	, [ 'BidList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'BuyingSummary', 'ns:BuyingSummaryType', ''
	     ,'eBay::API::XML::DataType::BuyingSummaryType', '1' ]
	, [ 'DeletedFromLostList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'DeletedFromWonList', 'ns:PaginatedOrderTransactionArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType', '1' ]
	, [ 'FavoriteSearches', 'ns:MyeBayFavoriteSearchListType', ''
	     ,'eBay::API::XML::DataType::MyeBayFavoriteSearchListType', '1' ]
	, [ 'FavoriteSellers', 'ns:MyeBayFavoriteSellerListType', ''
	     ,'eBay::API::XML::DataType::MyeBayFavoriteSellerListType', '1' ]
	, [ 'LostList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'SecondChanceOffer', 'ns:ItemType', '1'
	     ,'eBay::API::XML::DataType::ItemType', '1' ]
	, [ 'WatchList', 'ns:PaginatedItemArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedItemArrayType', '1' ]
	, [ 'WonList', 'ns:PaginatedOrderTransactionArrayType', ''
	     ,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBestOfferList()

Contains the items the user has placed best offers on. Only returned if
items exist that meet the request criteria.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setBestOfferList {
  my $self = shift;
  $self->{'BestOfferList'} = shift
}

=head2 getBestOfferList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getBestOfferList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BestOfferList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setBidAssistantList()

Contains the items that were bid on using the Bid Assistant feature.

#    Argument: 'ns:BidGroupArrayType'

=cut

sub setBidAssistantList {
  my $self = shift;
  $self->{'BidAssistantList'} = shift
}

=head2 getBidAssistantList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:BidGroupArrayType'

=cut

sub getBidAssistantList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BidAssistantList'
		,'eBay::API::XML::DataType::BidGroupArrayType');
}


=head2 setBidList()

Contains all the items the buyer has bid on.
Only returned if items exist that meet the request criteria.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setBidList {
  my $self = shift;
  $self->{'BidList'} = shift
}

=head2 getBidList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getBidList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BidList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setBuyingSummary()

Contains a summary of the items the user has bid on. Returned at all detail levels.

#    Argument: 'ns:BuyingSummaryType'

=cut

sub setBuyingSummary {
  my $self = shift;
  $self->{'BuyingSummary'} = shift
}

=head2 getBuyingSummary()

  Returned: Always
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:BuyingSummaryType'

=cut

sub getBuyingSummary {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BuyingSummary'
		,'eBay::API::XML::DataType::BuyingSummaryType');
}


=head2 setDeletedFromLostList()

Contains the items the buyer has bid on, lost, and deleted from My eBay. 
Only returned if items exist that meet the request criteria.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setDeletedFromLostList {
  my $self = shift;
  $self->{'DeletedFromLostList'} = shift
}

=head2 getDeletedFromLostList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getDeletedFromLostList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DeletedFromLostList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setDeletedFromWonList()

Contains the items the buyer has bid on, won, and deleted from My eBay. 
Only returned if items exist that meet the request criteria.

#    Argument: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub setDeletedFromWonList {
  my $self = shift;
  $self->{'DeletedFromWonList'} = shift
}

=head2 getDeletedFromWonList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub getDeletedFromWonList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DeletedFromWonList'
		,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType');
}


=head2 setFavoriteSearches()

Contains a list of the user's favorite searches. Only returned if the 
user has Favorite Searches. The search name, search query, and search
elements, such as QueryKeywords, SortOrder, and Condition are returned.
<br /><br />
You can paste the Search Query response, that comes back as a URL, into a browser to re-play the Favorite Search.<br /><br />
The search elements that are returned by this call can be used as input
for the Shopping Web Service FindItemsAdvanced request.

#    Argument: 'ns:MyeBayFavoriteSearchListType'

=cut

sub setFavoriteSearches {
  my $self = shift;
  $self->{'FavoriteSearches'} = shift
}

=head2 getFavoriteSearches()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:MyeBayFavoriteSearchListType'

=cut

sub getFavoriteSearches {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FavoriteSearches'
		,'eBay::API::XML::DataType::MyeBayFavoriteSearchListType');
}


=head2 setFavoriteSellers()

Contains a list of the user's favorite sellers. Only returned if items
exist that meet the request criteria.

#    Argument: 'ns:MyeBayFavoriteSellerListType'

=cut

sub setFavoriteSellers {
  my $self = shift;
  $self->{'FavoriteSellers'} = shift
}

=head2 getFavoriteSellers()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:MyeBayFavoriteSellerListType'

=cut

sub getFavoriteSellers {
  my $self = shift;
  return $self->_getDataTypeInstance( 'FavoriteSellers'
		,'eBay::API::XML::DataType::MyeBayFavoriteSellerListType');
}


=head2 setLostList()

Contains the items the user has bid on and lost. Only returned if items
exist that meet the request criteria.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setLostList {
  my $self = shift;
  $self->{'LostList'} = shift
}

=head2 getLostList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getLostList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LostList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setSecondChanceOffer()

Contains the list of second chance offers the user has received. Only
returned if items exist that meet the request criteria.

#    Argument: reference to an array  
                      of 'ns:ItemType'

=cut

sub setSecondChanceOffer {
  my $self = shift;
  $self->{'SecondChanceOffer'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSecondChanceOffer()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: reference to an array  
                      of 'ns:ItemType'

=cut

sub getSecondChanceOffer {
  my $self = shift;
  return $self->_getDataTypeArray('SecondChanceOffer');
}


=head2 setWatchList()

Contains the items the user is watching. Only returned if items exist that
meet the request criteria.

#    Argument: 'ns:PaginatedItemArrayType'

=cut

sub setWatchList {
  my $self = shift;
  $self->{'WatchList'} = shift
}

=head2 getWatchList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedItemArrayType'

=cut

sub getWatchList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'WatchList'
		,'eBay::API::XML::DataType::PaginatedItemArrayType');
}


=head2 setWonList()

Contains the items the user has bid on and won. Only returned if items
exist that meet the request criteria.

#    Argument: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub setWonList {
  my $self = shift;
  $self->{'WonList'} = shift
}

=head2 getWonList()

  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
#    Returns: 'ns:PaginatedOrderTransactionArrayType'

=cut

sub getWonList {
  my $self = shift;
  return $self->_getDataTypeInstance( 'WonList'
		,'eBay::API::XML::DataType::PaginatedOrderTransactionArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
