#!/usr/bin/perl

package eBay::API::XML::DataType::AddressType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. AddressType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::AddressType

=head1 DESCRIPTION

Contains the data for one user address. This is the base type for a
number of user addresses, including seller payment address, buyer
shipping address and buyer and seller registration address.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::AddressType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::AddressOwnerCodeType;
use eBay::API::XML::DataType::Enum::AddressRecordTypeCodeType;
use eBay::API::XML::DataType::Enum::AddressStatusCodeType;
use eBay::API::XML::DataType::Enum::CountryCodeType;


my @gaProperties = ( [ 'AddressID', 'xs:string', '', '', '' ]
	, [ 'AddressOwner', 'ns:AddressOwnerCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AddressOwnerCodeType', '' ]
	, [ 'AddressRecordType', 'ns:AddressRecordTypeCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AddressRecordTypeCodeType', '' ]
	, [ 'AddressStatus', 'ns:AddressStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::AddressStatusCodeType', '' ]
	, [ 'CityName', 'xs:string', '', '', '' ]
	, [ 'CompanyName', 'xs:string', '', '', '' ]
	, [ 'Country', 'ns:CountryCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CountryCodeType', '' ]
	, [ 'CountryName', 'xs:string', '', '', '' ]
	, [ 'County', 'xs:string', '', '', '' ]
	, [ 'ExternalAddressID', 'xs:string', '', '', '' ]
	, [ 'FirstName', 'xs:string', '', '', '' ]
	, [ 'InternationalName', 'xs:string', '', '', '' ]
	, [ 'InternationalStateAndCity', 'xs:string', '', '', '' ]
	, [ 'InternationalStreet', 'xs:string', '', '', '' ]
	, [ 'LastName', 'xs:string', '', '', '' ]
	, [ 'Name', 'xs:string', '', '', '' ]
	, [ 'Phone', 'xs:string', '', '', '' ]
	, [ 'Phone2', 'xs:string', '', '', '' ]
	, [ 'Phone2AreaOrCityCode', 'xs:string', '', '', '' ]
	, [ 'Phone2CountryCode', 'ns:CountryCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CountryCodeType', '' ]
	, [ 'Phone2CountryPrefix', 'xs:string', '', '', '' ]
	, [ 'Phone2LocalNumber', 'xs:string', '', '', '' ]
	, [ 'PhoneAreaOrCityCode', 'xs:string', '', '', '' ]
	, [ 'PhoneCountryCode', 'ns:CountryCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CountryCodeType', '' ]
	, [ 'PhoneCountryPrefix', 'xs:string', '', '', '' ]
	, [ 'PhoneLocalNumber', 'xs:string', '', '', '' ]
	, [ 'PostalCode', 'xs:string', '', '', '' ]
	, [ 'StateOrProvince', 'xs:string', '', '', '' ]
	, [ 'Street', 'xs:string', '', '', '' ]
	, [ 'Street1', 'xs:string', '', '', '' ]
	, [ 'Street2', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAddressID()

ID assigned to the address in the eBay database.
For GetOrders, applies only to Half.com.

#    Argument: 'xs:string'

=cut

sub setAddressID {
  my $self = shift;
  $self->{'AddressID'} = shift
}

=head2 getAddressID()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getAddressID {
  my $self = shift;
  return $self->{'AddressID'};
}


=head2 setAddressOwner()

The realm to which the address belongs (e.g. eBay vs PayPal).
For GetOrders, applies only to Half.com.

#    Argument: 'ns:AddressOwnerCodeType'

=cut

sub setAddressOwner {
  my $self = shift;
  $self->{'AddressOwner'} = shift
}

=head2 getAddressOwner()

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

#    Returns: 'ns:AddressOwnerCodeType'

=cut

sub getAddressOwner {
  my $self = shift;
  return $self->{'AddressOwner'};
}


=head2 setAddressRecordType()

Indicates the nature of the address (e.g., residential or business).
Not applicable to Half.com.

#    Argument: 'ns:AddressRecordTypeCodeType'

=cut

sub setAddressRecordType {
  my $self = shift;
  $self->{'AddressRecordType'} = shift
}

=head2 getAddressRecordType()

#    Returns: 'ns:AddressRecordTypeCodeType'

=cut

sub getAddressRecordType {
  my $self = shift;
  return $self->{'AddressRecordType'};
}


=head2 setAddressStatus()

PayPal address status.
Not applicable to Half.com.

#    Argument: 'ns:AddressStatusCodeType'

=cut

sub setAddressStatus {
  my $self = shift;
  $self->{'AddressStatus'} = shift
}

=head2 getAddressStatus()

#    Returns: 'ns:AddressStatusCodeType'

=cut

sub getAddressStatus {
  my $self = shift;
  return $self->{'AddressStatus'};
}


=head2 setCityName()

The name of the user's city.
Also applicable to Half.com (for GetOrders).

MaxLength: 64

#    Argument: 'xs:string'

=cut

sub setCityName {
  my $self = shift;
  $self->{'CityName'} = shift
}

=head2 getCityName()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetUserContactDetails
  Returned: Always

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getCityName {
  my $self = shift;
  return $self->{'CityName'};
}


=head2 setCompanyName()

User's company name. Only returned if available.
Not applicable to Half.com.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setCompanyName {
  my $self = shift;
  $self->{'CompanyName'} = shift
}

=head2 getCompanyName()

  Calls: GetUserContactDetails
  Returned: Always

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

#    Returns: 'xs:string'

=cut

sub getCompanyName {
  my $self = shift;
  return $self->{'CompanyName'};
}


=head2 setCountry()

The country code of the user.<br>
<br>
If not provided as input for GetCart or SetCart, eBay uses the country associated
with the SiteID in effect when the call is made.<br>
<br>
Also applicable to Half.com (for GetOrders).

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:CountryCodeType'

=cut

sub setCountry {
  my $self = shift;
  $self->{'Country'} = shift
}

=head2 getCountry()

  Calls: GetAllBidders
         GetHighBidders
         GetUserContactDetails
  Returned: Always

  Calls: GetBidderList
         GetUserPreferences
  Returned: Conditionally

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress
           ShippingAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

#    Returns: 'ns:CountryCodeType'

=cut

sub getCountry {
  my $self = shift;
  return $self->{'Country'};
}


=head2 setCountryName()

The name of the user's country.
Also applicable to Half.com (for GetOrders).

#    Argument: 'xs:string'

=cut

sub setCountryName {
  my $self = shift;
  $self->{'CountryName'} = shift
}

=head2 getCountryName()

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getCountryName {
  my $self = shift;
  return $self->{'CountryName'};
}


=head2 setCounty()

County information for the user.
This field applies to Classified Ad format listings and to the UK only.
Not applicable to Half.com.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setCounty {
  my $self = shift;
  $self->{'County'} = shift
}

=head2 getCounty()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'xs:string'

=cut

sub getCounty {
  my $self = shift;
  return $self->{'County'};
}


=head2 setExternalAddressID()

ID assigned to the address by the owner of the address (fitting
only if the address is owned by PayPal; see AddressOwner).
Also applicable to Half.com (for GetOrders).

MaxLength: 20

#    Argument: 'xs:string'

=cut

sub setExternalAddressID {
  my $self = shift;
  $self->{'ExternalAddressID'} = shift
}

=head2 getExternalAddressID()

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:string'

=cut

sub getExternalAddressID {
  my $self = shift;
  return $self->{'ExternalAddressID'};
}


=head2 setFirstName()

Displays the first name of the seller (in a business card 
format) if the seller's SellerBusinessCodeType is set to 
'Commercial'.

#    Argument: 'xs:string'

=cut

sub setFirstName {
  my $self = shift;
  $self->{'FirstName'} = shift
}

=head2 getFirstName()

  Calls: GetItem
         GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getFirstName {
  my $self = shift;
  return $self->{'FirstName'};
}


=head2 setInternationalName()

Seller's international name that is associated with the payment address.
Only applicable to SellerPaymentAddress.
Not applicable to Half.com.

#    Argument: 'xs:string'

=cut

sub setInternationalName {
  my $self = shift;
  $self->{'InternationalName'} = shift
}

=head2 getInternationalName()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

#    Returns: 'xs:string'

=cut

sub getInternationalName {
  my $self = shift;
  return $self->{'InternationalName'};
}


=head2 setInternationalStateAndCity()

International state and city for the seller's payment address.
Only applicable to SellerPaymentAddress.
Not applicable to Half.com.

#    Argument: 'xs:string'

=cut

sub setInternationalStateAndCity {
  my $self = shift;
  $self->{'InternationalStateAndCity'} = shift
}

=head2 getInternationalStateAndCity()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

#    Returns: 'xs:string'

=cut

sub getInternationalStateAndCity {
  my $self = shift;
  return $self->{'InternationalStateAndCity'};
}


=head2 setInternationalStreet()

Seller's international street address that is associated with the payment address.
Only applicable to SellerPaymentAddress.
Not applicable to Half.com.

#    Argument: 'xs:string'

=cut

sub setInternationalStreet {
  my $self = shift;
  $self->{'InternationalStreet'} = shift
}

=head2 getInternationalStreet()

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

#    Returns: 'xs:string'

=cut

sub getInternationalStreet {
  my $self = shift;
  return $self->{'InternationalStreet'};
}


=head2 setLastName()

Displays the last name of the seller (in a business card 
format) if the seller's SellerBusinessCodeType is set to 
'Commercial'.

#    Argument: 'xs:string'

=cut

sub setLastName {
  my $self = shift;
  $self->{'LastName'} = shift
}

=head2 getLastName()

  Calls: GetItem
         GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll

#    Returns: 'xs:string'

=cut

sub getLastName {
  my $self = shift;
  return $self->{'LastName'};
}


=head2 setName()

User's name for the address.
Also applicable to Half.com (for GetOrders).

MaxLength: 64

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetUserContactDetails
  Returned: Always

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setPhone()

User's primary phone number. This may return a value of
"Invalid Request" if you are not authorized to see the
user's phone number.
Also applicable to Half.com (for GetOrders).

#    Argument: 'xs:string'

=cut

sub setPhone {
  my $self = shift;
  $self->{'Phone'} = shift
}

=head2 getPhone()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetUserContactDetails
  Returned: Always

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getPhone {
  my $self = shift;
  return $self->{'Phone'};
}


=head2 setPhone2()

Secondary Phone number of the lead. Not returned if information is unavailable.

#    Argument: 'xs:string'

=cut

sub setPhone2 {
  my $self = shift;
  $self->{'Phone2'} = shift
}

=head2 getPhone2()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:string'

=cut

sub getPhone2 {
  my $self = shift;
  return $self->{'Phone2'};
}


=head2 setPhone2AreaOrCityCode()

Area or City Code of a user's secondary phone number.
This field applies to Classified Ad format listings only.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPhone2AreaOrCityCode {
  my $self = shift;
  $self->{'Phone2AreaOrCityCode'} = shift
}

=head2 getPhone2AreaOrCityCode()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'xs:string'

=cut

sub getPhone2AreaOrCityCode {
  my $self = shift;
  return $self->{'Phone2AreaOrCityCode'};
}


=head2 setPhone2CountryCode()

Standard ISO code for the country of a user's secondary telephone phone
number. For Classifed Ad format listings, this code is used to look up the
country's international calling prefix. Both the ISO code and country phone
prefix are stored with listings of this type.
This field applies to Classified Ad format listings only.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:CountryCodeType'

=cut

sub setPhone2CountryCode {
  my $self = shift;
  $self->{'Phone2CountryCode'} = shift
}

=head2 getPhone2CountryCode()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'ns:CountryCodeType'

=cut

sub getPhone2CountryCode {
  my $self = shift;
  return $self->{'Phone2CountryCode'};
}


=head2 setPhone2CountryPrefix()

Country prefix of a user's secondary phone number. This value is derived from
inputs supplied for Phone2CountryCode.
This field applies to Classified Ad format listings only.

#    Argument: 'xs:string'

=cut

sub setPhone2CountryPrefix {
  my $self = shift;
  $self->{'Phone2CountryPrefix'} = shift
}

=head2 getPhone2CountryPrefix()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'xs:string'

=cut

sub getPhone2CountryPrefix {
  my $self = shift;
  return $self->{'Phone2CountryPrefix'};
}


=head2 setPhone2LocalNumber()

The local number portion of the user's secondary phone number.
This field applies to Classified Ad format listings only.
<br>
<b>Note:</b> The full secondary phone number is constructed by
combining Phone2LocalNumber with Phone2AreaOrCityCode and Phone2CountryPrefix.
Starting with API release 497, the full phone number can be entered in
Phone2LocalNumber. Refer to the release notes for additional information.

MaxLength: 30

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPhone2LocalNumber {
  my $self = shift;
  $self->{'Phone2LocalNumber'} = shift
}

=head2 getPhone2LocalNumber()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'xs:string'

=cut

sub getPhone2LocalNumber {
  my $self = shift;
  return $self->{'Phone2LocalNumber'};
}


=head2 setPhoneAreaOrCityCode()

Area or City Code of a user's primary phone number.
This field applies to Classified Ad format listings only.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPhoneAreaOrCityCode {
  my $self = shift;
  $self->{'PhoneAreaOrCityCode'} = shift
}

=head2 getPhoneAreaOrCityCode()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'xs:string'

=cut

sub getPhoneAreaOrCityCode {
  my $self = shift;
  return $self->{'PhoneAreaOrCityCode'};
}


=head2 setPhoneCountryCode()

Standard ISO code for the country of the user's primay telephone phone number.
For Classifed Ad format listings, this code is used to look up the country's
international calling prefix. Both the ISO code and country phone prefix are
stored with listings of this type.
This field applies to Classified Ad format listings only.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'ns:CountryCodeType'

=cut

sub setPhoneCountryCode {
  my $self = shift;
  $self->{'PhoneCountryCode'} = shift
}

=head2 getPhoneCountryCode()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'ns:CountryCodeType'

=cut

sub getPhoneCountryCode {
  my $self = shift;
  return $self->{'PhoneCountryCode'};
}


=head2 setPhoneCountryPrefix()

Country Prefix of the secondary phone number. This value is derived from
inputs supplied for PhoneCountryCode.
This field applies to Classified Ad format listings only.

#    Argument: 'xs:string'

=cut

sub setPhoneCountryPrefix {
  my $self = shift;
  $self->{'PhoneCountryPrefix'} = shift
}

=head2 getPhoneCountryPrefix()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'xs:string'

=cut

sub getPhoneCountryPrefix {
  my $self = shift;
  return $self->{'PhoneCountryPrefix'};
}


=head2 setPhoneLocalNumber()

The local number portion of the user's primary phone number.
This field applies to Classified Ad format listings only.
<br>
<b>Note:</b> The full primary phone number is constructed by
combining PhoneLocalNumber with PhoneAreaOrCityCode and PhoneCountryPrefix.
Starting with API release 497, the full phone number can be entered in
PhoneLocalNumber. Refer to the release notes for additional information.

MaxLength: 30

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setPhoneLocalNumber {
  my $self = shift;
  $self->{'PhoneLocalNumber'} = shift
}

=head2 getPhoneLocalNumber()

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

#    Returns: 'xs:string'

=cut

sub getPhoneLocalNumber {
  my $self = shift;
  return $self->{'PhoneLocalNumber'};
}


=head2 setPostalCode()

User's postal code.<br>
<br>
If not provided as input for GetCart or SetCart, eBay uses the country associated
with the SiteID in effect when the call is made.<br>
<br>
Also applicable to Half.com (for GetOrders).

MaxLength: 12

#    Argument: 'xs:string'

=cut

sub setPostalCode {
  my $self = shift;
  $self->{'PostalCode'} = shift
}

=head2 getPostalCode()

  Calls: GetBidderList
  Returned: Conditionally

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
           GranularityLevel: Fine

  Context: HighBidder

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress
           ShippingAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetMyeBaySelling
  Returned: Conditionally
  Details: DetailLevel: none, ReturnSummary, ReturnAll
  Context: SoldList

  Calls: GetAllBidders
         GetHighBidders
  Returned: Always

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getPostalCode {
  my $self = shift;
  return $self->{'PostalCode'};
}


=head2 setStateOrProvince()

The region of the user's address.
Also applicable to Half.com (for GetOrders).

MaxLength: 64

#    Argument: 'xs:string'

=cut

sub setStateOrProvince {
  my $self = shift;
  $self->{'StateOrProvince'} = shift
}

=head2 getStateOrProvince()

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetUserContactDetails
  Returned: Always

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getStateOrProvince {
  my $self = shift;
  return $self->{'StateOrProvince'};
}


=head2 setStreet()

A concatenation of Street1 and Street2, primarily for RegistrationAddress.
Not applicable to Half.com.

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setStreet {
  my $self = shift;
  $self->{'Street'} = shift
}

=head2 getStreet()

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

#    Returns: 'xs:string'

=cut

sub getStreet {
  my $self = shift;
  return $self->{'Street'};
}


=head2 setStreet1()

Line 1 of the user's street address.
Also applicable to Half.com (for GetOrders).

MaxLength: 100

#    Argument: 'xs:string'

=cut

sub setStreet1 {
  my $self = shift;
  $self->{'Street1'} = shift
}

=head2 getStreet1()

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetAdFormatLeads
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getStreet1 {
  my $self = shift;
  return $self->{'Street1'};
}


=head2 setStreet2()

Line 2 of the user's address (such as an apartment number).
Returned if the user specified a second street value for their address.
Also applicable to Half.com (for GetOrders).<br>
In case of Item.SellerContactDetails, Street2 can be used to provide City, Address, State, and Zip code (if applicable).

MaxLength: 100

  Calls: AddItem
         RelistItem
         ReviseItem
         VerifyAddItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setStreet2 {
  my $self = shift;
  $self->{'Street2'} = shift
}

=head2 getStreet2()

  Calls: GetBidderList
  Returned: Conditionally
  Context: ShippingAddress

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnAttributes, ItemReturnDescription, ReturnAll
  Context: RegistrationAddress

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: SellerContactDetails

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ReturnAll
  Context: ShippingAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll, ReturnSummary, none
  Context: RegistrationAddress

  Calls: GetUser
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: SellerPaymentAddress

  Calls: GetOrders
  Returned: Always
  Details: DetailLevel: none

  Calls: GetOrderTransactions
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getStreet2 {
  my $self = shift;
  return $self->{'Street2'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
