#!/usr/bin/perl

package eBay::API::XML::DataType::ErrorParameterType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ErrorParameterType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ErrorParameterType

=head1 DESCRIPTION

A variable that contains specific information about the context of this error.
For example, if you pass in an attribute set ID that does not match
the specified category, the attribute set ID might be returned as an error parameter.
Use error parameters to flag fields that users need to correct.
Also use error parameters to distinguish between errors when multiple
errors are returned.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ErrorParameterType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Value', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'ParamID', 'xs:string', '', '', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setValue()

The value of the variable (e.g., the attribute set ID)

#    Argument: 'xs:string'

=cut

sub setValue {
  my $self = shift;
  $self->{'Value'} = shift
}

=head2 getValue()

  Calls:   Returned: Conditionally
  AllCalls: 

#    Returns: 'xs:string'

=cut

sub getValue {
  my $self = shift;
  return $self->{'Value'};
}




=head2 setParamID()

The index of the parameter in the list of parameter types returned
within the error type.

#    Argument: 'xs:string'

=cut

sub setParamID {
  my $self = shift;
  $self->{'ParamID'} = shift
}

=head2 getParamID()

  Calls:   Returned: Conditionally
  AllCalls: 

#    Returns: 'xs:string'

=cut

sub getParamID {
  my $self = shift;
  return $self->{'ParamID'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
