use strict;
use warnings;

use MARC::Leader;
use Test::More 'tests' => 17;
use Test::NoWarnings;

# Test.
my $obj = MARC::Leader->new;
my $ret = $obj->parse('02200cem a2200541 i 4500');
is($ret->length, 2200, 'Get length (2200).');
is($ret->status, 'c', 'Get status (c).');
is($ret->type, 'e', 'Get type (e).');
is($ret->bibliographic_level, 'm', 'Get bibliographic level (m).');
is($ret->type_of_control, ' ', 'Get type of control ( ).');
is($ret->char_encoding_scheme, 'a', 'Get character encoding scheme (a).');
is($ret->indicator_count, '2', 'Get indicator count (2).');
is($ret->subfield_code_count, '2', 'Get subfield code count (2).');
is($ret->data_base_addr, 541, 'Get data base address (541).');
is($ret->encoding_level, ' ', 'Get encoding level ( ).');
is($ret->descriptive_cataloging_form, 'i', 'Get descriptive cataloging form (i).');
is($ret->multipart_resource_record_level, ' ', 'Get multipart resource record level ( ).');
is($ret->length_of_field_portion_len, '4', 'Get length of the length-of-field portion (4).');
is($ret->starting_char_pos_portion_len, '5', 'Get length of the starting-character-position portion (5).');
is($ret->impl_def_portion_len, '0', 'Get length of the implementation-defined portion (0).');
is($ret->undefined, '0', 'Get undefined (0).');
