# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250605193632;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '14',
                  'pattern' => '(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '[18]',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              485|
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463
          )\\d{3,10}|
          648[34]\\d{3,9}|
          (?:
            51|
            66|
            73
          )2\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-7]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463
          )\\d{3,10}|
          648[34]\\d{3,9}|
          (?:
            51|
            66|
            73
          )2\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-7]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            485|
            (?:
              5[0-3579]|
              6[013-9]|
              [7-9]\\d
            )\\d
          )\\d{3,9}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"436242", "Rußbach\ am\ Paß\ Gschütt",
"432674", "Weißenbach\ an\ der\ Triesting",
"437219", "Vorderweißenbach",
"432263", "Großrußbach",
"434226", "Sankt\ Margareten\ im\ Rosental",
"432756", "Sankt\ Leonhard\ am\ Forst",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"432249", "Groß\-Enzersdorf",
"432822", "Zwettl\-Niederösterreich",
"433575", "Sankt\ Johann\ am\ Tauern",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"432686", "Draßburg",
"433469", "Sankt\ Oswald\ im\ Freiland",
"437477", "Sankt\ Peter\ in\ der\ Au",
"436414", "Großarl",
"435352", "Sankt\ Johann\ in\ Tirol",
"437254", "Großraming",
"433632", "Sankt\ Gallen",
"433464", "Groß\ Sankt\ Florian",
"4315", "Wien",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"433585", "Sankt\ Lambrecht",
"432857", "Bad\ Großpertholz",
"432955", "Großweikersdorf",
"436277", "Sankt\ Pantaleon",
"432719", "Droß",
"437717", "Sankt\ Aegidi",
"434877", "Prägraten\ am\ Großvenediger",
"432618", "Markt\ Sankt\ Martin",
"434783", "Reißeck",
"432642", "Aspangberg\-Sankt\ Peter",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"432847", "Groß\-Siegharts",
"433868", "Tragöß",
"4313", "Wien",
"436241", "Sankt\ Koloman",
"437565", "Sankt\ Pankraz",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"433834", "Wald\ am\ Schoberpaß",
"434286", "Weißbriach",
"432629", "Warth\,\ Niederösterreich",
"4316", "Wien",
"436227", "Sankt\ Gilgen",
"436276", "Nußdorf\ am\ Haunsberg",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"436215", "Straßwalchen",
"434876", "Kals\ am\ Großglockner",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"433119", "Sankt\ Marein\ bei\ Graz",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"4319", "Wien",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"4314", "Wien",
"434879", "Sankt\ Veit\ in\ Defereggen",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"432812", "Groß\ Gerungs",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"436247", "Großgmain",
"435446", "Sankt\ Anton\ am\ Arlberg",
"432556", "Großkrut",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"433684", "Sankt\ Martin\ am\ Grimming",
"437667", "Sankt\ Georgen\ im\ Attergau",
"433864", "Sankt\ Marein\ im\ Mürztal",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"435279", "Sankt\ Jodok\ am\ Brenner",
"432617", "Draßmarkt",
"435449", "Fließ",
"437956", "Unterweißenbach",
"436477", "Sankt\ Michael\ im\ Lungau",
"437224", "Sankt\ Florian",
"432815", "Großschönau",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"437566", "Rosenau\ am\ Hengstpaß",
"433386", "Großsteinbach",
"4317", "Wien",
"434253", "Sankt\ Jakob\ im\ Rosental",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"433327", "Sankt\ Michael\ im\ Burgenland",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"433158", "Sankt\ Anna\ am\ Aigen",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"432742", "Sankt\ Pölten",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"437954", "Sankt\ Georgen\ am\ Walde",
"432647", "Krumbach\,\ Niederösterreich",
"432242", "Sankt\ Andrä\-Wördern",
"434843", "Außervillgraten",
"437751", "Sankt\ Martin\ im\ Innkreis",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"432233", "Preßbaum",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"4312", "Wien",
"434266", "Straßburg",
"432823", "Großglobnitz",
"4318", "Wien",
"436565", "Neukirchen\ am\ Großvenediger",
"434358", "Sankt\ Andrä",
"437435", "Sankt\ Valentin",
"434785", "Außerfragant",
"435245", "Hinterriß",
"433537", "Sankt\ Georgen\ ob\ Murau",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"436412", "Sankt\ Johann\ im\ Pongau",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"435557", "Sankt\ Gallenkirch",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"435678", "Weißenbach\ am\ Lech",
"437218", "Großtraberg",
"434825", "Großkirchheim",
"432268", "Großmugl",
"434264", "Klein\ Sankt\ Paul",
"433362", "Großpetersdorf",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",};
$areanames{en} = {"433328", "Kukmirn",
"432753", "Gansbach",
"435412", "Imst",
"436233", "Oberwang",
"433125", "Übelbach",
"436472", "Mauterndorf",
"432984", "Eggenburg",
"437948", "Hirschbach\ im\ Mühlkreis",
"432174", "Wallern\ im\ Burgenland",
"434354", "Preitenegg",
"435376", "Thiersee",
"432637", "Grünbach\ am\ Schneeberg",
"436131", "Obertraun",
"433516", "Kleinlobming",
"437757", "Gurten",
"436229", "Hof\ bei\ Salzburg",
"432246", "Gerasdorf\ bei\ Wien",
"437254", "Grossraming",
"436456", "Obertauern",
"432627", "Pitten",
"433135", "Kalsdorf\ bei\ Graz",
"435352", "St\.\ Johann\ in\ Tirol",
"436223", "Anthering",
"433338", "Lafnitz",
"432846", "Raabs\ an\ der\ Thaya",
"437728", "Schwand\ im\ Innkreis",
"433144", "Köflach",
"434715", "Kötschach\-Mauthen",
"435238", "Zirl",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432641", "Kirchberg\ am\ Wechsel",
"433638", "Palfau",
"435523", "Götzis",
"433575", "St\.\ Johann\ am\ Tauern",
"433852", "Mürzzuschlag",
"434233", "Griffen",
"432524", "Kautendorf",
"432822", "Zwettl\,\ Lower\ Austria",
"43662", "Salzburg",
"433357", "Pinkafeld",
"437477", "St\.\ Peter\ in\ der\ Au",
"433463", "Stainz",
"437216", "Helfenberg",
"436414", "Grossarl",
"435474", "Pfunds",
"435676", "Jungholz",
"432534", "Niedersulz",
"434223", "Maria\ Saal",
"432232", "Fischamend",
"433680", "Donnersbachwald",
"434823", "Tresdorf\,\ Rangersdorf",
"435280", "Hochfügen",
"432266", "Stockerau",
"433469", "St\.\ Oswald\ im\ Freiland",
"434229", "Krumpendorf\ am\ Wörther\ See",
"432686", "Drassburg",
"437448", "Kematen\ an\ der\ Ybbs",
"437662", "Seewalchen\ am\ Attersee",
"432756", "St\.\ Leonhard\ am\ Forst",
"437434", "Haag",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"437282", "Neufelden",
"432577", "Asparn\ an\ der\ Zaya",
"434784", "Mallnitz",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"437744", "Munderfing",
"434242", "Villach",
"435373", "Ebbs",
"432612", "Oberpullendorf",
"434842", "Sillian",
"437584", "Molln",
"433364", "Hannersdorf",
"436564", "Krimml",
"433513", "Bischoffeld",
"432772", "Neulengbach",
"432243", "Klosterneuburg",
"437278", "Neukirchen\ am\ Walde",
"436453", "Filzmoos",
"432952", "Hollabrunn",
"432849", "Schwarzenau",
"436226", "Fuschl\ am\ See",
"435244", "Jenbach",
"432249", "Gross\-Enzersdorf",
"433335", "Pöllau",
"437247", "Kematen\ am\ Innbach",
"432843", "Dobersberg",
"433635", "Radmer",
"432915", "Drosendorf\-Zissersdorf",
"435550", "Thüringen",
"434718", "Dellach",
"432714", "Rossatz",
"436544", "Rauris",
"435526", "Laterns",
"436242", "Russbach\ am\ Pass\ Gschütt",
"433157", "Kapfenstein",
"434236", "Eberndorf",
"435441", "See",
"434262", "Treibach",
"437221", "Hörsching",
"437764", "Riedau",
"433578", "Obdach",
"435264", "Mieming",
"437213", "Bad\ Leonfelden",
"433466", "Eibiswald",
"432269", "Niederfellabrunn",
"435673", "Ehrwald",
"437267", "Mönchdorf",
"437231", "Herzogsdorf",
"432689", "Hornstein",
"432863", "Eggern",
"434226", "St\.\ Margareten\ im\ Rosental",
"435225", "Fulpmes",
"433171", "Gasen",
"437445", "Hollenstein\ an\ der\ Ybbs",
"433582", "Scheifling",
"433884", "Wegscheid",
"434826", "Mörtschach",
"437219", "Vorderweissenbach",
"432263", "Grossrussbach",
"437735", "Gaspoltshofen",
"432683", "Purbach\ am\ Neusiedler\ See",
"432674", "Weissenbach\ an\ der\ Triesting",
"435243", "Maurach",
"434848", "Kartitsch",
"432844", "Karlstein\ an\ der\ Thaya",
"434277", "Glanegg",
"432618", "Markt\ St\.\ Martin",
"432782", "Herzogenburg",
"434248", "Treffen",
"437288", "Ulrichsberg",
"434877", "Prägraten\ am\ Grossvenediger",
"433457", "Gleinstätten",
"432244", "Langenzersdorf",
"436475", "Ramingstein",
"436454", "Mandling",
"437256", "Ternberg",
"433132", "Kumberg",
"432747", "Ober\-Grafendorf",
"435374", "Walchsee",
"435355", "Jochberg",
"437583", "Kremsmünster",
"432160", "Jois",
"437230", "Altenberg\ bei\ Linz",
"433514", "Seckau",
"435577", "Lustenau",
"436563", "Uttendorf",
"433363", "Rechnitz",
"433170", "Fischbach",
"437433", "Wallsee",
"432958", "Maissau",
"437272", "Eferding",
"434783", "Reisseck",
"432986", "Irnfritz",
"437743", "Maria\ Schmolln",
"434356", "Lavamünd",
"432176", "Tadten",
"434268", "Friesach",
"433572", "Judenburg",
"433883", "Terz",
"433855", "Krieglach",
"432264", "Rückersdorf\,\ Harmannsdorf",
"432825", "Göpfritz\ an\ der\ Wild",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432684", "Schützen\ am\ Gebirge",
"435263", "Silz",
"436277", "St\.\ Pantaleon",
"436416", "Lend",
"4346", "Klagenfurt",
"437214", "Reichenthal",
"434712", "Greifenburg",
"435674", "Bichlbach",
"435476", "Serfaus",
"433617", "Gaishorn\ am\ See",
"432536", "Drösing",
"432864", "Kautzen",
"432235", "Maria\-Lanzendorf",
"437717", "St\.\ Aegidi",
"432526", "Stronsdorf",
"436549", "Piesendorf",
"437763", "Kopfing\ im\ Innkreis",
"432719", "Dross",
"433588", "Katsch\ an\ der\ Mur",
"432767", "Hohenberg",
"432731", "Idolsberg",
"433146", "Modriach",
"432713", "Spitz",
"436543", "Taxenbach",
"436224", "Hintersee",
"435246", "Achenkirch",
"432615", "Lutzmannsburg",
"432257", "Klausen\-Leopoldsdorf",
"437259", "Sierning",
"437665", "Unterach\ am\ Attersee",
"436478", "Zederhaus",
"437942", "Freistadt",
"435418", "Schönwies",
"437253", "Wolfern",
"437285", "Hofkirchen\ im\ Mühlkreis",
"433322", "Güssing",
"432857", "Bad\ Grosspertholz",
"434245", "Feistritz\ an\ der\ Drau",
"432271", "Ried\ am\ Riederberg",
"433861", "Aflenz",
"437586", "Pettenbach",
"432989", "Brunn\ an\ der\ Wild",
"433117", "Eggersdorf\ bei\ Graz",
"433332", "Hartberg",
"434359", "Reichenfels",
"435358", "Ellmau",
"433366", "Kohfidisch",
"436566", "Bramberg\ am\ Wildkogel",
"432754", "Loosdorf",
"435510", "Damüls",
"436234", "Zell\ am\ Moos",
"432983", "Sigmundsherberg",
"432955", "Grossweikersdorf",
"437746", "Friedburg",
"434353", "Prebl",
"432173", "Gols",
"432828", "Rappottenstein",
"436245", "Hallein",
"433886", "Weichselboden",
"435337", "Brixlegg",
"434824", "Heiligenblut",
"433858", "Mitterdorf\ im\ Mürztal",
"434265", "Weitensfeld\ im\ Gurktal",
"437487", "Gresten",
"433632", "St\.\ Gallen",
"435266", "Ötztal\-Bahnhof",
"436413", "Wagrain",
"433464", "Gross\ St\.\ Florian",
"435232", "Kematen\ in\ Tirol",
"432912", "Geras",
"436467", "Mühlbach\ am\ Hochkönig",
"435473", "Nauders",
"437722", "Braunau\ am\ Inn",
"434761", "Stockenboi",
"432533", "Neusiedl\ an\ der\ Zaya",
"434224", "Pischeldorf",
"437442", "Waidhofen\ an\ der\ Ybbs",
"433585", "St\.\ Lambrecht",
"433149", "Geistthal",
"433622", "Bad\ Aussee",
"434234", "Ruden",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"437732", "Haag\ am\ Hausruck",
"437766", "Andorf",
"432238", "Kaltenleutgeben",
"433143", "Krottendorf",
"4315", "Vienna",
"432716", "Gföhl",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"435524", "Satteins",
"433532", "Murau",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"432948", "Weitersfeld",
"435558", "Gaschurn",
"434710", "Oberdrauburg",
"433834", "Wald\ am\ Schoberpass",
"437753", "Eberschwang",
"432633", "Markt\ Piesting",
"433114", "Markt\ Hartmannsdorf",
"432757", "Pöchlarn",
"437281", "Aigen\ im\ Mühlkreis",
"437759", "Antiesenhofen",
"435634", "Elbigenalp",
"432639", "Bad\ Fischau",
"432576", "Ernstbrunn",
"432275", "Atzenbrugg",
"432254", "Ebreichsdorf",
"433865", "Kindberg",
"436227", "St\.\ Gilgen",
"434258", "Gummern",
"432629", "Warth\,\ Lower\ Austria",
"4316", "Vienna",
"434286", "Weissbriach",
"432142", "Gattendorf",
"437246", "Gunskirchen",
"433685", "Gröbming",
"435285", "Mayrhofen",
"435253", "Längenfeld",
"432854", "Kirchberg\ am\ Walde",
"432875", "Grafenschlag",
"432951", "Guntersdorf",
"432623", "Pottendorf",
"434858", "Nikolsdorf",
"432552", "Poysdorf",
"437565", "St\.\ Pankraz",
"436241", "St\.\ Koloman",
"432728", "Wienerbruck",
"433385", "Ilz",
"433353", "Oberschützen",
"435442", "Landeck",
"434237", "Miklauzhof",
"4313", "Vienna",
"433359", "Loipersdorf\-Kitzladen",
"435334", "Westendorf",
"433172", "Weiz",
"433581", "Oberwölz",
"437479", "Ardagger",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"433845", "Mautern\ in\ Steiermark",
"433467", "Schwanberg",
"432816", "Karlstift",
"437473", "Blindenmarkt",
"437484", "Göstling\ an\ der\ Ybbs",
"434734", "Rennweg",
"434227", "Ferlach",
"432162", "Bruck\ an\ der\ Leitha",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"437266", "Bad\ Kreuzen",
"432738", "Fels\ am\ Wagram",
"432282", "Gänserndorf",
"432744", "Kasten\ bei\ Böheimkirchen",
"435230", "Sellrain",
"435583", "Lech",
"435574", "Bregenz",
"432662", "Gloggnitz",
"436132", "Bad\ Ischl",
"432636", "Puchberg\ am\ Schneeberg",
"437355", "Weyer",
"432945", "Zellerndorf",
"435272", "Steinach\ am\ Brenner",
"436471", "Tweng",
"436212", "Seekirchen\ am\ Wallersee",
"437612", "Gmunden",
"432573", "Wilfersdorf",
"437952", "Weitersfelden",
"434283", "St\.\ Stefan\ im\ Gailtal",
"434274", "Velden\ am\ Wörther\ See",
"434255", "Arnoldstein",
"432847", "Gross\-Siegharts",
"437243", "Marchtrenk",
"432278", "Absdorf",
"433868", "Tragöss",
"432247", "Deutsch\-Wagram",
"433454", "Leutschach",
"433475", "Hürth",
"434855", "Assling",
"434874", "Virgen",
"432878", "Traunstein",
"435256", "Untergurgl",
"435288", "Fügen",
"432626", "Mattersburg",
"437415", "Altenmarkt\,\ Yspertal",
"437249", "Bad\ Schallerbach",
"433688", "Tauplitz",
"436457", "Flachau",
"433185", "Preding",
"433153", "Riegersburg",
"432725", "Frankenfels",
"436588", "Lofer",
"437714", "Esternberg",
"434212", "St\.\ Veit\ an\ der\ Glan",
"433356", "Markt\ Allhau",
"433159", "Bad\ Gleichenberg",
"434768", "Kleblach\-Lind",
"432764", "Hainfeld",
"432642", "Aspangberg\-St\.\ Peter",
"432267", "Sierndorf",
"432231", "Purkersdorf",
"435512", "Egg",
"432687", "Siegendorf",
"432213", "Lassee",
"437269", "Baumgartenberg",
"432735", "Hadersdorf\ am\ Kamp",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"432813", "Arbesbach",
"437674", "Attnang\-Puchheim",
"437683", "Frankenburg\ am\ Hausruck",
"436274", "Lamprechtshausen",
"437476", "Aschbach\-Markt",
"435214", "Leutasch",
"433848", "Eisenerz",
"433614", "Rottenmann",
"435677", "Vils",
"437263", "Bad\ Zell",
"433453", "Ehrenhausen",
"434873", "St\.\ Jakob\ in\ Defereggen",
"437618", "Neukirchen\,\ Altmünster",
"437941", "Neumarkt\ im\ Mühlkreis",
"434279", "Sirnitz",
"432856", "Weitra",
"435278", "Navis",
"434879", "St\.\ Veit\ in\ Defereggen",
"433535", "Krakaudorf",
"432256", "Leobersdorf",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"4314", "Vienna",
"434284", "Kirchbach",
"434273", "Reifnitz",
"432288", "Auersthal",
"437244", "Sattledt",
"433682", "Stainach",
"432230", "Schwadorf",
"435282", "Zell\ am\ Ziller",
"432749", "Prinzersdorf",
"432872", "Ottenschlag",
"435579", "Alberschwende",
"437747", "Kirchberg\ bei\ Mattighofen",
"432574", "Gaweinstal",
"432555", "Herrnbaumgarten",
"437587", "Wartberg\ an\ der\ Krems",
"432272", "Tulln\ an\ der\ Donau",
"433862", "Bruck\ an\ der\ Mur",
"432743", "Böheimkirchen",
"435573", "Hörbranz",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"432145", "Prellenkirchen",
"433116", "Kirchbach\ in\ Steiermark",
"433631", "Unterlaussa",
"432814", "Langschlag",
"437486", "Lunz\ am\ See",
"432648", "Hochneukirchen",
"437684", "Frankenmarkt",
"437673", "Schwanenstadt",
"434736", "Innerkrems",
"435213", "Scharnitz",
"436432", "Bad\ Hofgastein",
"434762", "Spittal\ an\ der\ Drau",
"437264", "Windhaag\ bei\ Perg",
"433613", "Admont",
"436466", "Werfenweng",
"435336", "Alpbach",
"437562", "Windischgarsten",
"433382", "Fürstenfeld",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"436470", "Atzmannsdorf",
"433619", "Oppenberg",
"437225", "Hargelsberg",
"435445", "Kappl",
"432214", "Kopfstetten",
"433842", "Leoben",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"437719", "Taufkirchen\ an\ der\ Pram",
"432165", "Hainburg\ a\.d\.\ Donau",
"436547", "Kaprun",
"437235", "Gallneukirchen",
"432717", "Unter\-Meisling",
"4319", "Vienna",
"433175", "Anger",
"432769", "Türnitz",
"437713", "Schardenberg",
"435518", "Mellau",
"437767", "Eggerding",
"436240", "Krispl",
"433456", "Fresing",
"432259", "Münchendorf",
"434876", "Kals\ am\ Grossglockner",
"435275", "Trins",
"435254", "Sölden",
"432853", "Schrems",
"432624", "Ebenfurth",
"436215", "Strasswalchen",
"437615", "Scharnstein",
"437257", "Grünburg",
"432285", "Marchegg",
"432253", "Oberwaltersdorf",
"432665", "Prein\ an\ der\ Rax",
"435552", "Bludenz",
"436135", "Bad\ Goisern",
"432859", "Brand\-Nagelberg",
"434276", "Feldkirchen\ in\ Kärnten",
"432942", "Retz",
"433472", "Mureck",
"434852", "Lienz",
"434357", "St\.\ Paul\ im\ Lavanttal",
"432177", "Podersdorf\ am\ See",
"437412", "Ybbs\ an\ der\ Donau",
"435633", "Hägerau",
"433119", "St\.\ Marein\ bei\ Graz",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"437955", "Königswiesen",
"432746", "Wilhelmsburg",
"433833", "Traboch",
"437754", "Waldzell",
"435576", "Hohenems",
"434252", "Wernberg",
"432634", "Gutenstein",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"436417", "Hüttschlag",
"432610", "Horitschon",
"435339", "Wildschönau",
"437474", "Euratsfeld",
"437483", "Oberndorf\ an\ der\ Melk",
"436276", "Nussdorf\ am\ Haunsberg",
"437676", "Ottnang\ am\ Hausruck",
"434733", "Malta",
"432645", "Wiesmath",
"436463", "Annaberg\-Lungötz",
"435477", "Tösens",
"433616", "Selzthal",
"435333", "Söll",
"435448", "Pettneu\ am\ Arlberg",
"437228", "Kematen\ an\ der\ Krems",
"433571", "Möderbrugg",
"433182", "Wildon",
"437489", "Purgstall\ an\ der\ Erlauf",
"432722", "Kirchberg\ an\ der\ Pielach",
"434215", "Liebenfels",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"434240", "Bad\ Kleinkirchheim",
"433147", "Salla",
"432732", "Krems\ an\ der\ Donau",
"432168", "Mannersdorf\ am\ Leithagebirge",
"432766", "Kleinzell",
"437238", "Mauthausen",
"437716", "Münzkirchen",
"435515", "Au",
"433354", "Bernstein",
"432527", "Wulzeshofen",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"435554", "Sonntag",
"435575", "Langen\ bei\ Bregenz",
"432143", "Kittsee",
"432841", "Vitis",
"432944", "Haugsdorf",
"433118", "Sinabelkirchen",
"437956", "Unterweissenbach",
"432745", "Pyhra",
"435357", "Kirchberg\ in\ Tirol",
"432622", "Wiener\ Neustadt",
"435252", "Oetz",
"432666", "Reichenau",
"437752", "Ried\ im\ Innkreis",
"436136", "Gosau",
"434275", "Ebene\ Reichenau",
"434254", "Faak\ am\ See",
"432632", "Pernitz",
"432258", "Alland",
"433533", "Turrach",
"432286", "Obersiebenbrunn",
"437414", "Weins\-Isperdorf",
"437616", "Grünau\ im\ Almtal",
"436216", "Neumarkt\ am\ Wallersee",
"436477", "St\.\ Michael\ im\ Lungau",
"434875", "Matrei\ in\ Osttirol",
"433474", "Deutsch\ Goritz",
"433455", "Arnfels",
"435417", "Roppen",
"432858", "Moorbad\ Harbach",
"435276", "Gschnitz",
"437239", "Lichtenberg",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"433173", "Ratten",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432237", "Gaaden",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"435516", "Doren",
"432163", "Petronell\-Carnuntum",
"437233", "Feldkirchen\ an\ der\ Donau",
"433179", "Passail",
"437211", "Reichenau\ im\ Mühlkreis",
"437472", "Amstetten",
"432765", "Kaumberg",
"433352", "Oberwart",
"432827", "Schönbach",
"437223", "Enns",
"435338", "Kundl",
"435443", "Galtür",
"433857", "Neuberg\ an\ der\ Mürz",
"437488", "Steinakirchen\ am\ Forst",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"43732", "Linz",
"435449", "Fliess",
"437229", "Traun",
"433615", "Trieben",
"436468", "Werfen",
"432734", "Langenlois",
"437675", "Ampflwang\ im\ Hausruckwald",
"432748", "Kilb",
"432146", "Nickelsdorf",
"434282", "Hermagor",
"437242", "Wels",
"433115", "Studenzen",
"436221", "Koppl",
"437953", "Liebenau",
"435578", "Höchst",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"435635", "Elmen",
"432957", "Hohenwarth",
"432556", "Grosskrut",
"437619", "Kirchham",
"432663", "Schottwien",
"436219", "Obertrum\ am\ See",
"435582", "Klösterle",
"436133", "Ebensee",
"434847", "Obertilliach",
"433536", "St\.\ Peter\ am\ Kammersberg",
"432283", "Angern\ an\ der\ March",
"432274", "Sieghartskirchen",
"432255", "Deutsch\ Brodersdorf",
"433864", "St\.\ Marein\ im\ Mürztal",
"432617", "Drassmarkt",
"435279", "St\.\ Jodok\ am\ Brenner",
"434278", "Gnesau",
"432855", "Waldenstein",
"432874", "Martinsberg",
"434247", "Afritz",
"436213", "Oberhofen\ am\ Irrsee",
"437613", "Laakirchen",
"432572", "Mistelbach",
"437287", "Peilstein\ im\ Mühlviertel",
"432289", "Matzen",
"433684", "St\.\ Martin\ am\ Grimming",
"437667", "St\.\ Georgen\ im\ Attergau",
"435273", "Matrei\ am\ Brenner",
"435284", "Gerlos",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"437718", "Waldkirchen\ am\ Wesen",
"432212", "Orth\ an\ der\ Donau",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"437564", "Hinterstoder",
"433176", "Stubenberg",
"433587", "Schönberg\-Lachtal",
"435513", "Hittisau",
"432166", "Parndorf",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"437236", "Pregarten",
"436434", "Bad\ Gastein",
"434221", "Gallizien",
"437262", "Perg",
"432812", "Gross\ Gerungs",
"433461", "Trahütten",
"435519", "Schröcken",
"437682", "Vöcklamarkt",
"432649", "Mönichkirchen",
"437250", "Maria\ Neustift",
"434231", "Mittertrixen",
"434267", "Metnitz",
"437226", "Wilhering",
"435446", "St\.\ Anton\ am\ Arlberg",
"435335", "Hopfgarten\ im\ Brixental",
"433152", "Feldbach",
"436247", "Grossgmain",
"434213", "Launsdorf",
"434735", "Kremsbrücke",
"436278", "Ostermiething",
"432643", "Lichtenegg",
"433844", "Kammern\ im\ Liesingtal",
"433618", "Hohentauern",
"437485", "Gaming",
"432873", "Kottes",
"437614", "Vorchdorf",
"436214", "Henndorf\ am\ Wallersee",
"437416", "Wieselburg",
"432625", "Bad\ Sauerbrunn",
"437277", "Waizenkirchen",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"433683", "Donnersbach",
"433476", "Bad\ Radkersburg",
"432279", "Kirchberg\ am\ Wagram",
"435283", "Kaltenbach",
"435255", "Umhausen",
"435274", "Gries\ am\ Brenner",
"435572", "Dornbirn",
"432664", "Semmering",
"434256", "Nötsch\ im\ Gailtal",
"436134", "Hallstatt",
"434220", "Köttmannsdorf",
"432284", "Oberweiden",
"432273", "Tulbing",
"437248", "Grieskirchen",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"433863", "Turnau",
"435289", "Häusling",
"432742", "St\.\ Pölten",
"433460", "Soboth",
"433137", "Söding",
"437251", "Schiedlberg",
"434230", "Globasnitz",
"433127", "Peggau",
"434872", "Huben",
"433452", "Leibnitz",
"435556", "Schruns",
"437755", "Mettmach",
"434272", "Pörtschach\ am\ Wörther\ See",
"432635", "Neunkirchen",
"432946", "Pulkau",
"437954", "St\.\ Georgen\ am\ Walde",
"432644", "Grimmenstein",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"437268", "Grein",
"432736", "Paudorf",
"433141", "Hirschegg",
"432762", "Lilienfeld",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"433849", "Vordernberg",
"437712", "Schärding",
"434214", "Brückl",
"436433", "Dorfgastein",
"436589", "Unken",
"435212", "Seefeld\ in\ Tirol",
"433612", "Liezen",
"434717", "Steinfeld",
"437672", "Vöcklabruck",
"436272", "Oberndorf\ bei\ Salzburg",
"433383", "Burgau",
"436583", "Leogang",
"433355", "Stadtschlaining",
"434769", "Möllbrücke",
"433158", "St\.\ Anna\ am\ Aigen",
"437563", "Spital\ am\ Pyhrn",
"432726", "Puchenstuben",
"435514", "Bezau",
"433577", "Zeltweg",
"432876", "Els",
"435632", "Stanzach",
"437413", "Marbach\ an\ der\ Donau",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"433686", "Haus",
"433473", "Straden",
"434853", "Ainet",
"432628", "Felixdorf",
"435286", "Ginzling",
"434285", "Tröpolach",
"434253", "St\.\ Jakob\ im\ Rosental",
"437245", "Lambach",
"433337", "Vorau",
"433112", "Gleisdorf",
"432276", "Reidling",
"433534", "Stadl\ an\ der\ Mur",
"433866", "Breitenau\ am\ Hochlantsch",
"433832", "Kraubath\ an\ der\ Mur",
"43316", "Graz",
"432852", "Gmünd",
"433327", "St\.\ Michael\ im\ Burgenland",
"435559", "Brand",
"432949", "Niederfladnitz",
"432554", "Stützenhofen",
"432575", "Ladendorf",
"437947", "Kefermarkt",
"435585", "Dalaas",
"435553", "Raggal",
"432144", "Deutsch\ Jahrndorf",
"437353", "Gaflenz",
"432943", "Obritz",
"432638", "Winzendorf\-Muthmannsdorf",
"432252", "Baden",
"437758", "Obernberg\ am\ Inn",
"437478", "Oed\-Oehling",
"432711", "Dürnstein",
"436541", "Saalbach",
"437265", "Pabneukirchen",
"433846", "Kalwang",
"432733", "Schönberg\ am\ Kamp",
"432815", "Grossschönau",
"435444", "Ischgl",
"432215", "Probstdorf",
"437224", "St\.\ Florian",
"432739", "Tiefenfucha",
"434732", "Gmünd\ in\ Kärnten",
"432164", "Rohrau",
"437727", "Ach",
"437234", "Ottensheim",
"434766", "Millstatt",
"436462", "Bischofshofen",
"4317", "Vienna",
"437482", "Scheibbs",
"433637", "Gams\ bei\ Hieflau",
"433386", "Grosssteinbach",
"437566", "Rosenau\ am\ Hengstpass",
"435332", "Wörgl",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"433174", "Birkfeld",
"433155", "Fehring",
"433358", "Litzelsdorf",
"432723", "Rabenstein\ an\ der\ Pielach",
"432557", "Bernhardsthal",
"434785", "Ausserfragant",
"432956", "Ziersdorf",
"437745", "Lochen",
"433324", "Strem",
"435359", "Hochfilzen",
"434358", "St\.\ Andrä",
"437435", "St\.\ Valentin",
"432988", "Neupölla",
"437944", "Sandl",
"432147", "Zurndorf",
"437241", "Steinerkirchen\ an\ der\ Traun",
"436565", "Neukirchen\ am\ Grossvenediger",
"433365", "Deutsch\ Schützen\-Eisenberg",
"435353", "Waidring",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"436484", "Lessach",
"436473", "Mariapfarr",
"437286", "Lembach\ im\ Mühlkreis",
"434246", "Radenthein",
"437666", "Attersee",
"432752", "Melk",
"437258", "Bad\ Hall",
"436232", "Mondsee",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"433334", "Kaindorf",
"436479", "Muhr",
"435245", "Hinterriss",
"432616", "Lockenhaus",
"434846", "Abfaltersbach",
"433537", "St\.\ Georgen\ ob\ Murau",
"433148", "Kainach\ bei\ Voitsberg",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"437724", "Mauerkirchen",
"437261", "Schönau\ im\ Mühlkreis",
"432167", "Neusiedl\ am\ See",
"433634", "Hieflau",
"432239", "Breitenfurt\ bei\ Wien",
"435234", "Axams",
"433462", "Deutschlandsberg",
"432914", "Japons",
"437765", "Lambrechten",
"433586", "Mühlen",
"432233", "Pressbaum",
"433177", "Puch\ bei\ Weiz",
"434822", "Winklern",
"436418", "Kleinarl",
"435522", "Feldkirch",
"432829", "Schweiggers",
"4318", "Vienna",
"432538", "Velm\-Götzendorf",
"435265", "Nassereith",
"433859", "Mürzsteg",
"434232", "Völkermarkt",
"437227", "Neuhofen\ an\ der\ Krems",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"435447", "Flirsch",
"434266", "Strassburg",
"432823", "Grossglobnitz",
"437444", "Opponitz",
"436246", "Grödig",
"433151", "Gnas",
"435224", "Wattens",
"433853", "Spital\ am\ Semmering",
"433885", "Greith",
"4312", "Vienna",
"433624", "Pichl\-Kainisch",
"436452", "Radstadt",
"432621", "Sieggraben",
"432953", "Nappersdorf",
"432985", "Gars\ am\ Kamp",
"434355", "Gemmersdorf",
"432175", "Apetlon",
"432784", "Perschling",
"432773", "Eichgraben",
"437748", "Eggelsberg",
"432242", "St\.\ Andrä\-Wördern",
"433124", "Gratkorn",
"432959", "Sitzendorf\ an\ der\ Schmida",
"437588", "Ried\ im\ Traunkreis",
"432842", "Waidhofen\ an\ der\ Thaya",
"435356", "Kitzbühel",
"436476", "St\.\ Margarethen\ im\ Lungau",
"437283", "Sarleinsbach",
"437274", "Alkoven",
"437255", "Losenstein",
"436217", "Mattsee",
"437617", "Traunkirchen",
"434243", "Bodensdorf",
"432619", "Lackendorf",
"437663", "Steinbach\ am\ Attersee",
"437751", "St\.\ Martin\ im\ Innkreis",
"437289", "Rohrbach\ in\ Oberösterreich",
"436137", "Strobl",
"432631", "Pöttsching",
"433512", "Knittelfeld",
"432667", "Schwarzau\ im\ Gebirge",
"435248", "Steinberg\ am\ Rofan",
"433134", "Heiligenkreuz\ am\ Waasen",
"432613", "Deutschkreutz",
"435372", "Kufstein",
"434843", "Ausservillgraten",
"437480", "Langau\,\ Gaming",
"432287", "Strasshof\ an\ der\ Nordbahn",
"435672", "Reutte",
"432862", "Heidenreichstein",
"436548", "Niedernsill",
"432718", "Lichtenau\ im\ Waldviertel",
"437212", "Zwettl\ an\ der\ Rodl",
"434714", "Dellach\ im\ Drautal",
"437471", "Neustadtl\ an\ der\ Donau",
"433145", "Edelschrott",
"432525", "Gnadendorf",
"432682", "Eisenstadt",
"433583", "Unzmarkt",
"432236", "Mödling",
"433574", "Pusterwald",
"435517", "Riezlern",
"432262", "Korneuburg",
"435475", "Feichten",
"432647", "Krumbach\,\ Lower\ Austria",
"432535", "Hohenau\ an\ der\ March",
"434269", "Flattnitz",
"436415", "Schwarzach\ im\ Pongau",
"434263", "Hüttenberg",
"432826", "Rastenfeld",
"436243", "Abtenau",
"433856", "Veitsch",
"433336", "Waldbach",
"437279", "Haibach\ ob\ der\ Donau",
"433362", "Grosspetersdorf",
"436562", "Mittersill",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"433133", "Nestelbach",
"432614", "Kleinwarasdorf",
"436225", "Eugendorf",
"433867", "Pernegg\ an\ der\ Mur",
"432277", "Zwentendorf",
"437582", "Kirchdorf\ an\ der\ Krems",
"437284", "Oberkappel",
"437273", "Aschach\ an\ der\ Donau",
"432248", "Markgrafneusiedl",
"434782", "Obervellach",
"437742", "Mattighofen",
"434244", "Bad\ Bleiberg",
"432877", "Grainbrunn",
"435287", "Tux",
"437664", "Weyregg\ am\ Attersee",
"437432", "Strengberg",
"436458", "Hüttau",
"433687", "Schladming",
"435242", "Schwaz",
"432954", "Göllersdorf",
"433326", "Stegersbach",
"432755", "Mank",
"432774", "Innermanzing",
"432783", "Traismauer",
"436235", "Thalgau",
"437946", "Gutau",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"432620", "Willendorf",
"437736", "Pram",
"432268", "Grossmugl",
"434264", "Klein\ St\.\ Paul",
"437762", "Raab",
"435226", "Neustift\ im\ Stubaital",
"436244", "Golling\ an\ der\ Salzach",
"432688", "Steinbrunn",
"434825", "Grosskirchheim",
"437218", "Grosstraberg",
"432712", "Aggsbach",
"436542", "Zell\ am\ See",
"43512", "Innsbruck",
"434225", "Grafenstein",
"433465", "Pölfing\-Brunn",
"435678", "Weissenbach\ am\ Lech",
"433847", "Trofaiach",
"434235", "Bleiburg",
"432672", "Berndorf",
"433387", "Söchau",
"435331", "Brandenberg",
"433573", "Fohnsdorf",
"433584", "Neumarkt\ in\ Steiermark",
"433882", "Mariazell",
"437750", "Andrichsfurt",
"434767", "Rothenthurn",
"432630", "Ternitz",
"435525", "Nenzing",
"436461", "Dienten\ am\ Hochkönig",
"433579", "Pöls",
"435262", "Telfs",
"433636", "Wildalpen",
"435236", "Gries\ im\ Sellrain",
"432916", "Riegersburg\,\ Hardegg",
"434713", "Techendorf",
"433333", "Sebersdorf",
"434257", "Fürnitz",
"432845", "Weikertschlag\ an\ der\ Thaya",
"436228", "Faistenau",
"437260", "Waldhausen",
"433136", "Dobl",
"432741", "Flinsbach",
"437276", "Peuerbach",
"436483", "Göriach",
"433339", "Friedberg",
"436474", "Tamsweg",
"436455", "Untertauern",
"432982", "Horn",
"432172", "Frauenkirchen",
"434352", "Wolfsberg",
"432245", "Wolkersdorf\ im\ Weinviertel",
"435414", "Wenns",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432947", "Theras",
"434271", "Steuerberg",
"437357", "Kleinreifling",
"435557", "St\.\ Gallenkirch",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"433329", "Jennersdorf",
"435375", "Kössen",
"435354", "Fieberbrunn",
"437949", "Rainbach\ im\ Mühlkreis",
"437252", "Steyr",
"432758", "Pöggstall",
"433323", "Eberau",
"432786", "Oberwölbling",
"433150", "Paldau",
"437943", "Windhaag\ bei\ Freistadt",
"433126", "Frohnleiten",
"437733", "Neumarkt\ im\ Hausruckkreis",
"432522", "Laa\ an\ der\ Thaya",
"432824", "Allentsteig",
"432685", "Rust",
"435223", "Hall\ in\ Tirol",
"437443", "Ybbsitz",
"437711", "Suben",
"433854", "Langenwang",
"433623", "Bad\ Mitterndorf",
"432265", "Hausleiten",
"435675", "Tannheim",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"437240", "Sipbachzell",
"432865", "Litschau",
"434228", "Feistritz\ im\ Rosental",
"437215", "Hellmonsödt",
"433142", "Voitsberg",
"437729", "Neukirchen\ an\ der\ Enknach",
"432234", "Gramatneusiedl",
"433576", "Bretstein",
"434238", "Eisenkappel\-Vellach",
"435239", "Kühtai",
"435472", "Prutz",
"432532", "Zistersdorf",
"437723", "Altheim",
"433611", "Johnsbach",
"433633", "Landl",
"436412", "St\.\ Johann\ im\ Pongau",
"432913", "Hötzelsdorf",
"434716", "Lesachtal",};
my $timezones = {
               '' => [
                       'Europe/Vienna'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '43', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;