# Generated by default/object.tt
package Paws::ACMPCA::ExtendedKeyUsage;
  use Moose;
  has ExtendedKeyUsageObjectIdentifier => (is => 'ro', isa => 'Str');
  has ExtendedKeyUsageType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::ExtendedKeyUsage

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::ExtendedKeyUsage object:

  $service_obj->Method(Att1 => { ExtendedKeyUsageObjectIdentifier => $value, ..., ExtendedKeyUsageType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::ExtendedKeyUsage object:

  $result = $service_obj->Method(...);
  $result->Att1->ExtendedKeyUsageObjectIdentifier

=head1 DESCRIPTION

Specifies additional purposes for which the certified public key may be
used other than basic purposes indicated in the C<KeyUsage> extension.

=head1 ATTRIBUTES


=head2 ExtendedKeyUsageObjectIdentifier => Str

Specifies a custom C<ExtendedKeyUsage> with an object identifier (OID).


=head2 ExtendedKeyUsageType => Str

Specifies a standard C<ExtendedKeyUsage> as defined as in RFC 5280
(https://tools.ietf.org/html/rfc5280#section-4.2.1.12).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

