# Generated by default/object.tt
package Paws::IoTSiteWise::AssetCompositeModel;
  use Moose;
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Properties => (is => 'ro', isa => 'ArrayRef[Paws::IoTSiteWise::AssetProperty]', request_name => 'properties', traits => ['NameInRequest'], required => 1);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::AssetCompositeModel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::AssetCompositeModel object:

  $service_obj->Method(Att1 => { Description => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::AssetCompositeModel object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Contains information about a composite model in an asset. This object
contains the asset's properties that you define in the composite model.

=head1 ATTRIBUTES


=head2 Description => Str

The description of the composite model.


=head2 B<REQUIRED> Name => Str

The name of the composite model.


=head2 B<REQUIRED> Properties => ArrayRef[L<Paws::IoTSiteWise::AssetProperty>]

The asset properties that this composite model defines.


=head2 B<REQUIRED> Type => Str

The type of the composite model. For alarm composite models, this type
is C<AWS/ALARM>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

