# Generated by default/object.tt
package Paws::Finspace::Environment;
  use Moose;
  has AwsAccountId => (is => 'ro', isa => 'Str', request_name => 'awsAccountId', traits => ['NameInRequest']);
  has DedicatedServiceAccountId => (is => 'ro', isa => 'Str', request_name => 'dedicatedServiceAccountId', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has EnvironmentArn => (is => 'ro', isa => 'Str', request_name => 'environmentArn', traits => ['NameInRequest']);
  has EnvironmentId => (is => 'ro', isa => 'Str', request_name => 'environmentId', traits => ['NameInRequest']);
  has EnvironmentUrl => (is => 'ro', isa => 'Str', request_name => 'environmentUrl', traits => ['NameInRequest']);
  has FederationMode => (is => 'ro', isa => 'Str', request_name => 'federationMode', traits => ['NameInRequest']);
  has FederationParameters => (is => 'ro', isa => 'Paws::Finspace::FederationParameters', request_name => 'federationParameters', traits => ['NameInRequest']);
  has KmsKeyId => (is => 'ro', isa => 'Str', request_name => 'kmsKeyId', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has SageMakerStudioDomainUrl => (is => 'ro', isa => 'Str', request_name => 'sageMakerStudioDomainUrl', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Finspace::Environment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Finspace::Environment object:

  $service_obj->Method(Att1 => { AwsAccountId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Finspace::Environment object:

  $result = $service_obj->Method(...);
  $result->Att1->AwsAccountId

=head1 DESCRIPTION

Represents an FinSpace environment.

=head1 ATTRIBUTES


=head2 AwsAccountId => Str

The ID of the AWS account in which the FinSpace environment is created.


=head2 DedicatedServiceAccountId => Str

The AWS account ID of the dedicated service account associated with
your FinSpace environment.


=head2 Description => Str

The description of the FinSpace environment.


=head2 EnvironmentArn => Str

The Amazon Resource Name (ARN) of your FinSpace environment.


=head2 EnvironmentId => Str

The identifier of the FinSpace environment.


=head2 EnvironmentUrl => Str

The sign-in url for the web application of your FinSpace environment.


=head2 FederationMode => Str

The authentication mode for the environment.


=head2 FederationParameters => L<Paws::Finspace::FederationParameters>

Configuration information when authentication mode is FEDERATED.


=head2 KmsKeyId => Str

The KMS key id used to encrypt in the FinSpace environment.


=head2 Name => Str

The name of the FinSpace environment.


=head2 SageMakerStudioDomainUrl => Str

The url of the integrated FinSpace notebook environment in your web
application.


=head2 Status => Str

The current status of creation of the FinSpace environment.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Finspace>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

