/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import java.io.OutputStream;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;

public class ExpressionPresenter {
    private Configuration config;
    private Receiver receiver;
    int depth = 0;
    boolean inStartTag = false;

    public ExpressionPresenter(Configuration config) {
        this(config, config.getStandardErrorOutput());
    }

    public ExpressionPresenter(Configuration config, OutputStream out) {
        Properties props = ExpressionPresenter.makeDefaultProperties();
        try {
            this.receiver = config.getSerializerFactory().getReceiver(new StreamResult(out), config.makePipelineConfiguration(), props);
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
        this.config = config;
        try {
            this.receiver.open();
            this.receiver.startDocument(0);
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    public ExpressionPresenter(Configuration config, Receiver receiver) {
        this.config = config;
        this.receiver = receiver;
        try {
            receiver.open();
            receiver.startDocument(0);
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    public static Receiver defaultDestination(Configuration config, OutputStream out) throws XPathException {
        Properties props = ExpressionPresenter.makeDefaultProperties();
        return config.getSerializerFactory().getReceiver(new StreamResult(out), config.makePipelineConfiguration(), props);
    }

    public static Properties makeDefaultProperties() {
        Properties props = new Properties();
        props.setProperty("method", "xml");
        props.setProperty("indent", "yes");
        props.setProperty("omit-xml-declaration", "yes");
        props.setProperty("{http://saxon.sf.net/}indent-spaces", "2");
        return props;
    }

    public int startElement(String name) {
        try {
            if (this.inStartTag) {
                this.receiver.startContent();
                this.inStartTag = false;
            }
            this.receiver.startElement(new NoNamespaceName(name), Untyped.getInstance(), 0, 0);
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
        this.inStartTag = true;
        return this.depth++;
    }

    public void emitAttribute(String name, String value) {
        try {
            this.receiver.attribute(new NoNamespaceName(name), BuiltInAtomicType.UNTYPED_ATOMIC, value, 0, 0);
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    public int endElement() {
        try {
            if (this.inStartTag) {
                this.receiver.startContent();
                this.inStartTag = false;
            }
            this.receiver.endElement();
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
        return --this.depth;
    }

    public void startSubsidiaryElement(String name) {
        this.startElement(name);
    }

    public void endSubsidiaryElement() {
        this.endElement();
    }

    public void close() {
        try {
            this.receiver.endDocument();
            this.receiver.close();
        }
        catch (XPathException err) {
            err.printStackTrace();
            throw new InternalError(err.getMessage());
        }
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.config.getTypeHierarchy();
    }
}

