/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.CastingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.StringFn;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.value.Whitespace;

public class CastExpression
extends CastingExpression {
    public CastExpression(Expression source, AtomicType target, boolean allowEmpty) {
        super(source, target, allowEmpty);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextItemType);
        SequenceType atomicType = SequenceType.makeSequenceType(BuiltInAtomicType.ANY_ATOMIC, this.getCardinality());
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        RoleLocator role = new RoleLocator(2, "cast as", 0);
        ItemType sourceItemType = null;
        if (this.getTargetType().isNamespaceSensitive()) {
            int rel = th.relationship(this.operand.getItemType(th), AnyNodeTest.getInstance());
            if (rel == 0 || rel == 2) {
                XPathException err = new XPathException("Atomization is not allowed when casting to QName or NOTATION");
                err.setErrorCode("XPTY0004");
                err.setLocator(this);
                err.setIsTypeError(true);
                throw err;
            }
            if (rel != 4) {
                this.operand = new ItemChecker(this.operand, BuiltInAtomicType.ANY_ATOMIC, role);
            }
            sourceItemType = BuiltInAtomicType.ANY_ATOMIC;
        } else {
            this.operand = TypeChecker.staticTypeCheck(this.operand, atomicType, false, role, visitor);
            sourceItemType = this.operand.getItemType(th);
        }
        if (sourceItemType instanceof EmptySequenceTest) {
            if (this.allowsEmpty()) {
                return new Literal(EmptySequence.getInstance());
            }
            XPathException err = new XPathException("Cast does not allow an empty sequence as input");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        AtomicType sourceType = (AtomicType)sourceItemType;
        int r = th.relationship(sourceType, this.getTargetType());
        if (r == 0) {
            return this.operand;
        }
        if (r == 2) {
            this.converter = new Converter.UpCastingConverter(this.getTargetType());
        } else {
            ConversionRules rules = visitor.getConfiguration().getConversionRules();
            if (sourceType != BuiltInAtomicType.ANY_ATOMIC && sourceType.getFingerprint() != 15) {
                this.converter = rules.getConverter(sourceType, this.getTargetType());
                if (this.converter == null) {
                    XPathException err = new XPathException("Casting from " + sourceType + " to " + this.getTargetType() + " can never succeed");
                    err.setErrorCode("XPTY0004");
                    err.setLocator(this);
                    err.setIsTypeError(true);
                    throw err;
                }
                if (this.getTargetType().isNamespaceSensitive()) {
                    this.converter.setNamespaceResolver(this.nsResolver);
                }
                if (!(!this.converter.isXPath30Conversion() || visitor.getStaticContext().getXPathLanguageLevel().equals(DecimalValue.THREE) || this.operand instanceof Literal && this.getTargetType().getPrimitiveType() == 530)) {
                    XPathException err = new XPathException("Casting from " + sourceType + " to " + this.getTargetType() + " requires XPath 3.0 functionality to be enabled");
                    err.setErrorCode("XPTY0004");
                    err.setLocator(this);
                    err.setIsTypeError(true);
                    throw err;
                }
            }
        }
        if (this.operand instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        Expression e;
        ItemType et;
        ItemType it;
        ItemType et2;
        Expression e2;
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression e22 = super.optimize(visitor, contextItemType);
        if (e22 != this) {
            return e22;
        }
        if (this.getTargetType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
            if (this.operand instanceof StringFn) {
                e2 = ((StringFn)this.operand).getArguments()[0];
                if (e2.getItemType(th) instanceof AtomicType && e2.getCardinality() == 16384) {
                    this.operand = e2;
                }
            } else if (this.operand instanceof CastExpression) {
                if (((CastExpression)this.operand).getTargetType() == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    return this.operand;
                }
                if (((CastExpression)this.operand).getTargetType() == BuiltInAtomicType.STRING) {
                    ((CastExpression)this.operand).setTargetType(BuiltInAtomicType.UNTYPED_ATOMIC);
                    return this.operand;
                }
            } else if (this.operand instanceof AtomicSequenceConverter) {
                if (this.operand.getItemType(th) == BuiltInAtomicType.UNTYPED_ATOMIC) {
                    return this.operand;
                }
                if (this.operand.getItemType(th) == BuiltInAtomicType.STRING) {
                    AtomicSequenceConverter old = (AtomicSequenceConverter)this.operand;
                    AtomicSequenceConverter asc = new AtomicSequenceConverter(old.getBaseExpression(), BuiltInAtomicType.UNTYPED_ATOMIC, old.isAllItemsConverted());
                    return asc.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType);
                }
            }
        }
        if (this.operand instanceof StringFn && (et2 = (e2 = ((StringFn)this.operand).getArguments()[0]).getItemType(th)) instanceof AtomicType && e2.getCardinality() == 16384 && th.isSubType(et2, this.getTargetType())) {
            return e2;
        }
        if (this.operand instanceof CastExpression && (th.isSubType(it = ((CastExpression)this.operand).getTargetType(), BuiltInAtomicType.STRING) || th.isSubType(it, BuiltInAtomicType.UNTYPED_ATOMIC)) && (et = (e = ((CastExpression)this.operand).getBaseExpression()).getItemType(th)) instanceof AtomicType && e.getCardinality() == 16384 && th.isSubType(et, this.getTargetType())) {
            return e;
        }
        if (this.operand instanceof AtomicSequenceConverter && (th.isSubType(it = this.operand.getItemType(th), BuiltInAtomicType.STRING) || th.isSubType(it, BuiltInAtomicType.UNTYPED_ATOMIC)) && (et = (e = ((AtomicSequenceConverter)this.operand).getBaseExpression()).getItemType(th)) instanceof AtomicType && e.getCardinality() == 16384 && th.isSubType(et, this.getTargetType())) {
            return e;
        }
        if (!Cardinality.allowsZero(this.operand.getCardinality())) {
            this.setAllowEmpty(false);
            this.resetLocalStaticProperties();
        }
        if (this.operand instanceof Literal) {
            return this.preEvaluate();
        }
        return this;
    }

    protected Expression preEvaluate() throws XPathException {
        Value literalOperand = ((Literal)this.operand).getValue();
        if (literalOperand instanceof AtomicValue && this.converter != null) {
            ConversionResult result = this.converter.convert((AtomicValue)literalOperand);
            if (result instanceof ValidationFailure) {
                ValidationFailure err = (ValidationFailure)result;
                String code = err.getErrorCode();
                if (code == null) {
                    code = "FORG0001";
                }
                XPathException xpe = new XPathException(err.getMessage(), this);
                xpe.setErrorCode(code);
                throw xpe;
            }
            return Literal.makeLiteral((AtomicValue)result);
        }
        if (literalOperand instanceof EmptySequence) {
            if (this.allowsEmpty()) {
                return this.operand;
            }
            XPathException err = new XPathException("Cast can never succeed: the operand must not be an empty sequence");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            err.setIsTypeError(true);
            throw err;
        }
        return this;
    }

    public int computeCardinality() {
        return this.allowsEmpty() && Cardinality.allowsZero(this.operand.getCardinality()) ? 24576 : 16384;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return this.getTargetType();
    }

    public IntegerValue[] getIntegerBounds() {
        if (this.converter == Converter.BOOLEAN_TO_INTEGER) {
            return new IntegerValue[]{Int64Value.ZERO, Int64Value.PLUS_ONE};
        }
        return null;
    }

    public Expression copy() {
        CastExpression c2 = new CastExpression(this.getBaseExpression().copy(), this.getTargetType(), this.allowsEmpty());
        c2.converter = this.converter;
        c2.nsResolver = this.nsResolver;
        c2.setOperandIsStringLiteral(this.isOperandIsStringLiteral());
        return c2;
    }

    public Item evaluateItem(XPathContext context) throws XPathException {
        ConversionResult result;
        AtomicValue value = (AtomicValue)this.operand.evaluateItem(context);
        if (value == null) {
            if (this.allowsEmpty()) {
                return null;
            }
            XPathException e = new XPathException("Cast does not allow an empty sequence");
            e.setXPathContext(context);
            e.setLocator(this);
            e.setErrorCode("XPTY0004");
            throw e;
        }
        Converter converter = this.converter;
        if (converter == null) {
            ConversionRules rules = context.getConfiguration().getConversionRules();
            converter = rules.getConverter(value.getPrimitiveType(), this.getTargetType());
            if (converter == null) {
                XPathException e = new XPathException("Casting from " + value.getPrimitiveType() + " to " + this.getTargetType() + " is not permitted");
                e.setXPathContext(context);
                e.setLocator(this);
                e.setErrorCode("XPTY0004");
                throw e;
            }
            if (!(!converter.isXPath30Conversion() || this.getExecutable().isAllowXPath30() || converter instanceof StringConverter.StringToQName && this.isOperandIsStringLiteral())) {
                XPathException e = new XPathException("Casting from " + value.getPrimitiveType() + " to " + this.getTargetType() + " requires XPath 3.0 to be enabled");
                e.setXPathContext(context);
                e.setLocator(this);
                e.setErrorCode("XPTY0004");
                throw e;
            }
            if (this.nsResolver != null) {
                converter.setNamespaceResolver(this.nsResolver);
            }
        }
        if ((result = converter.convert(value)) instanceof ValidationFailure) {
            ValidationFailure err = (ValidationFailure)result;
            String code = err.getErrorCode();
            if (code == null) {
                code = "FORG0001";
            }
            this.dynamicError(err.getMessage(), code, context);
            return null;
        }
        return (AtomicValue)result;
    }

    public boolean equals(Object other) {
        return other instanceof CastExpression && this.operand.equals(((CastExpression)other).operand) && this.getTargetType() == ((CastExpression)other).getTargetType() && this.getTargetType() == ((CastExpression)other).getTargetType();
    }

    public int hashCode() {
        return super.hashCode() ^ this.getTargetType().hashCode();
    }

    public String toString() {
        try {
            NamePool pool = this.getExecutable().getConfiguration().getNamePool();
            return this.getTargetType().toString(pool) + "(" + this.operand.toString() + ")";
        }
        catch (Exception err) {
            return this.getTargetType().toString() + "(" + this.operand.toString() + ")";
        }
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("cast");
        out.emitAttribute("as", this.getTargetType().toString(out.getConfiguration().getNamePool()));
        this.operand.explain(out);
        out.endElement();
    }

    public static AtomicValue castStringToQName(CharSequence operand, AtomicType targetType, StaticContext env) throws XPathException {
        try {
            String uri;
            ConversionRules rules = env.getConfiguration().getConversionRules();
            CharSequence arg = Whitespace.trimWhitespace(operand);
            String[] parts = env.getConfiguration().getNameChecker().getQNameParts(arg);
            if (parts[0].length() == 0) {
                uri = env.getDefaultElementNamespace();
            } else {
                try {
                    uri = env.getURIForPrefix(parts[0]);
                }
                catch (XPathException e) {
                    uri = null;
                }
                if (uri == null) {
                    e = new XPathException("Prefix '" + parts[0] + "' has not been declared");
                    e.setErrorCode("FONS0004");
                    throw e;
                }
            }
            Configuration config = env.getConfiguration();
            NameChecker checker = config.getNameChecker();
            TypeHierarchy th = config.getTypeHierarchy();
            if (targetType.getFingerprint() == 530) {
                return new QNameValue(parts[0], uri, parts[1], BuiltInAtomicType.QNAME, checker);
            }
            if (th.isSubType(targetType, BuiltInAtomicType.QNAME)) {
                QNameValue q = new QNameValue(parts[0], uri, parts[1], targetType, checker);
                ValidationFailure vf = targetType.validate(q, null, rules);
                if (vf != null) {
                    throw vf.makeException();
                }
                q.setTypeLabel(targetType);
                return q;
            }
            NotationValue n = new NotationValue(parts[0], uri, parts[1], checker);
            ValidationFailure vf = targetType.validate(n, null, rules);
            if (vf != null) {
                throw vf.makeException();
            }
            n.setTypeLabel(targetType);
            return n;
        }
        catch (XPathException err) {
            if (err.getErrorCodeQName() == null) {
                err.setErrorCode("FONS0004");
            }
            throw err;
        }
        catch (QNameException err) {
            XPathException e = new XPathException(err);
            e.setErrorCode("FORG0001");
            throw e;
        }
    }
}

