/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class HtmlEmbed
extends HtmlElement {
    public static final String TAG_NAME = "embed";

    HtmlEmbed(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public void saveAs(File file) throws IOException {
        HtmlPage page = (HtmlPage)this.getPage();
        WebClient webclient = page.getWebClient();
        URL url = page.getFullyQualifiedUrl(this.getAttribute("src"));
        WebRequest request = new WebRequest(url);
        request.setAdditionalHeader("Referer", page.getUrl().toExternalForm());
        WebResponse webResponse = webclient.loadWebResponse(request);
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy(webResponse.getContentAsStream(), (OutputStream)fos);
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }
}

