<?xml version="1.0" encoding="UTF-8"?>
<!--
    :tabSize=2:indentSize=2:wrap=hard:
    $Id: common.xslt 4 2009-01-07 13:02:06Z rjray $

    This XSLT stylesheet contains all the operations/templates that are
    common to both XHTML and plain-text stylesheets. Mostly this is
    focused on date-formatting and the "credits" string (the list of
    software components responsible for the XSLT processing).
-->
<xsl:stylesheet version="1.0"
                xmlns:cl="http://www.blackperl.com/2009/01/ChangeLogML"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:date="http://exslt.org/dates-and-times"
                xmlns:xhtml="http://www.w3.org/1999/xhtml"
                xmlns="http://www.w3.org/1999/xhtml"
                extension-element-prefixes="date">

  <!-- Tab character, used in some places (mainly in text-oriented styles) -->
  <xsl:variable name="tab"><xsl:text>&#x9;</xsl:text></xsl:variable>

  <!-- Platform-agnostic newline character -->
  <xsl:variable name="newline">
<xsl:text>
</xsl:text>
  </xsl:variable>

  <!--
    The source-control identifying string for this component, used in some
    credits-comments.
  -->
  <xsl:variable name="common-id">
    <xsl:text><![CDATA[$Id: common.xslt 4 2009-01-07 13:02:06Z rjray $]]></xsl:text>
  </xsl:variable>

  <!--
    Variables and system-properties that make up the "generated by" comment.
    If the formatting application has registered a function called "credits"
    in the ChangeLogML namespace (cl:), that is called to get the string that
    identifies the processor application. Otherwise, the 'xsl:vendor' and
    'xsl:vendor-url' system-properties are used.
  -->
  <xsl:variable name="now">
    <xsl:call-template name="format-date">
      <xsl:with-param name="date" select="date:date-time()" />
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="credits">
    <xsl:choose>
      <xsl:when test="function-available('cl:credits')">
        <xsl:value-of select="cl:credits()" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat(system-property('xsl:vendor'), ' (', system-property('xsl:vendor-url'), ')')" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!--
    These variables are used for the project name and title, which depending
    on the sort of output being produced might need to be subtly distinct.
  -->
  <xsl:variable name="name" select="cl:changelog/cl:project" />
  <xsl:variable name="title">
    <!-- A little more complex, as the title element is optional -->
    <xsl:choose>
      <xsl:when test="cl:changelog/cl:title">
        <xsl:value-of select="cl:changelog/cl:title/text()" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="concat(cl:changelog/cl:project, ' Change History')" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:variable>

  <!--
    Because libxslt does not support XPath 2.0 and thus the date-formatting it
    provides, this template takes a dateTime string and formats it more-or-less
    like the UNIX date command output. It checks to see if the application
    provides a definition for "format-date" in the ChangeLogML namespace (cl:),
    and if not falls back to a simplified formatting using available elements
    in the "date:" extension.
  -->
  <xsl:template name="format-date">
    <xsl:param name="date" />
    <xsl:choose>
      <xsl:when test="function-available('cl:format-date')">
        <xsl:value-of select="cl:format-date($date)" />
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="month" select="date:month-name($date)" />
        <xsl:variable name="day-name" select="date:day-name($date)" />
        <xsl:variable name="day" select="date:day-in-month($date)" />
        <xsl:variable name="year" select="date:year($date)" />
        <xsl:variable name="time" select="date:time($date)" />
        <xsl:variable name="hour-raw" select="date:hour-in-day($date)" />
        <xsl:variable name="minutes" select="concat('00', date:minute-in-hour($date))" />
        <xsl:variable name="ampm">
          <xsl:choose>
            <xsl:when test="$hour-raw > 11">
              <xsl:text>PM</xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <xsl:text>AM</xsl:text>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:variable name="hour">
          <xsl:choose>
            <xsl:when test="$hour-raw > 12">
              <xsl:value-of select="$hour-raw - 12" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$hour-raw" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$day-name" /><xsl:text> </xsl:text>
        <xsl:value-of select="$month" /><xsl:text> </xsl:text>
        <xsl:value-of select="$day" /><xsl:text>, </xsl:text>
        <xsl:value-of select="$year" /><xsl:text>, </xsl:text>
        <xsl:value-of select="$hour" /><xsl:text>:</xsl:text>
        <xsl:value-of select="substring($minutes, string-length($minutes)-1, 2)" />
        <xsl:value-of select="$ampm" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--
    Prevent text nodes whose containers have no explicit rule from being output.
  -->
  <xsl:template match="text()" />

  <!--
    This template overrides the text()-nodes template above for those nodes that
    occur within tags in the cl: or xhtml: namespaces. Other namespaces (such
    as VCS modules) can replicate the basic structure of this, to get their
    content in as well.
  -->
  <xsl:template name="text-nodes" match="cl:*/text()|xhtml:*/text()">
    <xsl:value-of select="." />
  </xsl:template>

</xsl:stylesheet>
