use strict;
use warnings;

package App::Embra::App::Command;
$App::Embra::App::Command::VERSION = '0.001'; # TRIAL
# ABSTRACT: base class for embra commands

use App::Cmd::Setup -command;


sub embra {
    my ( $self ) = @_;
    use 5.010;
    require App::Embra;
    use feature qw< state >;
    state $embra = App::Embra->from_config_mvp_sequence( sequence => $self->_create_seq );
}

sub _die_missing {
    my ($package) = @_;

    my $bundle = $package =~ /^@/ ? ' bundle' : '';
    die <<"END_DIE";
Required plugin$bundle [$package] isn't installed.

Run 'embra listdeps' to see a list of all required plugins.
You can pipe the list to your CPAN client to install or update them:

    embra listdeps | cpanm

END_DIE
}

# from Dist::Zilla::Dist::Build, where it is known as _load_config

sub _create_seq {
    my ( $self ) = @_;
    require Config::MVP::Reader::Finder;
    require App::Embra::MVP::Assembler;
    use Try::Tiny;
    try {
        Config::MVP::Reader::Finder->read_config(
            'embra',
            {
                assembler => App::Embra::MVP::Assembler->new,
            }
        );
    } catch {
        my $e = $_;
        try {
            for($e) {
                if($e->ident =~ /package not installed/) {
                    _die_missing($e->package);
                }
            }
        } catch {
            die $e;
        };
    };
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::App::Command - base class for embra commands

=head1 VERSION

version 0.001

=head1 METHODS

=head2 embra

This returns the App::Embra object in use by the command. it will be constructed by calling C<< App::Embra->from_config_mvp_sequence >> with the settings from C< embra.ini >.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
