use strict;
use warnings;

package App::Embra::Plugin::DetectYamlFrontMatter;
$App::Embra::Plugin::DetectYamlFrontMatter::VERSION = '0.001'; # TRIAL
# ABSTRACT: detect YAML front matter & save as notes

use Try::Tiny;
use Method::Signatures;
use Moo;


method transform_files {
    for my $file ( @{ $self->embra->files } ) {
        my ( $yaml_front_matter ) =
            $file->content =~ m/
              \A        # beginning of file
              --- \s* ^ # first line is three dashes
              ( .*? ) ^ # then the smallest amount of stuff until
              --- \s* ^ # the next line of three dashes
            /xmsp;
        next if not $yaml_front_matter;
        my $notes;
        try {
            require YAML::XS;
            $notes = YAML::XS::Load( $yaml_front_matter );
        } catch {
            die 'cannot read front-matter of '.$file->name.': '.$_;
        };
        $file->update_notes( %$notes );
        $file->content( ${^POSTMATCH} );
    }
}

with 'App::Embra::Role::FileTransformer';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::DetectYamlFrontMatter - detect YAML front matter & save as notes

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will check each gathered file for L<YAML front-matter|http://jekyllrb.com/docs/frontmatter/>. Any keys & values found will be added to the file's notes.

Files must start with YAML front-matter for it to be detected. The format is:

    ---
    key: value
    key2: value2
    ---
    << rest of file … >>

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
