package Oryx::DBM::Association::Hash;

use Oryx::DBM::Association::Reference;

use base qw(Oryx::Association::Hash);
use Data::Dumper;

our $DEBUG = 0;

sub create {
    my ($self, $proto) = @_;
}

sub retrieve {
    my ($self, $proto, $id) = @_;
}

sub update {
    my ($self, $proto, $obj) = @_;
    my $accessor = $self->role;
    my $value = $obj->{$accessor} || { };

    $proto->{$accessor} = { };
    @{ $proto->{$accessor} }{ keys %$value } = map { $_->id } values %$value;
    $DEBUG && $self->_carp("[update]: proto => '.$proto.' value => ".Dumper($proto->{$accessor}));

    if (%{tied(%$value)->deleted}) {
        while (my ($key, $thing) = each %{tied(%$value)->deleted}) {
            delete($proto->{$accessor}->{$key});
        }
        tied(%$value)->deleted({});
    }
    if (%{tied(%$value)->created}) {
        while (my ($key, $thing) = each %{tied(%$value)->created}) {
            $proto->{$accessor}->{$key} = defined $thing ? $thing->id : undef;
        }
        tied(%$value)->created({});
    }
    if (%{tied(%$value)->updated}) {
        while (my ($key, $thing) = each %{tied(%$value)->updated}) {
            $proto->{$accessor}->{$key} = defined $thing ? $thing->id : undef;
        }
        tied(%$value)->updated({});
    }

    $self->update_backrefs($obj, values %$value);

    $obj->dbh->commit;
}

sub delete {
    my $self = shift;
    my ($query, $obj) = @_;
    my $accessor = $self->role;
    my $value = $obj->$accessor;

    if ($self->constraint eq 'Composition') {
	# composition, so cascade the delete
	foreach my $thing (values %$value) {
	    $thing->delete;
	}
    } elsif ($self->constraint eq 'Aggregation') {
	# aggregation so just clear the Hash
	%$value = ();
    }

    $self->update(@_);
}

sub search {

}

sub construct {
    my ($self, $obj) = @_;
    my $assoc_name = $self->role;

    my @args = ($self, $obj);

    $obj->{$assoc_name} = { } unless $obj->{$assoc_name};
    tie %{$obj->{$assoc_name}}, __PACKAGE__, @args;

    $DEBUG && $self->_carp("constructed $obj, accessor => $assoc_name, returns => ".Dumper($obj->{$assoc_name}));
}

sub load {
    my ($self, $owner) = @_;

    $DEBUG && $self->_carp("load : OWNER => $owner, ID => ".$owner->id." hash size => ");

    my $Hash = { };
    if ($owner->dbm->get( $owner->id )->{$self->role}) {
        $Hash = $owner->dbm->get( $owner->id )->{$self->role}->export;
    }

    $DEBUG && $self->_carp('load: hash => '.Dumper($Hash).' owner => '.$owner);

    my @args;
    foreach (keys(%$Hash)) {
	@args = ($self, $Hash->{$_});
	tie $Hash->{$_}, 'Oryx::DBM::Association::Reference', @args;
    }

    return $Hash;

}

sub fetch {
    my ($self, $thing, $owner) = @_;
    return $thing;
}

sub store {
    my ($self, $thing, $owner) = @_;
    return $thing;
}

1;
