use 5.008001;
use strict;
use warnings;

package BSON::Timestamp;
# ABSTRACT: Timestamp data for BSON

our $VERSION = '0.16';

sub new {
    my ( $class, $seconds, $increment ) = @_;
    bless {
        seconds   => $seconds,
        increment => $increment
    }, $class;
}

sub increment {
    my ( $self, $value ) = @_;
    $self->{increment} = $value if defined $value;
    return $self->{increment};
}

sub seconds {
    my ( $self, $value ) = @_;
    $self->{seconds} = $value if defined $value;
    return $self->{seconds};
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

BSON::Timestamp - Timestamp data for BSON

=head1 VERSION

version 0.16

=head1 SYNOPSIS

    use BSON;

    my $ts = BSON::Timestamp->new( $seconds, $increment );

=head1 DESCRIPTION

This module is needed for L<BSON> and it manages BSON's timestamp element.
C<Timestamp> is an internal MongoDB type used in replication and sharding.
The first four bytes are increment and the second four bytes are a timestamp.
A timestamp value of 0 has special semantics.

=head1 METHODS

=head2 new

Object constructor takes seconds and increment parameters.

=head2 seconds

Returns the value of C<seconds>

=head2 increment

Returns the value of C<increment>

=head1 SEE ALSO

L<BSON>

=head1 AUTHORS

=over 4

=item *

minimalist <minimalist@lavabit.com>

=item *

David Golden <david@mongodb.com>

=back

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by minimalist and MongoDB, Inc..

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut
