# Generated by default/object.tt
package Paws::ECS::FSxWindowsFileServerAuthorizationConfig;
  use Moose;
  has CredentialsParameter => (is => 'ro', isa => 'Str', request_name => 'credentialsParameter', traits => ['NameInRequest'], required => 1);
  has Domain => (is => 'ro', isa => 'Str', request_name => 'domain', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::FSxWindowsFileServerAuthorizationConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::FSxWindowsFileServerAuthorizationConfig object:

  $service_obj->Method(Att1 => { CredentialsParameter => $value, ..., Domain => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::FSxWindowsFileServerAuthorizationConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->CredentialsParameter

=head1 DESCRIPTION

The authorization configuration details for Amazon FSx for Windows File
Server file system. See FSxWindowsFileServerVolumeConfiguration
(https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_FSxWindowsFileServerVolumeConfiguration.html)
in the I<Amazon Elastic Container Service API Reference>.

For more information and the input format, see Amazon FSx for Windows
File Server Volumes
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/wfsx-volumes.html)
in the I<Amazon Elastic Container Service Developer Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CredentialsParameter => Str

The authorization credential option to use. The authorization
credential options can be provided using either the Amazon Resource
Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager
Parameter Store parameter. The ARNs refer to the stored credentials.


=head2 B<REQUIRED> Domain => Str

A fully qualified domain name hosted by an AWS Directory Service
(https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html)
Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon
EC2.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

