package OpenInteract::SQLInstall::ObjectActivity;

# $Id: ObjectActivity.pm,v 1.5 2002/05/02 12:38:59 lachoy Exp $

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my %files = (
 tables        => [ 'object_track.sql' ],
 tables_oracle => [ 'object_track_oracle.sql', 'object_track_sequence.sql' ],
 tables_pg     => [ 'object_track.sql', 'object_track_sequence.sql' ],
 tables_ib     => [ 'object_track_interbase.sql', 'object_track_generator.sql' ],
 data          => [],
 security      => [ 'install_security.dat' ],

);

%HANDLERS = (
 create_structure => { '_default_' => [ 'create_structure',
                                        { table_file_list => $files{tables} } ],
                       'Oracle'    => [ 'create_structure',
                                        { table_file_list => $files{tables_oracle} } ],
                       'Pg'        => [ 'create_structure',
                                        { table_file_list => $files{tables_pg} } ],
                       'InterBase' => [ 'create_structure',
                                        { table_file_list => $files{tables_ib} } ],
 },
 install_data     => { '_default_' => [ 'install_data',
                                        { data_file_list => $files{data} } ] },
 install_security => { '_default_' => [ 'install_data',
                                        { data_file_list => $files{security} } ] },
);

1;
