package Business::EDI::CodeList::AlgorithmCoded;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {return "0527";}
my $usage       = 'B';

# 0527  Algorithm, coded
# Desc: Identification of the algorithm.
# Repr: an..3

my %code_hash = (
'1' => [ 'DES',
    'Data Encryption Standard. FIPS Pub 46 (January 1977).' ],
'2' => [ 'MAA',
    'Message Authentication Algorithm. Banking-Approved Algorithms for message Authentication. ISO 8731-2.' ],
'3' => [ 'FEAL',
    'FEAL Fast Data Encipherment Algorithm.' ],
'4' => [ 'IDEA',
    'International Data Encryption Algorithm: Lai X., Massey J. ""A Proposal for a New Block Encryption Standard"", Proceedings of Eurocrypt\'90, LNCS vol 473, Springer- Verlag, Berlin 1991, and Lai X., Massey J. ""Markov Ciphers and Differential Cryptanalysis"", Proceedings of Eurocrypt\'91, LNCS vol 547, Springer-Verlag, Berlin 1991.' ],
'5' => [ 'MD4',
    'The MD4 Message digest algorithm. Rivest R. RSA Data Security Inc. (1990).' ],
'6' => [ 'MD5',
    'The MD5 Message digest algorithm. Rivest R. Dusse S. RSA Data Security Inc. (1991).' ],
'7' => [ 'RIPEMD',
    'Extension of the MD4 - Ripe Report CS - R9324, April 93.' ],
'8' => [ 'SHA',
    'Secure Hashing Algorithm.' ],
'9' => [ 'AR/DFP',
    'Hash function of the German banking industry, submitted to ISO/IEC JTC 1/SC 27/WG 2, Doc N179.' ],
'10' => [ 'RSA',
    'Rivest, Shamir, Adleman: A Method for obtaining Digital Signatures and Public Key Cryptosystems.  Communications of the ACM, Vol.21(2), pp 120-126 (1978).' ],
'11' => [ 'DSA',
    'Digital Signature Algorithm/Digital Signature Standard NIST Pub 1993 Draft.' ],
'12' => [ 'RAB',
    'Rabin, "Digitalized signatures and public-key functions as intractable as factorization", MIT Laboratory for Computer Science Technical Report LCS/TR-212, Cambridge, Mass, 1979.' ],
'13' => [ 'TDEA',
    'Triple Data Encryption Algorithm; ANSI X9.52.' ],
'14' => [ 'RIPEMD-160',
    'Dedicated Hash-Function #1; ISO 10118-3.' ],
'15' => [ 'RIPEMD-128',
    'Dedicated Hash-Function #2; ISO 10118-3.' ],
'16' => [ 'SHA-1',
    'Secure Hash Algorithm, dedicated Hash-Function #3; ISO 10118-3.' ],
'17' => [ 'ECC',
    'Elliptic Curve Algorithm, Draft IEEE P1363 standard.' ],
'18' => [ 'ZLIB',
    'Data compression algorithm; Deflate/inflate algorithm published in RFC1950, RFC1951 and RFC1952.' ],
'20' => [ 'INFOZIP',
    'Data compression algorithm.' ],
'21' => [ 'OLZW',
    "Data compression algorithm; Optimized LZW; Published in 'Dr. Dobb's Journal' (Jun 1990)." ],
'22' => [ 'ARITCODE',
    "Data compression algorithm; Arithmetic coding; Published in 'Comm. Of the ACM' (Jun 1987)." ],
'23' => [ 'SHUFF',
    "Data compression algorithm; Static Huffman; Published in 'Proceedings of the I.R.E.' (Sep. 1952)." ],
'24' => [ 'DHUFF',
    "Data compression algorithm; Dynamic Huffman; Published in 'ACM Transaction on Mathematical Software' (Jun 1989)." ],
'25' => [ 'CRC-32',
    'Cyclic Redundancy Check - 32-bit; Ethernet CRC.' ],
'26' => [ 'CRC-CCITT',
    'Cyclic Redundancy Check - 16-bit.' ],
'27' => [ 'ISO12042',
    'Data compression for information exchange - Binary arithmetic coding algorithm; ISO-12042.' ],
'28' => [ 'RC4',
    'Variable-Key Size Symmetric Stream Cipher, specified by RSA Security Inc.' ],
'29' => [ 'RC5',
    'Variable-Key Size Symmetric Block Cipher, published in RFC 2040.' ],
'30' => [ 'HMAC-SHA1',
    'Message Authentication using keyed SHA-1 (published in RFC 2104).' ],
'31' => [ 'HMAC-MD5',
    'Message Authentication using keyed MD5 (published in RFC 2104).' ],
'32' => [ 'HMAC-RIPEMD-160',
    'Messahe Authentication using keyed RIPEMD-160 (published in RFC 2104).' ],
'33' => [ 'HMAC-RIPEMD-128',
    'Message Authentication using keyed RIPEMD-128 (published in RFC 2104).' ],
'34' => [ 'DB-MACv3',
    'MAC calculation (variant 3), using RIPEMD-160 and triple DES (published by Deutsche Bundesbank 1998).' ],
'35' => [ 'LZ77',
    'Lempel Ziv, 1977 data compression algorithm.' ],
'36' => [ 'LZW',
    'Lempel Ziv Welch data compression algorithm.' ],
'37' => [ 'MAC-ISO 8731-1',
    'Message authentication code defined in ISO 8731, Part 1.' ],
'38' => [ 'DIM1',
    'Data integrity mechanism using a cryptographic check function; ISO DIS 9797, first method.' ],
'39' => [ 'DIM2',
    'Data integrity mechanism using a cryptographic check function; ISO DIS 9797, second method.' ],
'40' => [ 'MDC2',
    'Modification detection code, IBM System Journal, vol 13, #2, 1991.' ],
'41' => [ 'HDS1',
    'ISO CD 10118-1, hash functions -part 1; hash functions using an n-bit block cipher algorithm providing a single length hash code.' ],
'42' => [ 'HDS2',
    'ISO CD 10118-1, hash functions -part 1; hash functions using an n-bit block cipher algorithm providing a double length hash code.' ],
'43' => [ 'SQM',
    'ISO 9594-8. Square-Mod-N hash function for RSA.' ],
'44' => [ 'NVB 7.1',
    'Dutch banking standard for hashing and signing using RSA.' ],
'45' => [ 'PKCS#1-v2_MGF1',
    'Mask Generation Function defined in PKCS#1, Version 2.' ],
'46' => [ 'NVBAK',
    'Dutch banking standard, NVB Authenticity Mark,  published by the NVB, May 1992.' ],
'47' => [ 'MCCP',
    'Banking key management by means of asymmetric algorithms, algorithms using the RSA cryptosystem. Signature construction by means of a separate signature. ISO 11166- 2.' ],
'48' => [ 'SHA-256',
    'Secure Hash Algorithm, dedicated Hash-Function #4; ISO 10118-3.' ],
'49' => [ 'SHA-512',
    'Secure Hash Algorithm, dedicated Hash-Function #5; ISO 10118-3.' ],
'50' => [ 'SHA-384',
    'Secure Hash Algorithm, dedicated Hash-Function #6; ISO 10118-3.' ],
'51' => [ 'WHIRLPOOL',
    'Secure Hash Algorithm, dedicated Hash-Function #7; ISO 10118-3.' ],
'52' => [ 'SHA-224',
    'Secure Hash Algorithm standard issued by NIST (National Institute of Standards and Technology) in FIPS PUB 180-2 (Change Notice 1, 2004).' ],
'ZZZ' => [ 'Mutually agreed',
    'Mutually agreed between trading partners.' ],
);
sub get_codes { return \%code_hash; }

1;
