package MPM::<!-- cgi: ProjectName -->::Root; # $Id$
use strict;

=head1 NAME

MPM::<!-- cgi: ProjectName -->::Root - root controller (/)

=head1 VERSION

Version <!-- cgi: ProjectVersion -->

=head1 DESCRIPTION

Root controller (/)

=cut

use vars qw($VERSION);
our $VERSION = <!-- cgi: ProjectVersion -->;

use Apache2::Const;
use CTK::Util qw/ :API /;

my ( $template, $q, %usr, %h, @error, $actObject, $actEvent );

sub record {
    (
        -uri      => '/',
        
        -init     => \&hInit,
        -type     => \&hType,
        -fixup    => \&hFixup,
        -response => \&hResponse,
        -cleanup  => \&hCleanup,

        -meta     => {
            default => {
                handler => {
                    cchck => \&default_chck, # controller level
                    vform => \&default_form, # view level
                    mproc => \&default_proc, # model level
                    caccess => sub { 1 },    # controller level
                },
                content_type => '<!-- cgi: ContentType -->',
            },
        },
    )
}
sub hInit {
    my $m = shift;
 
    %h = ();
    @error = ();

    $q = new CGI;
    %usr = ();
    foreach ($q->all_parameters) {
        $usr{$_} = $q->param($_);
        Encode::_utf8_on($usr{$_}); # if $_ !~ /file/;
    }

    ($actObject,$actEvent) = split /[,]/, $usr{action} || '';
    $actObject = 'default' unless $actObject && $m->ActionCheck($actObject);
    $actEvent  = $actEvent && $actEvent =~ /go/ ? 'go' : '';

    $template = new TemplateM(
            -file  => $m->getActionRecord($actObject)->{tplfile} ||
                ($m->conf('url_shtml').
                    ($m->getActionRecord($actObject)->{tplfileprefix} || '').
                    "/".($m->getActionRecord($actObject)->{tplfilename} || $actObject).
                    ($m->getActionRecord($actObject)->{tplfilesuffix} || '.shtml')
                ),
            -cache => catfile($m->conf('document_root'),$m->conf('dir_cache')),
            -time  => $m->getActionRecord($actObject)->{tpltime} || 0,
            -utf8  => 1,
        );
    return Apache2::Const::OK;
}
sub hType {
    my $m = shift;
    my $r = $m->r;
    
    $r->content_type($m->getActionRecord($actObject)->{content_type} || $m->conf('content_type'));

    return Apache2::Const::OK;
}
sub hFixup {
    return Apache2::Const::OK;
}
sub hResponse {
    my $m = shift;
    my $r = $m->r;

    my $status = $m->ActionTransaction($actObject,$actEvent);
    return $status if ($status == Apache2::Const::REDIRECT);
    
    $template->cast_if("error",@error);
    my $errbox = $template->start("error");
    $errbox->loop(text=>$_) foreach (@error);
    $errbox->finish();

    $template->stash(\%h);
    $r->print($template->output());
    $r->rflush();
    return $status;
}
sub hCleanup {
    my $m = shift;
    
    undef $template;
    undef $q;
    undef %h;
    undef %usr;
     
    return Apache2::Const::OK;
}

sub default_chck {
    return @error ? 0 : 1
}
sub default_form {
    my $m = shift;
    $template->stash($m->get_node('conf'));
    return Apache2::Const::OK;
}
sub default_proc {
    my $m = shift;
    my $r = $m->r;

    $r->headers_out->set(Location => $m->conf('url').'/info.mpm');
    return Apache2::Const::REDIRECT;
}

1;
