# Generated by default/object.tt
package Paws::SecurityHub::AwsElbLoadBalancerDetails;
  use Moose;
  has AvailabilityZones => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has BackendServerDescriptions => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsElbLoadBalancerBackendServerDescription]');
  has CanonicalHostedZoneName => (is => 'ro', isa => 'Str');
  has CanonicalHostedZoneNameID => (is => 'ro', isa => 'Str');
  has CreatedTime => (is => 'ro', isa => 'Str');
  has DnsName => (is => 'ro', isa => 'Str');
  has HealthCheck => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerHealthCheck');
  has Instances => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsElbLoadBalancerInstance]');
  has ListenerDescriptions => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsElbLoadBalancerListenerDescription]');
  has LoadBalancerAttributes => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerAttributes');
  has LoadBalancerName => (is => 'ro', isa => 'Str');
  has Policies => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerPolicies');
  has Scheme => (is => 'ro', isa => 'Str');
  has SecurityGroups => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SourceSecurityGroup => (is => 'ro', isa => 'Paws::SecurityHub::AwsElbLoadBalancerSourceSecurityGroup');
  has Subnets => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsElbLoadBalancerDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsElbLoadBalancerDetails object:

  $service_obj->Method(Att1 => { AvailabilityZones => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsElbLoadBalancerDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AvailabilityZones

=head1 DESCRIPTION

Contains details about a Classic Load Balancer.

=head1 ATTRIBUTES


=head2 AvailabilityZones => ArrayRef[Str|Undef]

The list of Availability Zones for the load balancer.


=head2 BackendServerDescriptions => ArrayRef[L<Paws::SecurityHub::AwsElbLoadBalancerBackendServerDescription>]

Information about the configuration of the EC2 instances.


=head2 CanonicalHostedZoneName => Str

The name of the Amazon Route 53 hosted zone for the load balancer.


=head2 CanonicalHostedZoneNameID => Str

The ID of the Amazon Route 53 hosted zone for the load balancer.


=head2 CreatedTime => Str

Indicates when the load balancer was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 DnsName => Str

The DNS name of the load balancer.


=head2 HealthCheck => L<Paws::SecurityHub::AwsElbLoadBalancerHealthCheck>

Information about the health checks that are conducted on the load
balancer.


=head2 Instances => ArrayRef[L<Paws::SecurityHub::AwsElbLoadBalancerInstance>]

List of EC2 instances for the load balancer.


=head2 ListenerDescriptions => ArrayRef[L<Paws::SecurityHub::AwsElbLoadBalancerListenerDescription>]

The policies that are enabled for the load balancer listeners.


=head2 LoadBalancerAttributes => L<Paws::SecurityHub::AwsElbLoadBalancerAttributes>

The attributes for a load balancer.


=head2 LoadBalancerName => Str

The name of the load balancer.


=head2 Policies => L<Paws::SecurityHub::AwsElbLoadBalancerPolicies>

The policies for a load balancer.


=head2 Scheme => Str

The type of load balancer. Only provided if the load balancer is in a
VPC.

If C<Scheme> is C<internet-facing>, the load balancer has a public DNS
name that resolves to a public IP address.

If C<Scheme> is C<internal>, the load balancer has a public DNS name
that resolves to a private IP address.


=head2 SecurityGroups => ArrayRef[Str|Undef]

The security groups for the load balancer. Only provided if the load
balancer is in a VPC.


=head2 SourceSecurityGroup => L<Paws::SecurityHub::AwsElbLoadBalancerSourceSecurityGroup>

Information about the security group for the load balancer. This is the
security group that is used for inbound rules.


=head2 Subnets => ArrayRef[Str|Undef]

The list of subnet identifiers for the load balancer.


=head2 VpcId => Str

The identifier of the VPC for the load balancer.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

