/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* unxfbind.c
**/


#include <string.h>

#include "pfile.h"
#include "ptemplat.h"
#include "parameter.h"

#include "f77.h"

extern char CString1[];
extern char CString2[];

#define F2CStr	strf2c
#define C2FStr	strc2f

#define F2CStr1(length, string)	F2CStr(length, string, CString1)
#define F2CStr2(length, string)	F2CStr(length, string, CString2)

void
PARAMOPEN_F77 (char *filename,
	       char *mode, paramfile * pf, int nfilename, int nmode)
{
  int argc;
  char **argv;

  char *cmode;

  argv = GetF77argv (&argc);

  if (!strpbrk (cmode = F2CStr1 (nmode, mode), "$"))
    argc = 1;

  *pf = c_paramopen ((!filename
		      || (filename && *filename == '$' && nfilename == 1))
		     ? NULL : F2CStr2 (nfilename, filename), argv, argc,
		     cmode);
}

void
PARAMLIST_F77 (paramfile * pfile)
{
  paramlist (*pfile);
}


void
PARAMCLOSE_F77 (paramfile * pfile)
{
  paramclose (*pfile);
}

void
PARAMFIND_F77 (char *name, char *path, int nname, int npath)
{
  C2FStr (paramfind (F2CStr1 (nname, name), NULL, NULL, NULL), path, npath);
}

void
PARAMERR_F77 (int *level, char *message, char *name, int nmessage, int nname)
{
  paramerr (*level, F2CStr1 (nmessage, message), F2CStr2 (nname, name));
}

void
PARAMERRSTR_F77 (char *errstr, int nerrstr)
{
  C2FStr (paramerrstr (), errstr, nerrstr);
}

#define ParamGet(Return, Routine, Type, type, chekindef, retindef)	\
  void Routine(								\
    ParamFile	*pfile,							\
    char	*name,							\
    Return	*value,							\
    int		*status,						\
    int		 nname	);						\
									\
  void Routine(								\
    ParamFile	*pfile,							\
    char	*name,							\
    Return	*value,							\
    int		*status,						\
    int		 nname							\
    )									\
{									\
		type	*v;						\
									\
	*status = 0;							\
									\
	if ( (v = ParamGetX(*pfile, F2CStr1(nname, name)		\
			    , Type, &(*pfile)->mode)) ) 		\
	    if (*v == chekindef ) {					\
		*status = 3;						\
		*value  = retindef;					\
	    } else							\
	    	*value  = *v;						\
	else								\
		*status = 1;						\
									\
}

#define PGETB_F77 F77_FUNC(pgetb,PGETB)
#define PGETS_F77 F77_FUNC(pgets,PGETS)
#define PGETI_F77 F77_FUNC(pgeti,PGETI)
#define PGETL_F77 F77_FUNC(pgetl,PGETL)
#define PGETR_F77 F77_FUNC(pgetr,PGETR)
#define PGETF_F77 F77_FUNC(pgetf,PGETF)
#define PGETD_F77 F77_FUNC(pgetd,PGETD)

ParamGet (int, PGETB_F77, BooleanType, int, INDEFI, INDEFI)
ParamGet (short, PGETS_F77, IntegerType, int, INDEFI, INDEFS)
ParamGet (int, PGETI_F77, IntegerType, int, INDEFI, INDEFI)
ParamGet (int, PGETL_F77, IntegerType, int, INDEFI, INDEFI)
ParamGet (float, PGETR_F77, RealType, real, INDEFD, INDEFR)
ParamGet (float, PGETF_F77, RealType, real, INDEFD, INDEFR)
ParamGet (double, PGETD_F77, RealType, real, INDEFD, INDEFD)
     void PGETSTR_F77 (ParamFile * pfile,
		       char *name,
		       char *string, int *status, int nname, int nstring)
{
  void *v;

  *status = 0;

  if ((v =
       ParamGetX (*pfile, F2CStr1 (nname, name), StringType,
		  &(*pfile)->mode)))
    C2FStr (v, string, nstring);
  else
    *status = 1;
}


#define ParamPut(Take, Routine, Type, type, chekindef, putindef)	\
void Routine(								\
  ParamFile	*pfile,							\
  char		*name,							\
  Take		*value,							\
  int		*status,						\
  int		 nname	);						\
									\
void Routine(								\
  ParamFile	*pfile,							\
  char		*name,							\
  Take		*value,							\
  int		*status,						\
  int		 nname							\
  )									\
{									\
		type xvalue = *value;					\
									\
	*status = 0;							\
									\
	if ( *value == chekindef ) xvalue = putindef;			\
	else			   xvalue = xvalue;			\
									\
	if ( !ParamSetX(*pfile, F2CStr1(nname, name), Type, &xvalue) )	\
		*status = 1;						\
}

#define PPUTB_F77 F77_FUNC(pputb,PPUTB)
#define PPUTS_F77 F77_FUNC(pputs,PPUTS)
#define PPUTI_F77 F77_FUNC(pputi,PPUTI)
#define PPUTL_F77 F77_FUNC(pputl,PPUTL)
#define PPUTR_F77 F77_FUNC(pputr,PPUTR)
#define PPUTF_F77 F77_FUNC(pputf,PPUTF)
#define PPUTD_F77 F77_FUNC(pputd,PPUTD)

ParamPut (int, PPUTB_F77, BooleanType, int, INDEFI, INDEFI)
ParamPut (short, PPUTS_F77, IntegerType, int, INDEFS, INDEFI)
ParamPut (int, PPUTI_F77, IntegerType, int, INDEFI, INDEFI)
ParamPut (int, PPUTL_F77, IntegerType, int, INDEFI, INDEFI)
ParamPut (float, PPUTR_F77, RealType, real, INDEFR, INDEFD)
ParamPut (float, PPUTF_F77, RealType, real, INDEFR, INDEFD)
ParamPut (double, PPUTD_F77, RealType, real, INDEFD, INDEFD)
     void PPUTSTR_F77 (ParamFile * pfile,
		       char *name,
		       char *string, int *status, int nname, int nstring)
{
  *status = 0;

  if (!ParamSetX
      (*pfile, F2CStr1 (nname, name), StringType, F2CStr2 (nstring, string)))
    *status = 1;
}
