package SortExample::Color::Rainbow::EN;

use strict;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-01-26'; # DATE
our $DIST = 'SortExample-Color-Rainbow-EN'; # DIST
our $VERSION = '0.001'; # VERSION

sub meta {
    +{
        v => 1,
        args => {},
    };
}

sub get_example {
    my %args = @_;

    [
        "red",
        "orange",
        "yellow",
        "green",
        "blue",
        "indigo",
        "violet",
    ];
}

1;
# ABSTRACT: Ordered list of names of colors in the rainbow, in English

__END__

=pod

=encoding UTF-8

=head1 NAME

SortExample::Color::Rainbow::EN - Ordered list of names of colors in the rainbow, in English

=head1 VERSION

This document describes version 0.001 of SortExample::Color::Rainbow::EN (from Perl distribution SortExample-Color-Rainbow-EN), released on 2024-01-26.

=head1 DESCRIPTION

This is an example L<SortExample> module.

=for Pod::Coverage ^(meta|get_example)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/SortExample-Color-Rainbow-EN>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-SortExample-Color-Rainbow-EN>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=SortExample-Color-Rainbow-EN>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
