/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.Types;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.store.ValuePool;

final class DITypeInfo {
    static final int columnNoNulls = 0;
    static final int columnNullable = 1;
    static final int typePredNone = 0;
    static final int typePredChar = 1;
    static final int typePredBasic = 2;
    static final int typeSearchable = 3;
    private int hnd_create_params = -1;
    private int hnd_local_names = -1;
    private int hnd_remarks = -1;
    private int type = 0;
    private int typeSub = 1;
    boolean locale_set;
    static /* synthetic */ Class class$org$hsqldb$resources$BundleHandler;

    DITypeInfo() {
    }

    Integer getCharOctLen() {
        return null;
    }

    Long getCharOctLenAct() {
        switch (this.type) {
            case -1: 
            case 1: 
            case 12: {
                return ValuePool.getLong(0xFFFFFFFEL);
            }
            case 2005: {
                return ValuePool.getLong(Long.MAX_VALUE);
            }
        }
        return null;
    }

    String getColStClsName() {
        return Types.getColStClsName(this.type);
    }

    String getCreateParams() {
        String string;
        if (!this.locale_set) {
            this.setLocale(Locale.getDefault());
        }
        switch (this.type) {
            case 1: 
            case 12: {
                string = "LENGTH";
                break;
            }
            case 2: 
            case 3: {
                string = "PRECISION,SCALE";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    String getCstMapClsName() {
        switch (this.type) {
            case 2003: {
                return "org.hsqldb.jdbc.jdbcArray";
            }
            case 2004: {
                return "org.hsqldb.jdbc.jdbcBlob";
            }
            case 2005: {
                return "org.hsqldb.jdbc.jdbcClob";
            }
            case 2001: {
                return "org.hsqldb.jdbc.jdbcDistinct";
            }
            case 2006: {
                return "org.hsqldb.jdbc.jdbcRef";
            }
            case 2002: {
                return "org.hsqldb.jdbc.jdbcStruct";
            }
        }
        return null;
    }

    int getMaxDisplaySize() {
        return Types.getMaxDisplaySize(this.type);
    }

    Integer getDataType() {
        return ValuePool.getInt(this.type);
    }

    Integer getDataTypeSub() {
        return ValuePool.getInt(this.typeSub);
    }

    Integer getDefaultScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return ValuePool.getInt(0);
            }
        }
        return null;
    }

    Integer getIntervalPrecision() {
        return null;
    }

    String getLiteralPrefix() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return "'";
            }
            case 70: {
                return "'";
            }
            case 91: {
                return "'";
            }
            case 1111: {
                return "'";
            }
            case 92: {
                return "'";
            }
            case 93: {
                return "'";
            }
            case 137: {
                return "'";
            }
        }
        return null;
    }

    String getLiteralSuffix() {
        switch (this.type) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                return "'";
            }
            case 70: 
            case 91: 
            case 92: 
            case 93: 
            case 137: 
            case 1111: {
                return "'";
            }
        }
        return null;
    }

    String getLocalName() {
        if (!this.locale_set) {
            this.setLocale(Locale.getDefault());
        }
        String string = this.getTypeName();
        return BundleHandler.getString(this.hnd_local_names, string);
    }

    Integer getMaxScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 91: {
                return ValuePool.getInt(0);
            }
            case 2: 
            case 3: {
                return ValuePool.getInt(Short.MAX_VALUE);
            }
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(306);
            }
        }
        return null;
    }

    Integer getMaxScaleAct() {
        switch (this.type) {
            case 2: 
            case 3: {
                return ValuePool.getInt(Integer.MAX_VALUE);
            }
        }
        return this.getMaxScale();
    }

    Integer getMinScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 91: {
                return ValuePool.getInt(0);
            }
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(-324);
            }
        }
        return null;
    }

    Integer getMinScaleAct() {
        return this.getMinScale();
    }

    Integer getNullability() {
        return ValuePool.getInt(1);
    }

    Integer getNumPrecRadix() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ValuePool.getInt(10);
            }
        }
        return null;
    }

    Integer getPrecision() {
        int n = Types.getPrecision(this.type);
        return n == 0 ? null : ValuePool.getInt(n);
    }

    Long getPrecisionAct() {
        Integer n = this.getPrecision();
        if (n == null) {
            return ValuePool.getLong(Long.MAX_VALUE);
        }
        return ValuePool.getLong(n.longValue());
    }

    String getRemarks() {
        if (!this.locale_set) {
            this.setLocale(Locale.getDefault());
        }
        String string = this.getTypeName();
        return BundleHandler.getString(this.hnd_remarks, string);
    }

    Integer getSearchability() {
        return Types.isSearchable(this.type) ? ValuePool.getInt(3) : ValuePool.getInt(0);
    }

    Integer getSqlDataType() {
        switch (this.type) {
            case 2003: {
                return ValuePool.getInt(50);
            }
            case -5: {
                return ValuePool.getInt(25);
            }
            case -2: {
                return ValuePool.getInt(30);
            }
            case 16: {
                return ValuePool.getInt(16);
            }
            case 2004: {
                return ValuePool.getInt(30);
            }
            case 1: {
                return ValuePool.getInt(1);
            }
            case 2005: {
                return ValuePool.getInt(40);
            }
            case 70: {
                return ValuePool.getInt(70);
            }
            case 91: {
                return ValuePool.getInt(9);
            }
            case 3: {
                return ValuePool.getInt(3);
            }
            case 2001: {
                return ValuePool.getInt(17);
            }
            case 8: {
                return ValuePool.getInt(8);
            }
            case 6: {
                return ValuePool.getInt(6);
            }
            case 4: {
                return ValuePool.getInt(4);
            }
            case 2000: {
                return ValuePool.getInt(2000);
            }
            case -4: {
                return ValuePool.getInt(30);
            }
            case -1: {
                return ValuePool.getInt(40);
            }
            case 0: {
                return ValuePool.getInt(0);
            }
            case 2: {
                return ValuePool.getInt(2);
            }
            case 1111: {
                return ValuePool.getInt(1111);
            }
            case 7: {
                return ValuePool.getInt(7);
            }
            case 2006: {
                return ValuePool.getInt(20);
            }
            case 5: {
                return ValuePool.getInt(5);
            }
            case 2002: {
                return ValuePool.getInt(17);
            }
            case 92: {
                return ValuePool.getInt(9);
            }
            case 93: {
                return ValuePool.getInt(9);
            }
            case -6: {
                return ValuePool.getInt(-6);
            }
            case -3: {
                return ValuePool.getInt(30);
            }
            case 12: {
                return ValuePool.getInt(12);
            }
            case 137: {
                return ValuePool.getInt(137);
            }
        }
        return null;
    }

    Integer getSqlDateTimeSub() {
        switch (this.type) {
            case 91: {
                return ValuePool.getInt(1);
            }
            case 92: {
                return ValuePool.getInt(2);
            }
            case 93: {
                return ValuePool.getInt(3);
            }
        }
        return null;
    }

    String getStdMapClsName() {
        switch (this.type) {
            case 2003: {
                return "java.sql.Array";
            }
            case -5: {
                return "long";
            }
            case -4: 
            case -3: 
            case -2: {
                return "[B";
            }
            case 16: {
                return "boolean";
            }
            case 2004: {
                return "java.sql.Blob";
            }
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2005: {
                return "java.sql.Clob";
            }
            case 70: {
                return "java.net.URL";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case 137: 
            case 1111: 
            case 2000: 
            case 2001: {
                return "java.lang.Object";
            }
            case 6: 
            case 7: 
            case 8: {
                return "double";
            }
            case 4: {
                return "int";
            }
            case 0: {
                return "null";
            }
            case 2006: {
                return "java.sql.Ref";
            }
            case 5: {
                return "short";
            }
            case 2002: {
                return "java.sql.Struct";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -6: {
                return "byte";
            }
        }
        return null;
    }

    int getTypeCode() {
        return this.type;
    }

    String getTypeName() {
        return this.typeSub == 4 ? Types.getTypeName(100) : Types.getTypeName(this.type);
    }

    int getTypeSub() {
        return this.typeSub;
    }

    Boolean isAutoIncrement() {
        switch (this.type) {
            case -6: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
            case -5: 
            case 4: {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    Boolean isCaseSensitive() {
        return this.typeSub == 4 ? Boolean.TRUE : Types.isCaseSensitive(this.type);
    }

    Boolean isColStClsSupported() {
        return ValuePool.getBoolean(this.type == 0 ? true : this.getColStClsName() != null);
    }

    Boolean isFixedPrecisionScale() {
        switch (this.type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    Boolean isStdMapClsSupported() {
        boolean bl = false;
        switch (this.type) {
            case 2003: {
                try {
                    Class.forName("java.sql.Array");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2004: {
                try {
                    Class.forName("java.sql.Blob");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2005: {
                try {
                    Class.forName("java.sql.Clob");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2001: {
                bl = false;
                break;
            }
            case 2006: {
                try {
                    Class.forName("java.sql.Ref");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            case 2002: {
                try {
                    Class.forName("java.sql.Struct");
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
                break;
            }
            default: {
                bl = this.getStdMapClsName() != null;
            }
        }
        return ValuePool.getBoolean(bl);
    }

    Boolean isSupportedAsPCol() {
        switch (this.type) {
            case 0: 
            case 2000: 
            case 2003: {
                return Boolean.TRUE;
            }
        }
        return this.isSupportedAsTCol();
    }

    Boolean isSupportedAsTCol() {
        if (this.type == 0) {
            return Boolean.FALSE;
        }
        String string = Types.getTypeString(this.type);
        return ValuePool.getBoolean(string != null);
    }

    Boolean isUnsignedAttribute() {
        return Types.isUnsignedAttribute(this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setLocale(Locale locale) {
        if (locale == null) {
            this.hnd_remarks = -1;
            this.hnd_local_names = -1;
            this.hnd_create_params = -1;
            this.locale_set = false;
            return;
        }
        Class clazz = class$org$hsqldb$resources$BundleHandler == null ? (class$org$hsqldb$resources$BundleHandler = DITypeInfo.class$("org.hsqldb.resources.BundleHandler")) : class$org$hsqldb$resources$BundleHandler;
        synchronized (clazz) {
            Locale locale2 = BundleHandler.getLocale();
            BundleHandler.setLocale(locale);
            this.hnd_create_params = BundleHandler.getBundleHandle("data-type-create-parameters", null);
            this.hnd_local_names = BundleHandler.getBundleHandle("data-type-names", null);
            this.hnd_remarks = BundleHandler.getBundleHandle("data-type-remarks", null);
            BundleHandler.setLocale(locale2);
            this.locale_set = true;
        }
    }

    void setTypeCode(int n) {
        this.type = n;
    }

    void setTypeSub(int n) {
        this.typeSub = n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

