#
# $Id: Regex.pm,v 36c642ac94d3 2015/10/12 19:05:47 gomor $
#
# string::regex Brik
#
package Metabrik::String::Regex;
use strict;
use warnings;

use base qw(Metabrik);

sub brik_properties {
   return {
      revision => '$Revision: 36c642ac94d3 $',
      tags => [ qw(unstable encode decode hex) ],
      attributes => {
      },
      attributes_default => {
      },
      commands => {
         encode => [ qw($regex|$regex_list) ],
      },
      require_modules => {
         'Regexp::Assemble' => [ ],
      },
   };
}

sub encode {
   my $self = shift;
   my ($regex) = @_;

   if (! defined($regex)) {
      return $self->log->error($self->brik_help_run('encode'));
   }

   my $ra = Regexp::Assemble->new
      or return $self->log->error("encode: Regexp::Assemble new failed");

   if (ref($regex)) {
      for my $this (@$regex) {
         $ra->add($this);
      }
   }
   elsif (! ref($regex)) {
      $ra->add($regex);
   }

   my $encoded;
   eval {
      $encoded = $ra->re;
   };
   if ($@) {
      chomp($@);
      return $self->log->error("encode: assembling failed [$@]");
   }

   return $encoded;
}

1;

__END__

=head1 NAME

Metabrik::String::Regex - string::regex Brik

=head1 COPYRIGHT AND LICENSE

Copyright (c) 2014-2015, Patrice E<lt>GomoRE<gt> Auffret

You may distribute this module under the terms of The BSD 3-Clause License.
See LICENSE file in the source distribution archive.

=head1 AUTHOR

Patrice E<lt>GomoRE<gt> Auffret

=cut
