# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Bank-Holidays.t'

use strict;

use Test::More tests => 12;

use_ok("Bank::Holidays");
use_ok("DateTime");

is($Bank::Holidays::VERSION, '0.81', 'VERSION is correct');

my $curr = DateTime->now();
isa_ok($curr, "DateTime");

# Check any old day is not a holiday
my $bank = Bank::Holidays->new( dt => DateTime->new(month => 9, day => 30, year => $curr->year));
ok(ref $bank eq 'Bank::Holidays', "Bank::Holidays object with 'dt' parameter");
ok(!$bank->is_holiday, "Not a holiday 'Today' check");

# Check the tomorrow parameter.
ok(!$bank->is_holiday(Tomorrow => 1), "Not a holiday 'Tomorrow' check");

# Check the yesterday parameter.
ok(!$bank->is_holiday(Yesterday => 1), "Not a holiday 'Yesterday' check");

# Test with 'date' argument to constructor
undef $bank;
$bank = Bank::Holidays->new( date => DateTime->new(month => 9, day => 30, year => $curr->year));
ok(ref $bank eq "Bank::Holidays", "Bank::Holidays object with 'date' parameter");

# Check "today"
ok(!$bank->is_holiday, "Not a holiday 'Today' check");

# Check the tomorrow parameter.
ok(!$bank->is_holiday(Tomorrow => 1), "Not a holiday 'Tomorrow' check");

# Check the yesterday parameter.
ok(!$bank->is_holiday(Yesterday => 1), "Not a holiday 'Yesterday' check");
