#!/usr/bin/perl -w

use t::app::Main;
use strict;

my $schema = t::app::Main->connect('dbi:SQLite:t/app/db/example.db');

#  here's some of the SQL that is going to be generated by the schema
#  INSERT INTO artist VALUES (NULL,'Michael Jackson');
#  INSERT INTO artist VALUES (NULL,'Eminem');

my @artists = (['Michael Jackson'], ['Eminem']);
$schema->populate('Artist', [
  [qw/name/],
  @artists,
  ]);

my %albums = (
  'Thriller' => 'Michael Jackson',
  'Bad' => 'Michael Jackson',
  'The Marshall Mathers LP' => 'Eminem',
);

my @cds;
foreach my $lp (keys %albums) {
  my $artist = $schema->resultset('Artist')->find({
      name => $albums{$lp}
    });
  push @cds, [$lp, $artist->id];
}

$schema->populate('Cd', [
  [qw/title artistid/],
  @cds,
  ]);


my %tracks = (
  'Beat It'         => 'Thriller',
  'Billie Jean'     => 'Thriller',
  'Dirty Diana'     => 'Bad',
  'Smooth Criminal' => 'Bad',
  'Leave Me Alone'  => 'Bad',
  'Stan'            => 'The Marshall Mathers LP',
  'The Way I Am'    => 'The Marshall Mathers LP',
);

my @tracks;
foreach my $track (keys %tracks) {
  my $cdname = $schema->resultset('Cd')->find({
      title => $tracks{$track},
    });
  push @tracks, [$cdname->id, $track];
}

$schema->populate('Track',[
  [qw/cdid title/],
  @tracks,
  ]);
