package Locales::DB::Territory::kln;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Territory::kln::VERSION = '0.09';

$Locales::DB::Territory::kln::cldr_version = '2.0';

%Locales::DB::Territory::kln::code_to_name = (
    '001' => 'World',
    '002' => 'Africa',
    '003' => "North\ America",
    '005' => "South\ America",
    '009' => 'Oceania',
    '011' => "Western\ Africa",
    '013' => "Central\ America",
    '014' => "Eastern\ Africa",
    '015' => "Northern\ Africa",
    '017' => "Middle\ Africa",
    '018' => "Southern\ Africa",
    '019' => 'Americas',
    '021' => "Northern\ America",
    '029' => 'Caribbean',
    '030' => "Eastern\ Asia",
    '034' => "Southern\ Asia",
    '035' => "South\-Eastern\ Asia",
    '039' => "Southern\ Europe",
    '053' => "Australia\ and\ New\ Zealand",
    '054' => 'Melanesia',
    '057' => "Micronesian\ Region",
    '061' => 'Polynesia',
    '062' => "South\-Central\ Asia",
    142   => 'Asia',
    143   => "Central\ Asia",
    145   => "Western\ Asia",
    150   => 'Europe',
    151   => "Eastern\ Europe",
    154   => "Northern\ Europe",
    155   => "Western\ Europe",
    172   => "Commonwealth\ of\ Independent\ States",
    200   => 'Czechoslovakia',
    419   => "Latin\ America",
    830   => "Channel\ Islands",
    'ac'  => "Ascension\ Island",
    'ad'  => "Emetab\ Andorra",
    'ae'  => "Emetab\ kibagenge\ nebo\ arabuk",
    'af'  => "Emetab\ Afghanistan",
    'ag'  => "Emetab\ Antigua\ ak\ Barbuda",
    'ai'  => "Emetab\ Anguilla",
    'al'  => "Emetab\ Albania",
    'am'  => "Emetab\ Armenia",
    'an'  => "Emetab\ Antile\ nebo\ Holand",
    'ao'  => "Emetab\ Angola",
    'aq'  => 'Antarctica',
    'ar'  => "Emetab\ Argentina",
    'as'  => "Emetab\ American\ Samoa",
    'at'  => "Emetab\ Austria",
    'au'  => "Emetab\ Australia",
    'aw'  => "Emetab\ Aruba",
    'ax'  => "\Ã\land\ Islands",
    'az'  => "Emetab\ Azerbaijan",
    'ba'  => "Emetab\ Bosnia\ ak\ Herzegovina",
    'bb'  => "Emetab\ Barbados",
    'bd'  => "Emetab\ Bangladesh",
    'be'  => "Emetab\ Belgium",
    'bf'  => "Emetab\ Burkina\ Faso",
    'bg'  => "Emetab\ Bulgaria",
    'bh'  => "Emetab\ Bahrain",
    'bi'  => "Emetab\ Burundi",
    'bj'  => "Emetab\ Benin",
    'bl'  => "Saint\ Barth\Ã\©lemy",
    'bm'  => "Emetab\ Bermuda",
    'bn'  => "Emetab\ Brunei",
    'bo'  => "Emetab\ Bolivia",
    'bq'  => "British\ Antarctic\ Territory",
    'br'  => "Emetab\ Brazil",
    'bs'  => "Emetab\ Bahamas",
    'bt'  => "Emetab\ Bhutan",
    'bv'  => "Bouvet\ Island",
    'bw'  => "Emetab\ Botswana",
    'by'  => "Emetab\ Belarus",
    'bz'  => "Emetab\ Belize",
    'ca'  => "Emetab\ Canada",
    'cc'  => "Cocos\ \[Keeling\]\ Islands",
    'cd'  => "Emetab\ Congo\ \-\ Kinshasa",
    'cf'  => "Emetab\ Afrika\ nebo\ Kwen",
    'cg'  => "Emetab\ Congo\ \-\ Brazzaville",
    'ch'  => "Emetab\ Switzerland",
    'ci'  => "Emetab\ Côte\ d\'Ivoire",
    'ck'  => "Ikwembeyotab\ Cook",
    'cl'  => "Emetab\ Chile",
    'cm'  => "Emetab\ Cameroon",
    'cn'  => "Emetab\ China",
    'co'  => "Emetab\ Colombia",
    'cp'  => "Clipperton\ Island",
    'cr'  => "Emetab\ Costa\ Rica",
    'cs'  => "Emetab\ Serbia\ and\ Montenegro",
    'ct'  => "Canton\ and\ Enderbury\ Islands",
    'cu'  => "Emetab\ Cuba",
    'cv'  => "Ikwembeyotab\ Cape\ Verde",
    'cx'  => "Christmas\ Island",
    'cy'  => "Emetab\ Cyprus",
    'cz'  => "Emetab\ Czech\ Republic",
    'dd'  => "East\ Germany",
    'de'  => "Emetab\ Geruman",
    'dg'  => "Diego\ Garcia",
    'dj'  => "Emetab\ Djibouti",
    'dk'  => "Emetab\ Denmark",
    'dm'  => "Emetab\ Dominica",
    'do'  => "Emetab\ Dominican\ Republic",
    'dz'  => "Emetab\ Algeria",
    'ea'  => "Ceuta\ and\ Melilla",
    'ec'  => "Emetab\ Ecuador",
    'ee'  => "Emetab\ Estonia",
    'eg'  => "Emetab\ Misiri",
    'eh'  => "Western\ Sahara",
    'er'  => "Emetab\ Eritrea",
    'es'  => "Emetab\ Spain",
    'et'  => "Emetab\ Ethiopia",
    'eu'  => "European\ Union",
    'fi'  => "Emetab\ Finland",
    'fj'  => "Emetab\ Fiji",
    'fk'  => "Ikwembeyotab\ Falkland",
    'fm'  => "Emetab\ Micronesia",
    'fo'  => "Faroe\ Islands",
    'fq'  => "French\ Southern\ and\ Antarctic\ Territories",
    'fr'  => "Emetab\ France",
    'fx'  => "Metropolitan\ France",
    'ga'  => "Emetab\ Gabon",
    'gb'  => "Emetab\ Kibagenge\ nebo\ Uingereza",
    'gd'  => "Emetab\ Grenada",
    'ge'  => "Emetab\ Georgia",
    'gf'  => "Emetab\ Guiana\ nebo\ Ufaransa",
    'gg'  => 'Guernsey',
    'gh'  => "Emetab\ Ghana",
    'gi'  => "Emetab\ Gibraltar",
    'gl'  => "Emetab\ Greenland",
    'gm'  => "Emetab\ Gambia",
    'gn'  => "Emetab\ Guinea",
    'gp'  => "Emetab\ Guadeloupe",
    'gq'  => "Emetab\ Equatorial\ Guinea",
    'gr'  => "Emetab\ Greece",
    'gs'  => "South\ Georgia\ and\ the\ South\ Sandwich\ Islands",
    'gt'  => "Emetab\ Guatemala",
    'gu'  => "Emetab\ Guam",
    'gw'  => "Emetab\ Guinea\-Bissau",
    'gy'  => "Emetab\ Guyana",
    'hk'  => "Hong\ Kong",
    'hm'  => "Heard\ Island\ and\ McDonald\ Islands",
    'hn'  => "Emetab\ Honduras",
    'hr'  => "Emetab\ Croatia",
    'ht'  => "Emetab\ Haiti",
    'hu'  => "Emetab\ Hungary",
    'ic'  => "Canary\ Islands",
    'id'  => "Emetab\ Indonesia",
    'ie'  => "Emetab\ Ireland",
    'il'  => "Emetab\ Israel",
    'im'  => "Isle\ of\ Man",
    'in'  => "Emetab\ India",
    'io'  => "Kebebertab\ araraitab\ indian\ Ocean\ nebo\ Uingeresa",
    'iq'  => "Emetab\ Iraq",
    'ir'  => "Emetab\ Iran",
    'is'  => "Emetab\ Iceland",
    'it'  => "Emetab\ Italy",
    'je'  => 'Jersey',
    'jm'  => "Emetab\ Jamaica",
    'jo'  => "Emetab\ Jordan",
    'jp'  => "Emetab\ Japan",
    'jt'  => "Johnston\ Island",
    'ke'  => "Emetab\ Kenya",
    'kg'  => "Emetab\ Kyrgyzstan",
    'kh'  => "Emetab\ Cambodia",
    'ki'  => "Emetab\ Kiribati",
    'km'  => "Emetab\ Comoros",
    'kn'  => "Emetab\ Saint\ Kitts\ ak\ Nevis",
    'kp'  => "Emetab\ Korea\ nebo\ murot\ katam",
    'kr'  => "Emetab\ korea\ nebo\ murot\ tai",
    'kw'  => "Emetab\ Kuwait",
    'ky'  => "Ikwembeyotab\ Cayman",
    'kz'  => "Emetab\ Kazakhstan",
    'la'  => "Emetab\ Laos",
    'lb'  => "Emetab\ Lebanon",
    'lc'  => "Emetab\ Lucia\ Ne",
    'li'  => "Emetab\ Liechtenstein",
    'lk'  => "Emetab\ Sri\ Lanka",
    'lr'  => "Emetab\ Liberia",
    'ls'  => "Emetab\ Lesotho",
    'lt'  => "Emetab\ Lithuania",
    'lu'  => "Emetab\ Luxembourg",
    'lv'  => "Emetab\ Latvia",
    'ly'  => "Emetab\ Libya",
    'ma'  => "Emetab\ Morocco",
    'mc'  => "Emetab\ Monaco",
    'md'  => "Emetab\ Moldova",
    'me'  => 'Montenegro',
    'mf'  => "Saint\ Martin",
    'mg'  => "Emetab\ Madagascar",
    'mh'  => "Ikwembeiyotab\ Marshall",
    'mi'  => "Midway\ Islands",
    'mk'  => "Emetab\ Macedonia",
    'ml'  => "Emetab\ Mali",
    'mm'  => "Emetab\ Myanmar",
    'mn'  => "Emetab\ Mongolia",
    'mo'  => 'Macau',
    'mp'  => "Ikwembeiyotab\ Mariana\ nebo\ murot\ katam",
    'mq'  => "Emetab\ Martinique",
    'mr'  => "Emetab\ Mauritania",
    'ms'  => "Emetab\ Montserrat",
    'mt'  => "Emetab\ Malta",
    'mu'  => "Emetab\ Mauritius",
    'mv'  => "Emetab\ Maldives",
    'mw'  => "Emetab\ Malawi",
    'mx'  => "Emetab\ Mexico",
    'my'  => "Emetab\ Malaysia",
    'mz'  => "Emetab\ Mozambique",
    'na'  => "Emetab\ Namibia",
    'nc'  => "Emetab\ New\ Caledonia",
    'ne'  => "Emetab\ niger",
    'nf'  => "Ikwembeiyotab\ Norfork",
    'ng'  => "Emetab\ Nigeria",
    'ni'  => "Emetab\ Nicaragua",
    'nl'  => "Emetab\ Holand",
    'no'  => "Emetab\ Norway",
    'np'  => "Emetab\ Nepal",
    'nq'  => "Dronning\ Maud\ Land",
    'nr'  => "Emetab\ Nauru",
    'nt'  => "Neutral\ Zone",
    'nu'  => "Emetab\ Niue",
    'nz'  => "Emetab\ New\ Zealand",
    'om'  => "Emetab\ Oman",
    'pa'  => "Emetab\ Panama",
    'pc'  => "Pacific\ Islands\ Trust\ Territory",
    'pe'  => "Emetab\ Peru",
    'pf'  => "Emetab\ Polynesia\ nebo\ ufaransa",
    'pg'  => "Emetab\ Papua\ New\ Guinea",
    'ph'  => "Emetab\ Philippines",
    'pk'  => "Emetab\ Pakistan",
    'pl'  => "Emetab\ Poland",
    'pm'  => "Emetab\ Peter\ Ne\ titil\ ak\ Miquelon",
    'pn'  => "Emetab\ Pitcairn",
    'pr'  => "Emetab\ Puerto\ Rico",
    'ps'  => "Emetab\ Palestine",
    'pt'  => "Emetab\ Portugal",
    'pu'  => "U\.S\.\ Miscellaneous\ Pacific\ Islands",
    'pw'  => "Emetab\ Palau",
    'py'  => "Emetab\ Paraguay",
    'pz'  => "Panama\ Canal\ Zone",
    'qa'  => "Emetab\ Qatar",
    'qo'  => "Outlying\ Oceania",
    're'  => "Emetab\ Réunion",
    'ro'  => "Emetab\ Romania",
    'rs'  => 'Serbia',
    'ru'  => "Emetab\ Russia",
    'rw'  => "Emetab\ Rwanda",
    'sa'  => "Emetab\ Saudi\ Arabia",
    'sb'  => "Ikwembeiyotab\ Solomon",
    'sc'  => "Emetab\ Seychelles",
    'sd'  => "Emetab\ Sudan",
    'se'  => "Emetab\ Sweden",
    'sg'  => "Emetab\ Singapore",
    'sh'  => "Emetab\ Helena\ Ne\ tilil",
    'si'  => "Emetab\ Slovenia",
    'sj'  => "Svalbard\ and\ Jan\ Mayen",
    'sk'  => "Emetab\ Slovakia",
    'sl'  => "Emetab\ Sierra\ Leone",
    'sm'  => "Emetab\ San\ Marino",
    'sn'  => "Emetab\ Senegal",
    'so'  => "Emetab\ Somalia",
    'sr'  => "Emetab\ Suriname",
    'st'  => "Emetab\ São\ Tomé\ and\ Príncipe",
    'su'  => "Union\ of\ Soviet\ Socialist\ Republics",
    'sv'  => "Emetab\ El\ Salvador",
    'sy'  => "Emetab\ Syria",
    'sz'  => "Emetab\ Swaziland",
    'ta'  => "Tristan\ da\ Cunha",
    'tc'  => "Ikwembeiyotab\ Turks\ ak\ Caicos",
    'td'  => "Emetab\ Chad",
    'tf'  => "French\ Southern\ Territories",
    'tg'  => "Emetab\ Togo",
    'th'  => "Emetab\ Thailand",
    'tj'  => "Emetab\ Tajikistan",
    'tk'  => "Emetab\ Tokelau",
    'tl'  => "Emetab\ Timor\ nebo\ Murot\ tai",
    'tm'  => "Emetab\ Turkmenistan",
    'tn'  => "Emetab\ Tunisia",
    'to'  => "Emetab\ Tonga",
    'tr'  => "Emetab\ Turkey",
    'tt'  => "Emetab\ Trinidad\ ak\ Tobago",
    'tv'  => "Emetab\ Tuvalu",
    'tw'  => "Emetab\ Taiwan",
    'tz'  => "Emetab\ Tanzania",
    'ua'  => "Emetab\ Ukrainie",
    'ug'  => "Emetab\ Uganda",
    'um'  => "U\.S\.\ Minor\ Outlying\ Islands",
    'us'  => "Emetab\ amerika",
    'uy'  => "Emetab\ Uruguay",
    'uz'  => "Emetab\ Uzibekistani",
    'va'  => "Emetab\ Vatican",
    'vc'  => "Emetab\ Vincent\ netilil\ ak\ Grenadines",
    'vd'  => "North\ Vietnam",
    've'  => "Emetab\ Venezuela",
    'vg'  => "Ikwembeyotab\ British\ Virgin",
    'vi'  => "Ikwemweiyotab\ Amerika",
    'vn'  => "Emetab\ Vietnam",
    'vu'  => "Emetab\ Vanuatu",
    'wf'  => "Emetab\ Walis\ ak\ Futuna",
    'wk'  => "Wake\ Island",
    'ws'  => "Emetab\ Samoa",
    'yd'  => "People\â\\s\ Democratic\ Republic\ of\ Yemen",
    'ye'  => "Emetab\ Yemen",
    'yt'  => "Emetab\ Mayotte",
    'za'  => "Emetab\ Afrika\ nebo\ Murot\ tai",
    'zm'  => "Emetab\ Zambia",
    'zw'  => "Emetab\ Zimbabwe",
    'zz'  => "Unknown\ Region",
);

%Locales::DB::Territory::kln::name_to_code = (
    'africa'                                      => '002',
    'americas'                                    => '019',
    'antarctica'                                  => 'aq',
    'ascensionisland'                             => 'ac',
    'asia'                                        => 142,
    'australiaandnewzealand'                      => '053',
    'bouvetisland'                                => 'bv',
    'britishantarcticterritory'                   => 'bq',
    'canaryislands'                               => 'ic',
    'cantonandenderburyislands'                   => 'ct',
    'caribbean'                                   => '029',
    'centralamerica'                              => '013',
    'centralasia'                                 => 143,
    'ceutaandmelilla'                             => 'ea',
    'channelislands'                              => 830,
    'christmasisland'                             => 'cx',
    'clippertonisland'                            => 'cp',
    'cocoskeelingislands'                         => 'cc',
    'commonwealthofindependentstates'             => 172,
    'czechoslovakia'                              => 200,
    'diegogarcia'                                 => 'dg',
    'dronningmaudland'                            => 'nq',
    'easternafrica'                               => '014',
    'easternasia'                                 => '030',
    'easterneurope'                               => 151,
    'eastgermany'                                 => 'dd',
    'emetabafghanistan'                           => 'af',
    'emetabafrikanebokwen'                        => 'cf',
    'emetabafrikanebomurottai'                    => 'za',
    'emetabalbania'                               => 'al',
    'emetabalgeria'                               => 'dz',
    'emetabamericansamoa'                         => 'as',
    'emetabamerika'                               => 'us',
    'emetabandorra'                               => 'ad',
    'emetabangola'                                => 'ao',
    'emetabanguilla'                              => 'ai',
    'emetabantiguaakbarbuda'                      => 'ag',
    'emetabantileneboholand'                      => 'an',
    'emetabargentina'                             => 'ar',
    'emetabarmenia'                               => 'am',
    'emetabaruba'                                 => 'aw',
    'emetabaustralia'                             => 'au',
    'emetabaustria'                               => 'at',
    'emetabazerbaijan'                            => 'az',
    'emetabbahamas'                               => 'bs',
    'emetabbahrain'                               => 'bh',
    'emetabbangladesh'                            => 'bd',
    'emetabbarbados'                              => 'bb',
    'emetabbelarus'                               => 'by',
    'emetabbelgium'                               => 'be',
    'emetabbelize'                                => 'bz',
    'emetabbenin'                                 => 'bj',
    'emetabbermuda'                               => 'bm',
    'emetabbhutan'                                => 'bt',
    'emetabbolivia'                               => 'bo',
    'emetabbosniaakherzegovina'                   => 'ba',
    'emetabbotswana'                              => 'bw',
    'emetabbrazil'                                => 'br',
    'emetabbrunei'                                => 'bn',
    'emetabbulgaria'                              => 'bg',
    'emetabburkinafaso'                           => 'bf',
    'emetabburundi'                               => 'bi',
    'emetabcambodia'                              => 'kh',
    'emetabcameroon'                              => 'cm',
    'emetabcanada'                                => 'ca',
    'emetabchad'                                  => 'td',
    'emetabchile'                                 => 'cl',
    'emetabchina'                                 => 'cn',
    'emetabcolombia'                              => 'co',
    'emetabcomoros'                               => 'km',
    'emetabcongobrazzaville'                      => 'cg',
    'emetabcongokinshasa'                         => 'cd',
    'emetabcostarica'                             => 'cr',
    'emetabcroatia'                               => 'hr',
    'emetabcuba'                                  => 'cu',
    'emetabcyprus'                                => 'cy',
    'emetabczechrepublic'                         => 'cz',
    'emetabcôtedivoire'                          => 'ci',
    'emetabdenmark'                               => 'dk',
    'emetabdjibouti'                              => 'dj',
    'emetabdominica'                              => 'dm',
    'emetabdominicanrepublic'                     => 'do',
    'emetabecuador'                               => 'ec',
    'emetabelsalvador'                            => 'sv',
    'emetabequatorialguinea'                      => 'gq',
    'emetaberitrea'                               => 'er',
    'emetabestonia'                               => 'ee',
    'emetabethiopia'                              => 'et',
    'emetabfiji'                                  => 'fj',
    'emetabfinland'                               => 'fi',
    'emetabfrance'                                => 'fr',
    'emetabgabon'                                 => 'ga',
    'emetabgambia'                                => 'gm',
    'emetabgeorgia'                               => 'ge',
    'emetabgeruman'                               => 'de',
    'emetabghana'                                 => 'gh',
    'emetabgibraltar'                             => 'gi',
    'emetabgreece'                                => 'gr',
    'emetabgreenland'                             => 'gl',
    'emetabgrenada'                               => 'gd',
    'emetabguadeloupe'                            => 'gp',
    'emetabguam'                                  => 'gu',
    'emetabguatemala'                             => 'gt',
    'emetabguiananeboufaransa'                    => 'gf',
    'emetabguinea'                                => 'gn',
    'emetabguineabissau'                          => 'gw',
    'emetabguyana'                                => 'gy',
    'emetabhaiti'                                 => 'ht',
    'emetabhelenanetilil'                         => 'sh',
    'emetabholand'                                => 'nl',
    'emetabhonduras'                              => 'hn',
    'emetabhungary'                               => 'hu',
    'emetabiceland'                               => 'is',
    'emetabindia'                                 => 'in',
    'emetabindonesia'                             => 'id',
    'emetabiran'                                  => 'ir',
    'emetabiraq'                                  => 'iq',
    'emetabireland'                               => 'ie',
    'emetabisrael'                                => 'il',
    'emetabitaly'                                 => 'it',
    'emetabjamaica'                               => 'jm',
    'emetabjapan'                                 => 'jp',
    'emetabjordan'                                => 'jo',
    'emetabkazakhstan'                            => 'kz',
    'emetabkenya'                                 => 'ke',
    'emetabkibagengeneboarabuk'                   => 'ae',
    'emetabkibagengenebouingereza'                => 'gb',
    'emetabkiribati'                              => 'ki',
    'emetabkoreanebomurotkatam'                   => 'kp',
    'emetabkoreanebomurottai'                     => 'kr',
    'emetabkuwait'                                => 'kw',
    'emetabkyrgyzstan'                            => 'kg',
    'emetablaos'                                  => 'la',
    'emetablatvia'                                => 'lv',
    'emetablebanon'                               => 'lb',
    'emetablesotho'                               => 'ls',
    'emetabliberia'                               => 'lr',
    'emetablibya'                                 => 'ly',
    'emetabliechtenstein'                         => 'li',
    'emetablithuania'                             => 'lt',
    'emetabluciane'                               => 'lc',
    'emetabluxembourg'                            => 'lu',
    'emetabmacedonia'                             => 'mk',
    'emetabmadagascar'                            => 'mg',
    'emetabmalawi'                                => 'mw',
    'emetabmalaysia'                              => 'my',
    'emetabmaldives'                              => 'mv',
    'emetabmali'                                  => 'ml',
    'emetabmalta'                                 => 'mt',
    'emetabmartinique'                            => 'mq',
    'emetabmauritania'                            => 'mr',
    'emetabmauritius'                             => 'mu',
    'emetabmayotte'                               => 'yt',
    'emetabmexico'                                => 'mx',
    'emetabmicronesia'                            => 'fm',
    'emetabmisiri'                                => 'eg',
    'emetabmoldova'                               => 'md',
    'emetabmonaco'                                => 'mc',
    'emetabmongolia'                              => 'mn',
    'emetabmontserrat'                            => 'ms',
    'emetabmorocco'                               => 'ma',
    'emetabmozambique'                            => 'mz',
    'emetabmyanmar'                               => 'mm',
    'emetabnamibia'                               => 'na',
    'emetabnauru'                                 => 'nr',
    'emetabnepal'                                 => 'np',
    'emetabnewcaledonia'                          => 'nc',
    'emetabnewzealand'                            => 'nz',
    'emetabnicaragua'                             => 'ni',
    'emetabniger'                                 => 'ne',
    'emetabnigeria'                               => 'ng',
    'emetabniue'                                  => 'nu',
    'emetabnorway'                                => 'no',
    'emetaboman'                                  => 'om',
    'emetabpakistan'                              => 'pk',
    'emetabpalau'                                 => 'pw',
    'emetabpalestine'                             => 'ps',
    'emetabpanama'                                => 'pa',
    'emetabpapuanewguinea'                        => 'pg',
    'emetabparaguay'                              => 'py',
    'emetabperu'                                  => 'pe',
    'emetabpeternetitilakmiquelon'                => 'pm',
    'emetabphilippines'                           => 'ph',
    'emetabpitcairn'                              => 'pn',
    'emetabpoland'                                => 'pl',
    'emetabpolynesianeboufaransa'                 => 'pf',
    'emetabportugal'                              => 'pt',
    'emetabpuertorico'                            => 'pr',
    'emetabqatar'                                 => 'qa',
    'emetabromania'                               => 'ro',
    'emetabrussia'                                => 'ru',
    'emetabrwanda'                                => 'rw',
    'emetabréunion'                              => 're',
    'emetabsaintkittsaknevis'                     => 'kn',
    'emetabsamoa'                                 => 'ws',
    'emetabsanmarino'                             => 'sm',
    'emetabsaudiarabia'                           => 'sa',
    'emetabsenegal'                               => 'sn',
    'emetabserbiaandmontenegro'                   => 'cs',
    'emetabseychelles'                            => 'sc',
    'emetabsierraleone'                           => 'sl',
    'emetabsingapore'                             => 'sg',
    'emetabslovakia'                              => 'sk',
    'emetabslovenia'                              => 'si',
    'emetabsomalia'                               => 'so',
    'emetabspain'                                 => 'es',
    'emetabsrilanka'                              => 'lk',
    'emetabsudan'                                 => 'sd',
    'emetabsuriname'                              => 'sr',
    'emetabswaziland'                             => 'sz',
    'emetabsweden'                                => 'se',
    'emetabswitzerland'                           => 'ch',
    'emetabsyria'                                 => 'sy',
    'emetabsãotoméandpríncipe'                 => 'st',
    'emetabtaiwan'                                => 'tw',
    'emetabtajikistan'                            => 'tj',
    'emetabtanzania'                              => 'tz',
    'emetabthailand'                              => 'th',
    'emetabtimornebomurottai'                     => 'tl',
    'emetabtogo'                                  => 'tg',
    'emetabtokelau'                               => 'tk',
    'emetabtonga'                                 => 'to',
    'emetabtrinidadaktobago'                      => 'tt',
    'emetabtunisia'                               => 'tn',
    'emetabturkey'                                => 'tr',
    'emetabturkmenistan'                          => 'tm',
    'emetabtuvalu'                                => 'tv',
    'emetabuganda'                                => 'ug',
    'emetabukrainie'                              => 'ua',
    'emetaburuguay'                               => 'uy',
    'emetabuzibekistani'                          => 'uz',
    'emetabvanuatu'                               => 'vu',
    'emetabvatican'                               => 'va',
    'emetabvenezuela'                             => 've',
    'emetabvietnam'                               => 'vn',
    'emetabvincentnetililakgrenadines'            => 'vc',
    'emetabwalisakfutuna'                         => 'wf',
    'emetabyemen'                                 => 'ye',
    'emetabzambia'                                => 'zm',
    'emetabzimbabwe'                              => 'zw',
    'europe'                                      => 150,
    'europeanunion'                               => 'eu',
    'faroeislands'                                => 'fo',
    'frenchsouthernandantarcticterritories'       => 'fq',
    'frenchsouthernterritories'                   => 'tf',
    'guernsey'                                    => 'gg',
    'heardislandandmcdonaldislands'               => 'hm',
    'hongkong'                                    => 'hk',
    'ikwembeiyotabmariananebomurotkatam'          => 'mp',
    'ikwembeiyotabmarshall'                       => 'mh',
    'ikwembeiyotabnorfork'                        => 'nf',
    'ikwembeiyotabsolomon'                        => 'sb',
    'ikwembeiyotabturksakcaicos'                  => 'tc',
    'ikwembeyotabbritishvirgin'                   => 'vg',
    'ikwembeyotabcapeverde'                       => 'cv',
    'ikwembeyotabcayman'                          => 'ky',
    'ikwembeyotabcook'                            => 'ck',
    'ikwembeyotabfalkland'                        => 'fk',
    'ikwemweiyotabamerika'                        => 'vi',
    'isleofman'                                   => 'im',
    'jersey'                                      => 'je',
    'johnstonisland'                              => 'jt',
    'kebebertabararaitabindianoceannebouingeresa' => 'io',
    'latinamerica'                                => 419,
    'macau'                                       => 'mo',
    'melanesia'                                   => '054',
    'metropolitanfrance'                          => 'fx',
    'micronesianregion'                           => '057',
    'middleafrica'                                => '017',
    'midwayislands'                               => 'mi',
    'montenegro'                                  => 'me',
    'neutralzone'                                 => 'nt',
    'northamerica'                                => '003',
    'northernafrica'                              => '015',
    'northernamerica'                             => '021',
    'northerneurope'                              => 154,
    'northvietnam'                                => 'vd',
    'oceania'                                     => '009',
    'outlyingoceania'                             => 'qo',
    'pacificislandstrustterritory'                => 'pc',
    'panamacanalzone'                             => 'pz',
    "people\â\\sdemocraticrepublicofyemen"   => 'yd',
    'polynesia'                                   => '061',
    "saintbarth\Ã\©lemy"                        => 'bl',
    'saintmartin'                                 => 'mf',
    'serbia'                                      => 'rs',
    'southamerica'                                => '005',
    'southcentralasia'                            => '062',
    'southeasternasia'                            => '035',
    'southernafrica'                              => '018',
    'southernasia'                                => '034',
    'southerneurope'                              => '039',
    'southgeorgiaandthesouthsandwichislands'      => 'gs',
    'svalbardandjanmayen'                         => 'sj',
    'tristandacunha'                              => 'ta',
    "u\.s\.minoroutlyingislands"                  => 'um',
    "u\.s\.miscellaneouspacificislands"           => 'pu',
    'unionofsovietsocialistrepublics'             => 'su',
    'unknownregion'                               => 'zz',
    'wakeisland'                                  => 'wk',
    'westernafrica'                               => '011',
    'westernasia'                                 => 145,
    'westerneurope'                               => 155,
    'westernsahara'                               => 'eh',
    'world'                                       => '001',
    "\Ã\landislands"                           => 'ax',
);

1;

