#!/usr/bin/perl
#-------------------------------------------------------------------------------
# Translate the numbers from 0 to 100 into various languages
# Philip R Brenan at gmail dot com, Appa Apps Ltd, 2017
#-------------------------------------------------------------------------------

package Text::Numbers::100;
require v5.16.0;
use warnings FATAL => qw(all);
use strict;
use Carp;
use utf8;

our $VERSION = '20171123';

#-------------------------------------------------------------------------------
# Translate
#-------------------------------------------------------------------------------

sub translate($$)
 {my ($language, $number) = @_;
  my $l = &translations;
  my $n = $l->{$language};
  $n or confess "No translation for language: $language";
  my $i = $number+0;
  $n->{$i}
 }

#-------------------------------------------------------------------------------
# Languages
#-------------------------------------------------------------------------------

sub languages
 {my $l = &translations;
  sort keys %{&translations};
 }

#-------------------------------------------------------------------------------
# Numbers
#-------------------------------------------------------------------------------

sub translations{
 {cy => { "0"   => "dim",
          "1"   => "un",
          "2"   => "dau",
          "3"   => "tri",
          "4"   => "pedwar",
          "5"   => "pump",
          "6"   => "chwech",
          "7"   => "saith",
          "8"   => "wyth",
          "9"   => "naw",
          "10"  => "deg",
          "11"  => "un deg un",
          "12"  => "un deg dau",
          "13"  => "un deg tri",
          "14"  => "un deg pedwar",
          "15"  => "un deg pump",
          "16"  => "un deg chwech",
          "17"  => "un deg saith",
          "18"  => "un deg wyth",
          "19"  => "un deg naw",
          "20"  => "dau ddeg",
          "21"  => "dau ddeg un",
          "22"  => "dau ddeg dau",
          "23"  => "dau ddeg tri",
          "24"  => "dau ddeg pedwar",
          "25"  => "dau ddeg pump",
          "26"  => "dau ddeg chwech",
          "27"  => "dau ddeg saith",
          "28"  => "dau ddeg wyth",
          "29"  => "dau ddeg naw",
          "30"  => "tri deg",
          "31"  => "tri deg un",
          "32"  => "tri deg dau",
          "33"  => "tri deg tri",
          "34"  => "tri deg pedwar",
          "35"  => "tri deg pump",
          "36"  => "tri deg chwech",
          "37"  => "tri deg saith",
          "38"  => "tri deg wyth",
          "39"  => "tri deg naw",
          "40"  => "pedwar deg",
          "41"  => "pedwar deg un",
          "42"  => "pedwar deg dau",
          "43"  => "pedwar deg tri",
          "44"  => "pedwar deg pedwar",
          "45"  => "pedwar deg pump",
          "46"  => "pedwar deg chwech",
          "47"  => "pedwar deg saith",
          "48"  => "pedwar deg wyth",
          "49"  => "pedwar deg naw",
          "50"  => "pum deg",
          "51"  => "pum deg un",
          "52"  => "pum deg dau",
          "53"  => "pum deg tri",
          "54"  => "pum deg pedwar",
          "55"  => "pum deg pump",
          "56"  => "pum deg chwech",
          "57"  => "pum deg saith",
          "58"  => "pum deg wyth",
          "59"  => "pum deg naw",
          "60"  => "chwe deg",
          "61"  => "chwe deg un",
          "62"  => "chwe deg dau",
          "63"  => "chwe deg tri",
          "64"  => "chwe deg pedwar",
          "65"  => "chwe deg pump",
          "66"  => "chwe deg chwech",
          "67"  => "chwe deg saith",
          "68"  => "chwe deg wyth",
          "69"  => "chwe deg naw",
          "70"  => "saith deg",
          "71"  => "saith deg un",
          "72"  => "saith deg dau",
          "73"  => "saith deg tri",
          "74"  => "saith deg pedwar",
          "75"  => "saith deg pump",
          "76"  => "saith deg chwech",
          "77"  => "saith deg saith",
          "78"  => "saith deg wyth",
          "79"  => "saith deg naw",
          "80"  => "wyth deg",
          "81"  => "wyth deg un",
          "82"  => "wyth deg dau",
          "83"  => "wyth deg tri",
          "84"  => "wyth deg pedwar",
          "85"  => "wyth deg pump",
          "86"  => "wyth deg chwech",
          "87"  => "wyth deg saith",
          "88"  => "wyth deg wyth",
          "89"  => "wyth deg naw",
          "90"  => "naw deg",
          "91"  => "naw deg un",
          "92"  => "naw deg dau",
          "93"  => "naw deg tri",
          "94"  => "naw deg pedwar",
          "95"  => "naw deg pump",
          "96"  => "naw deg chwech",
          "97"  => "naw deg saith",
          "98"  => "naw deg wyth",
          "99"  => "naw deg naw",
          "100" => "cant",
        },
  da => {
          "0"   => "nul",
          "1"   => "en",
          "2"   => "to",
          "3"   => "tre",
          "4"   => "fire",
          "5"   => "fem",
          "6"   => "seks",
          "7"   => "syv",
          "8"   => "otte",
          "9"   => "ni",
          "10"  => "ti",
          "11"  => "elleve",
          "12"  => "tolv",
          "13"  => "tretten",
          "14"  => "fjorten",
          "15"  => "femten",
          "16"  => "seksten",
          "17"  => "sytten",
          "18"  => "atten",
          "19"  => "nitten",
          "20"  => "tyve",
          "21"  => "énogtyve",
          "22"  => "toogtyve",
          "23"  => "treogtyve",
          "24"  => "fireogtyve",
          "25"  => "femogtyve",
          "26"  => "seksogtyve",
          "27"  => "syvogtyve",
          "28"  => "otteogtyve",
          "29"  => "niogtyve",
          "30"  => "tredive",
          "31"  => "énogtredive",
          "32"  => "toogtredive",
          "33"  => "treogtredive",
          "34"  => "fireogtredive",
          "35"  => "femogtredive",
          "36"  => "seksogtredive",
          "37"  => "syvogtredive",
          "38"  => "otteogtredive",
          "39"  => "niogtredive",
          "40"  => "fyrre",
          "41"  => "énogfyrre",
          "42"  => "toogfyrre",
          "43"  => "treogfyrre",
          "44"  => "fireogfyrre",
          "45"  => "femogfyrre",
          "46"  => "seksogfyrre",
          "47"  => "syvogfyrre",
          "48"  => "otteogfyrre",
          "49"  => "niogfyrre",
          "50"  => "halvtreds",
          "51"  => "énoghalvtreds",
          "52"  => "tooghalvtreds",
          "53"  => "treoghalvtreds",
          "54"  => "fireoghalvtreds",
          "55"  => "femoghalvtreds",
          "56"  => "seksoghalvtreds",
          "57"  => "syvoghalvtreds",
          "58"  => "otteoghalvtreds",
          "59"  => "nioghalvtreds",
          "60"  => "tres",
          "61"  => "énogtres",
          "62"  => "toogtres",
          "63"  => "treogtres",
          "64"  => "fireogtres",
          "65"  => "femogtres",
          "66"  => "seksogtres",
          "67"  => "syvogtres",
          "68"  => "otteogtres",
          "69"  => "niogtres",
          "70"  => "halvfjerds",
          "71"  => "énoghalvfjerds",
          "72"  => "tooghalvfjerds",
          "73"  => "treoghalvfjerds",
          "74"  => "fireoghalvfjerds",
          "75"  => "femoghalvfjerds",
          "76"  => "seksoghalvfjerds",
          "77"  => "syvoghalvfjerds",
          "78"  => "otteoghalvfjerds",
          "79"  => "nioghalvfjerds",
          "80"  => "firs",
          "81"  => "énogfirs",
          "82"  => "toogfirs",
          "83"  => "treogfirs",
          "84"  => "fireogfirs",
          "85"  => "femogfirs",
          "86"  => "seksogfirs",
          "87"  => "syvogfirs",
          "88"  => "otteogfirs",
          "89"  => "niogfirs",
          "90"  => "halvfems",
          "91"  => "énoghalvfems",
          "92"  => "tooghalvfems",
          "93"  => "treoghalvfems",
          "94"  => "fireoghalvfems",
          "95"  => "femoghalvfems",
          "96"  => "seksoghalvfems",
          "97"  => "syvoghalvfems",
          "98"  => "otteoghalvfems",
          "99"  => "nioghalvfems",
          "100" => "hundrede",
        },
  en => {
          "0"   => "zero",
          "1"   => "one",
          "2"   => "two",
          "3"   => "three",
          "4"   => "four",
          "5"   => "five",
          "6"   => "six",
          "7"   => "seven",
          "8"   => "eight",
          "9"   => "nine",
          "10"  => "ten",
          "11"  => "eleven",
          "12"  => "twelve",
          "13"  => "thirteen",
          "14"  => "fourteen",
          "15"  => "fifteen",
          "16"  => "sixteen",
          "17"  => "seventeen",
          "18"  => "eighteen",
          "19"  => "nineteen",
          "20"  => "twenty",
          "21"  => "twenty-one",
          "22"  => "twenty-two",
          "23"  => "twenty-three",
          "24"  => "twenty-four",
          "25"  => "twenty-five",
          "26"  => "twenty-six",
          "27"  => "twenty-seven",
          "28"  => "twenty-eight",
          "29"  => "twenty-nine",
          "30"  => "thirty",
          "31"  => "thirty-one",
          "32"  => "thirty-two",
          "33"  => "thirty-three",
          "34"  => "thirty-four",
          "35"  => "thirty-five",
          "36"  => "thirty-six",
          "37"  => "thirty-seven",
          "38"  => "thirty-eight",
          "39"  => "thirty-nine",
          "40"  => "forty",
          "41"  => "forty-one",
          "42"  => "forty-two",
          "43"  => "forty-three",
          "44"  => "forty-four",
          "45"  => "forty-five",
          "46"  => "forty-six",
          "47"  => "forty-seven",
          "48"  => "forty-eight",
          "49"  => "forty-nine",
          "50"  => "fifty",
          "51"  => "fifty-one",
          "52"  => "fifty-two",
          "53"  => "fifty-three",
          "54"  => "fifty-four",
          "55"  => "fifty-five",
          "56"  => "fifty-six",
          "57"  => "fifty-seven",
          "58"  => "fifty-eight",
          "59"  => "fifty-nine",
          "60"  => "sixty",
          "61"  => "sixty-one",
          "62"  => "sixty-two",
          "63"  => "sixty-three",
          "64"  => "sixty-four",
          "65"  => "sixty-five",
          "66"  => "sixty-six",
          "67"  => "sixty-seven",
          "68"  => "sixty-eight",
          "69"  => "sixty-nine",
          "70"  => "seventy",
          "71"  => "seventy-one",
          "72"  => "seventy-two",
          "73"  => "seventy-three",
          "74"  => "seventy-four",
          "75"  => "seventy-five",
          "76"  => "seventy-six",
          "77"  => "seventy-seven",
          "78"  => "seventy-eight",
          "79"  => "seventy-nine",
          "80"  => "eighty",
          "81"  => "eighty-one",
          "82"  => "eighty-two",
          "83"  => "eighty-three",
          "84"  => "eighty-four",
          "85"  => "eighty-five",
          "86"  => "eighty-six",
          "87"  => "eighty-seven",
          "88"  => "eighty-eight",
          "89"  => "eighty-nine",
          "90"  => "ninety",
          "91"  => "ninety-one",
          "92"  => "ninety-two",
          "93"  => "ninety-three",
          "94"  => "ninety-four",
          "95"  => "ninety-five",
          "96"  => "ninety-six",
          "97"  => "ninety-seven",
          "98"  => "ninety-eight",
          "99"  => "ninety-nine",
          "100" => "one hundred",
        },
  es => {
          "0"   => "cero",
          "1"   => "uno",
          "2"   => "dos",
          "3"   => "tres",
          "4"   => "cuatro",
          "5"   => "cinco",
          "6"   => "seis",
          "7"   => "siete",
          "8"   => "ocho",
          "9"   => "nueve",
          "10"  => "diez",
          "11"  => "once",
          "12"  => "doce",
          "13"  => "trece",
          "14"  => "catorce",
          "15"  => "quince",
          "16"  => "dieciséis",
          "17"  => "diecisiete",
          "18"  => "dieciocho",
          "19"  => "diecinueve",
          "20"  => "veinte",
          "21"  => "veintiuno",
          "22"  => "veintidós",
          "23"  => "veintitrés",
          "24"  => "veinticuatro",
          "25"  => "veinticinco",
          "26"  => "veintiséis",
          "27"  => "veintisiete",
          "28"  => "veintiocho",
          "29"  => "veintinueve",
          "30"  => "treinta",
          "31"  => "treintay uno",
          "32"  => "treintay dos",
          "33"  => "treintay tres",
          "34"  => "treintay cuatro",
          "35"  => "treintay cinco",
          "36"  => "treintay seis",
          "37"  => "treintay siete",
          "38"  => "treintay ocho",
          "39"  => "treintay nueve",
          "40"  => "cuarenta",
          "41"  => "cuarentay uno",
          "42"  => "cuarentay dos",
          "43"  => "cuarentay tres",
          "44"  => "cuarentay cuatro",
          "45"  => "cuarentay cinco",
          "46"  => "cuarentay seis",
          "47"  => "cuarentay siete",
          "48"  => "cuarentay ocho",
          "49"  => "cuarentay nueve",
          "50"  => "cincuenta",
          "51"  => "cincuentay uno",
          "52"  => "cincuentay dos",
          "53"  => "cincuentay tres",
          "54"  => "cincuentay cuatro",
          "55"  => "cincuentay cinco",
          "56"  => "cincuentay seis",
          "57"  => "cincuentay siete",
          "58"  => "cincuentay ocho",
          "59"  => "cincuentay nueve",
          "60"  => "sesenta",
          "61"  => "sesentay uno",
          "62"  => "sesentay dos",
          "63"  => "sesentay tres",
          "64"  => "sesentay cuatro",
          "65"  => "sesentay cinco",
          "66"  => "sesentay seis",
          "67"  => "sesentay siete",
          "68"  => "sesentay ocho",
          "69"  => "sesentay nueve",
          "70"  => "setenta",
          "71"  => "setentay uno",
          "72"  => "setentay dos",
          "73"  => "setentay tres",
          "74"  => "setentay cuatro",
          "75"  => "setentay cinco",
          "76"  => "setentay seis",
          "77"  => "setentay siete",
          "78"  => "setentay ocho",
          "79"  => "setentay nueve",
          "80"  => "ochenta",
          "81"  => "ochentay uno",
          "82"  => "ochentay dos",
          "83"  => "ochentay tres",
          "84"  => "ochentay cuatro",
          "85"  => "ochentay cinco",
          "86"  => "ochentay seis",
          "87"  => "ochentay siete",
          "88"  => "ochentay ocho",
          "89"  => "ochentay nueve",
          "90"  => "noventa",
          "91"  => "noventay uno",
          "92"  => "noventay dos",
          "93"  => "noventay tres",
          "94"  => "noventay cuatro",
          "95"  => "noventay cinco",
          "96"  => "noventay seis",
          "97"  => "noventay siete",
          "98"  => "noventay ocho",
          "99"  => "noventay nueve",
          "100" => "cien",
        },
  is => {
          "0" => "núll",
          "1" => "einn",
          "2" => "tveir",
          "3" => "þrír",
          "4" => "fjórir",
          "5" => "fimm",
          "6" => "sex",
          "7" => "sjö",
          "8" => "átta",
          "9" => "níu",
          "10" => "tíu",
          "11" => "ellefu",
          "12" => "tólf",
          "13" => "þrettán",
          "14" => "fjórtán",
          "15" => "fimmtán",
          "16" => "sextán",
          "17" => "sautján",
          "18" => "átján",
          "19" => "nítján",
          "20" => "tuttugu",
          "21" => "tuttugu og einn",
          "22" => "tuttugu og tveir",
          "23" => "tuttugu og þrír",
          "24" => "tuttugu og fjögur",
          "25" => "tuttugu og fimm",
          "26" => "tuttugu og sex",
          "27" => "tuttugu og sjö",
          "28" => "tuttugu og átta",
          "29" => "tuttugu og níu",
          "30" => "þrjátíu",
          "31" => "þrjátíu og einn",
          "32" => "Þrjátíu og tveir",
          "33" => "þrjátíu og þrír",
          "34" => "þrjátíu og fjögur",
          "35" => "þrjátíu og fimm",
          "36" => "þrjátíu og sex",
          "37" => "þrjátíu og sjö",
          "38" => "þrjátíu og átta",
          "39" => "þrjátíu og níu",
          "40" => "fjörutíu",
          "41" => "fjörutíu og einn",
          "42" => "Fjörutíu og tveir",
          "43" => "fjörutíu og þrír",
          "44" => "fjörutíu og fjögur",
          "45" => "fjörutíu og fimm",
          "46" => "Fjörutíu og sex",
          "47" => "fjörutíu og sjö",
          "48" => "fjörutíu og átta",
          "49" => "fjörutíu og níu",
          "50" => "fimmtíu",
          "51" => "fimmtíu og einn",
          "52" => "fimmtíu og tveir",
          "53" => "fimmtíu og þrír",
          "54" => "fimmtíu og fjögur",
          "55" => "fimmtíu og fimm",
          "56" => "fimmtíu og sex",
          "57" => "fimmtíu og sjö",
          "58" => "fimmtíu og átta",
          "59" => "fimmtíu og níu",
          "60" => "sextíu",
          "61" => "sextíu og einn",
          "62" => "sextíu og tveir",
          "63" => "sextíu og þrír",
          "64" => "sextíu og fjögur",
          "65" => "sextíu og fimm",
          "66" => "sextíu og sex",
          "67" => "Sextíu og sjö",
          "68" => "sextíu og átta",
          "69" => "sextíu og níu",
          "70" => "sjötíu",
          "71" => "sjötíu og einn",
          "72" => "sjötíu og tveir",
          "73" => "sjötíu og þrír",
          "74" => "sjötíu og fjögur",
          "75" => "sjötíu og fimm",
          "76" => "sjötíu og sex",
          "77" => "sjötíu og sjö",
          "78" => "sjötíu og átta",
          "79" => "sjötíu og níu",
          "80" => "áttatíu",
          "81" => "áttatíu og einn",
          "82" => "attatíu og tveir",
          "83" => "áttatíu og þrír",
          "84" => "áttatíu og fjögur",
          "85" => "áttatíu og fimm",
          "86" => "áttatíu og sex",
          "87" => "áttatíu og sjö",
          "88" => "áttatíu og átta",
          "89" => "attatíu og níu",
          "90" => "níutíu",
          "91" => "níutíu og einn",
          "92" => "níutíu og tveir",
          "93" => "níutíu og þrír",
          "94" => "níutíu og fjögur",
          "95" => "níutíu og fimm",
          "96" => "níutíu og sex",
          "97" => "Níutíu og sjö",
          "98" => "níutíu og átta",
          "99" => "níutíu og níu",
          "100" => "hundrað",        },
  it => {
          "0"   => "zero",
          "1"   => "uno",
          "2"   => "due",
          "3"   => "tre",
          "4"   => "quattro",
          "5"   => "cinque",
          "6"   => "sei",
          "7"   => "sette",
          "8"   => "otto",
          "9"   => "nove",
          "10"  => "dieci",
          "11"  => "undici",
          "12"  => "dodici",
          "13"  => "tredici",
          "14"  => "quattordici",
          "15"  => "quindici",
          "16"  => "sedici",
          "17"  => "diciassette",
          "18"  => "diciotto",
          "19"  => "diciannove",
          "20"  => "venti",
          "21"  => "ventuno",
          "22"  => "ventidue",
          "23"  => "ventitre",
          "24"  => "ventiquattro",
          "25"  => "venticinque",
          "26"  => "ventisei",
          "27"  => "ventisette",
          "28"  => "ventotto",
          "29"  => "ventinove",
          "30"  => "trenta",
          "31"  => "trentuno",
          "32"  => "trentadue",
          "33"  => "trentatre",
          "34"  => "trentaquattro",
          "35"  => "trentacinque",
          "36"  => "trentasei",
          "37"  => "trentasette",
          "38"  => "trentotto",
          "39"  => "trentanove",
          "40"  => "quaranta",
          "41"  => "quarantuno",
          "42"  => "quarantadue",
          "43"  => "quarantatre",
          "44"  => "quarantaquattro",
          "45"  => "quarantacinque",
          "46"  => "quarantasei",
          "47"  => "quarantasette",
          "48"  => "quarantotto",
          "49"  => "quarantanove",
          "50"  => "cinquanta",
          "51"  => "cinquantuno",
          "52"  => "cinquantadue",
          "53"  => "cinquantatre",
          "54"  => "cinquantaquattro",
          "55"  => "cinquantacinque",
          "56"  => "cinquantasei",
          "57"  => "cinquantasette",
          "58"  => "cinquantotto",
          "59"  => "cinquantanove",
          "60"  => "sessanta",
          "61"  => "sessantuno",
          "62"  => "sessantadue",
          "63"  => "sessantatre",
          "64"  => "sessantaquattro",
          "65"  => "sessantacinque",
          "66"  => "sessantasei",
          "67"  => "sessantasette",
          "68"  => "sessantotto",
          "69"  => "sessantanove",
          "70"  => "settanta",
          "71"  => "settantuno",
          "72"  => "settantadue",
          "73"  => "settantatre",
          "74"  => "settantaquattro",
          "75"  => "settantacinque",
          "76"  => "settantasei",
          "77"  => "settantasette",
          "78"  => "settantotto",
          "79"  => "settantanove",
          "80"  => "ottanta",
          "81"  => "ottantuno",
          "82"  => "ottantadue",
          "83"  => "ottantatre",
          "84"  => "ottantaquattro",
          "85"  => "ottantacinque",
          "86"  => "ottantasei",
          "87"  => "ottantasette",
          "88"  => "ottantotto",
          "89"  => "ottantanove",
          "90"  => "novanta",
          "91"  => "novantuno",
          "92"  => "novantadue",
          "93"  => "novantatre",
          "94"  => "novantaquattro",
          "95"  => "novantacinque",
          "96"  => "novantasei",
          "97"  => "novantasette",
          "98"  => "novantotto",
          "99"  => "novantanove",
          "100" => "cento",
        },
  ja => {
          "0"   => "rei",
          "1"   => "ichi",
          "2"   => "ni",
          "3"   => "san",
          "4"   => "yon",
          "5"   => "go",
          "6"   => "roku",
          "7"   => "nana",
          "8"   => "hachi",
          "9"   => "kyuu",
          "10"  => "juu",
          "11"  => "juuichi",
          "12"  => "juuni",
          "13"  => "juusan",
          "14"  => "juushi",
          "15"  => "juugo",
          "16"  => "juuroku",
          "17"  => "juushichi",
          "18"  => "juuhachi",
          "19"  => "juuku",
          "20"  => "nijuu",
          "21"  => "nijuuichi",
          "22"  => "nijuuni",
          "23"  => "nijuusan",
          "24"  => "nijuushi",
          "25"  => "nijuugo",
          "26"  => "nijuuroku",
          "27"  => "nijuushichi",
          "28"  => "nijuuhachi",
          "29"  => "nijuuku",
          "30"  => "sanjuu",
          "31"  => "sanjuuichi",
          "32"  => "sanjuuni",
          "33"  => "sanjuusan",
          "34"  => "sanjuushi",
          "35"  => "sanjuugo",
          "36"  => "sanjuuroku",
          "37"  => "sanjuushichi",
          "38"  => "sanjuuhachi",
          "39"  => "sanjuuku",
          "40"  => "yonjuu",
          "41"  => "yonjuuichi",
          "42"  => "yonjuuni",
          "43"  => "yonjuusan",
          "44"  => "yonjuushi",
          "45"  => "yonjuugo",
          "46"  => "yonjuuroku",
          "47"  => "yonjuushichi",
          "48"  => "yonjuuhachi",
          "49"  => "yonjuuku",
          "50"  => "gojuu",
          "51"  => "gojuuichi",
          "52"  => "gojuuni",
          "53"  => "gojuusan",
          "54"  => "gojuushi",
          "55"  => "gojuugo",
          "56"  => "gojuuroku",
          "57"  => "gojuushichi",
          "58"  => "gojuuhachi",
          "59"  => "gojuuku",
          "60"  => "rokujuu",
          "61"  => "rokujuuichi",
          "62"  => "rokujuuni",
          "63"  => "rokujuusan",
          "64"  => "rokujuushi",
          "65"  => "rokujuugo",
          "66"  => "rokujuuroku",
          "67"  => "rokujuushichi",
          "68"  => "rokujuuhachi",
          "69"  => "rokujuuku",
          "70"  => "nanajuu",
          "71"  => "nanajuuichi",
          "72"  => "nanajuuni",
          "73"  => "nanajuusan",
          "74"  => "nanajuushi",
          "75"  => "nanajuugo",
          "76"  => "nanajuuroku",
          "77"  => "nanajuushichi",
          "78"  => "nanajuuhachi",
          "79"  => "nanajuuku",
          "80"  => "hachijuu",
          "81"  => "hachijuuichi",
          "82"  => "hachijuuni",
          "83"  => "hachijuusan",
          "84"  => "hachijuushi",
          "85"  => "hachijuugo",
          "86"  => "hachijuuroku",
          "87"  => "hachijuushichi",
          "88"  => "hachijuuhachi",
          "89"  => "hachijuuku",
          "90"  => "kyuujuu",
          "91"  => "kyuujuuichi",
          "92"  => "kyuujuuni",
          "93"  => "kyuujuusan",
          "94"  => "kyuujuushi",
          "95"  => "kyuujuugo",
          "96"  => "kyuujuuroku",
          "97"  => "kyuujuushichi",
          "98"  => "kyuujuuhachi",
          "99"  => "kyuujuuku",
          "100" => "hyaku",
        },
  nb => {
          "0"   => "null",
          "1"   => "en",
          "2"   => "to",
          "3"   => "tre",
          "4"   => "fire",
          "5"   => "fem",
          "6"   => "seks",
          "7"   => "syv",
          "8"   => "åtte",
          "9"   => "ni",
          "10"  => "ti",
          "11"  => "elleve",
          "12"  => "tolv",
          "13"  => "tretten",
          "14"  => "fjorten",
          "15"  => "femten",
          "16"  => "seksten",
          "17"  => "sytten",
          "18"  => "atten",
          "19"  => "nitten",
          "20"  => "tjue",
          "21"  => "tjueen",
          "22"  => "tjueto",
          "23"  => "tjuetre",
          "24"  => "tjuefire",
          "25"  => "tjuefem",
          "26"  => "tjueseks",
          "27"  => "tjuesyv",
          "28"  => "tjueåtte",
          "29"  => "tjueni",
          "30"  => "tretti",
          "31"  => "trettien",
          "32"  => "trettito",
          "33"  => "trettitre",
          "34"  => "trettifire",
          "35"  => "trettifem",
          "36"  => "trettiseks",
          "37"  => "trettisyv",
          "38"  => "trettiåtte",
          "39"  => "trettini",
          "40"  => "førti",
          "41"  => "førtien",
          "42"  => "førtito",
          "43"  => "førtitre",
          "44"  => "førtifire",
          "45"  => "førtifem",
          "46"  => "førtiseks",
          "47"  => "førtisyv",
          "48"  => "førtiåtte",
          "49"  => "førtini",
          "50"  => "femti",
          "51"  => "femtien",
          "52"  => "femtito",
          "53"  => "femtitre",
          "54"  => "femtifire",
          "55"  => "femtifem",
          "56"  => "femtiseks",
          "57"  => "femtisyv",
          "58"  => "femtiåtte",
          "59"  => "femtini",
          "60"  => "seksti",
          "61"  => "sekstien",
          "62"  => "sekstito",
          "63"  => "sekstitre",
          "64"  => "sekstifire",
          "65"  => "sekstifem",
          "66"  => "sekstiseks",
          "67"  => "sekstisyv",
          "68"  => "sekstiåtte",
          "69"  => "sekstini",
          "70"  => "sytti",
          "71"  => "syttien",
          "72"  => "syttito",
          "73"  => "syttitre",
          "74"  => "syttifire",
          "75"  => "syttifem",
          "76"  => "syttiseks",
          "77"  => "syttisyv",
          "78"  => "syttiåtte",
          "79"  => "syttini",
          "80"  => "åtti",
          "81"  => "åttien",
          "82"  => "åttito",
          "83"  => "åttitre",
          "84"  => "åttifire",
          "85"  => "åttifem",
          "86"  => "åttiseks",
          "87"  => "åttisyv",
          "88"  => "åttiåtte",
          "89"  => "åttini",
          "90"  => "nitti",
          "91"  => "nittien",
          "92"  => "nittito",
          "93"  => "nittitre",
          "94"  => "nittifire",
          "95"  => "nittifem",
          "96"  => "nittiseks",
          "97"  => "nittisyv",
          "98"  => "nittiåtte",
          "99"  => "nittini",
          "100" => "hundre",
        },
  nl => {
          "0"   => "nul",
          "1"   => "een",
          "2"   => "twee",
          "3"   => "drie",
          "4"   => "vier",
          "5"   => "vijf",
          "6"   => "zes",
          "7"   => "zeven",
          "8"   => "acht",
          "9"   => "negen",
          "10"  => "tien",
          "11"  => "elf",
          "12"  => "twaalf",
          "13"  => "dertien",
          "14"  => "veertien",
          "15"  => "vijftien",
          "16"  => "zestien",
          "17"  => "zeventien",
          "18"  => "achttien",
          "19"  => "negentien",
          "20"  => "twintig",
          "21"  => "eenentwintig",
          "22"  => "tweeëntwintig",
          "23"  => "drieëntwintig",
          "24"  => "vierentwintig",
          "25"  => "vijfentwintig",
          "26"  => "zesentwintig",
          "27"  => "zevenentwintig",
          "28"  => "achtentwintig",
          "29"  => "negenentwintig",
          "30"  => "dertig",
          "31"  => "eenendertig",
          "32"  => "tweeëndertig",
          "33"  => "drieëndertig",
          "34"  => "vierendertig",
          "35"  => "vijfendertig",
          "36"  => "zesendertig",
          "37"  => "zevenendertig",
          "38"  => "achtendertig",
          "39"  => "negenendertig",
          "40"  => "veertig",
          "41"  => "eenenveertig",
          "42"  => "tweeënveertig",
          "43"  => "drieënveertig",
          "44"  => "vierenveertig",
          "45"  => "vijfenveertig",
          "46"  => "zesenveertig",
          "47"  => "zevenenveertig",
          "48"  => "achtenveertig",
          "49"  => "negenenveertig",
          "50"  => "vijftig",
          "51"  => "eenenvijftig",
          "52"  => "tweeënvijftig",
          "53"  => "drieënvijftig",
          "54"  => "vierenvijftig",
          "55"  => "vijfenvijftig",
          "56"  => "zesenvijftig",
          "57"  => "zevenenvijftig",
          "58"  => "achtenvijftig",
          "59"  => "negenenvijftig",
          "60"  => "zestig",
          "61"  => "eenenzestig",
          "62"  => "tweeënzestig",
          "63"  => "drieënzestig",
          "64"  => "vierenzestig",
          "65"  => "vijfenzestig",
          "66"  => "zesenzestig",
          "67"  => "zevenenzestig",
          "68"  => "achtenzestig",
          "69"  => "negenenzestig",
          "70"  => "zeventig",
          "71"  => "eenenzeventig",
          "72"  => "tweeënzeventig",
          "73"  => "drieënzeventig",
          "74"  => "vierenzeventig",
          "75"  => "vijfenzeventig",
          "76"  => "zesenzeventig",
          "77"  => "zevenenzeventig",
          "78"  => "achtenzeventig",
          "79"  => "negenenzeventig",
          "80"  => "tachtig",
          "81"  => "eenentachtig",
          "82"  => "tweeëntachtig",
          "83"  => "drieëntachtig",
          "84"  => "vierentachtig",
          "85"  => "vijfentachtig",
          "86"  => "zesentachtig",
          "87"  => "zevenentachtig",
          "88"  => "achtentachtig",
          "89"  => "negenentachtig",
          "90"  => "negentig",
          "91"  => "eenennegentig",
          "92"  => "tweeënnegentig",
          "93"  => "drieënnegentig",
          "94"  => "vierennegentig",
          "95"  => "vijfennegentig",
          "96"  => "zesennegentig",
          "97"  => "zevenennegentig",
          "98"  => "achtennegentig",
          "99"  => "negenennegentig",
          "100" => "honderd",
        },
  pl => {
          "0" => "zero",
          "1" => "jeden",
          "2" => "dwa",
          "3" => "trzy",
          "4" => "cztery",
          "5" => "pięć",
          "6" => "sześć",
          "7" => "siedem",
          "8" => "osiem",
          "9" => "dziewięć",
          "10" => "dziesięć",
          "11" => "jedenaście",
          "12" => "dwanaście",
          "13" => "trzynaście",
          "14" => "czternaście",
          "15" => "piętnaście",
          "16" => "szesnaście",
          "17" => "siedemnaście",
          "18" => "osiemnaście",
          "19" => "dziewiętnaście",
          "20" => "dwadzieścia",
          "21" => "dwadzieścia jeden",
          "22" => "dwadzieścia dwa",
          "23" => "dwadzieścia trzy",
          "24" => "dwadzieścia cztery",
          "25" => "dwadzieścia pięć",
          "26" => "dwadzieścia sześć",
          "27" => "dwadzieścia siedmiu",
          "28" => "dwadzieścia osiem",
          "29" => "dwadzieścia dziewięć",
          "30" => "trzydzieści",
          "31" => "trzydzieści jeden",
          "32" => "trzydzieści dwa",
          "33" => "trzydzieści trzy",
          "34" => "trzydzieści cztery",
          "35" => "trzydzieści pięć lat",
          "36" => "trzydzieści sześć",
          "37" => "trzydzieści siedem",
          "38" => "trzydzieści osiem",
          "39" => "trzydzieści dziewięć",
          "40" => "czterdzieści",
          "41" => "czterdzieści jeden",
          "42" => "czterdzieści dwa",
          "43" => "czterdzieści trzy",
          "44" => "czterdzieści cztery",
          "45" => "czterdzieści pięć",
          "46" => "czterdzieści sześć",
          "47" => "czterdzieści siedem",
          "48" => "czterdzieści osiem",
          "49" => "czterdzieści dziewięć",
          "50" => "pięćdziesiąt",
          "51" => "pięćdziesiąt jeden",
          "52" => "pięćdziesiąt dwa",
          "53" => "pięćdziesiąt trzy",
          "54" => "pięćdziesiąt cztery",
          "55" => "pięćdziesiąt pięć",
          "56" => "pięćdziesiąt sześć",
          "57" => "pięćdziesiąt siedem",  ,
          "58" => "pięćdziesiąt osiem",
          "59" => "pięćdziesiąt dziewięć",
          "60" => "sześćdziesiąt",
          "61" => "sześćdziesiąt jeden",
          "62" => "sześćdziesiąt dwa",
          "63" => "sześćdziesiąt trzy",
          "64" => "sześćdziesiąt cztery",
          "65" => "sześćdziesiąt pięć",
          "66" => "sześćdziesiąt sześć",
          "67" => "sześćdziesiąt siedem",
          "68" => "sześćdziesiąt osiem",
          "69" => "sześćdziesiąt dziewięć",
          "70" => "siedemdziesiąt",
          "71" => "siedemdziesiąt jeden",
          "72" => "siedemdziesiat dwa",
          "73" => "siedemdziesiąt trzy",
          "74" => "siedemdziesiąt cztery",
          "75" => "siedemdziesiat pięć",
          "76" => "siedemdziesiąt sześć",
          "77" => "siedemdziesiąt siedem",
          "78" => "siedemdziesiąt osiem",
          "79" => "siedemdziesiąt dziewięć",
          "80" => "osiemdziesiąt",
          "81" => "osiemdziesiąt jeden",
          "82" => "osiemdziesiąt dwa",
          "83" => "osiemdziesiąt trzy",
          "84" => "osiemdziesiąt cztery",
          "85" => "osiemdziesiąt pięć",
          "86" => "osiemdziesiąt sześć",
          "87" => "osiemdziesiąt siedem",
          "88" => "osiemdziesiąt osiem",
          "89" => "osiemdziesiąt dziewięć",
          "90" => "dziewięćdziesiąt",
          "91" => "dziewięćdziesiąt jeden",
          "92" => "dziewięćdziesiąt dwa",
          "93" => "dziewięćdziesiąt trzy",
          "94" => "dziewięćdziesiąt cztery",
          "95" => "dziewięćdziesiąt pięć",
          "96" => "dziewięćdziesiąt sześć",
          "97" => "dziewięćdziesiąt siedem",
          "98" => "dziewięćdziesiąt osiem",
          "99" => "dziewięćdziesiąt dziewięć",
          "100" => "sto",
         },
  pt => {
          "0"   => "zero",
          "1"   => "um",
          "2"   => "dois",
          "3"   => "três",
          "4"   => "quatro",
          "5"   => "cinco",
          "6"   => "seis",
          "7"   => "sete",
          "8"   => "oito",
          "9"   => "nove",
          "10"  => "dez",
          "11"  => "onze",
          "12"  => "doze",
          "13"  => "treze",
          "14"  => "catorze",
          "15"  => "quinze",
          "16"  => "dezasseis",
          "17"  => "dezassete",
          "18"  => "dezoito",
          "19"  => "dezanove",
          "20"  => "vinte",
          "21"  => "vinte e um",
          "22"  => "vinte e dois",
          "23"  => "vinte e três",
          "24"  => "vinte e quatro",
          "25"  => "vinte e cinco",
          "26"  => "vinte e seis",
          "27"  => "vinte e sete",
          "28"  => "vinte e oito",
          "29"  => "vinte e nove",
          "30"  => "trinta",
          "31"  => "trinta e um",
          "32"  => "trinta e dois",
          "33"  => "trinta e três",
          "34"  => "trinta e quatro",
          "35"  => "trinta e cinco",
          "36"  => "trinta e seis",
          "37"  => "trinta e sete",
          "38"  => "trinta e oito",
          "39"  => "trinta e nove",
          "40"  => "quarenta",
          "41"  => "quarenta e um",
          "42"  => "quarenta e dois",
          "43"  => "quarenta e três",
          "44"  => "quarenta e quatro",
          "45"  => "quarenta e cinco",
          "46"  => "quarenta e seis",
          "47"  => "quarenta e sete",
          "48"  => "quarenta e oito",
          "49"  => "quarenta e nove",
          "50"  => "cinquenta",
          "51"  => "cinquenta e um",
          "52"  => "cinquenta e dois",
          "53"  => "cinquenta e três",
          "54"  => "cinquenta e quatro",
          "55"  => "cinquenta e cinco",
          "56"  => "cinquenta e seis",
          "57"  => "cinquenta e sete",
          "58"  => "cinquenta e oito",
          "59"  => "cinquenta e nove",
          "60"  => "sessenta",
          "61"  => "sessenta e um",
          "62"  => "sessenta e dois",
          "63"  => "sessenta e três",
          "64"  => "sessenta e quatro",
          "65"  => "sessenta e cinco",
          "66"  => "sessenta e seis",
          "67"  => "sessenta e sete",
          "68"  => "sessenta e oito",
          "69"  => "sessenta e nove",
          "70"  => "setenta",
          "71"  => "setenta e um",
          "72"  => "setenta e dois",
          "73"  => "setenta e três",
          "74"  => "setenta e quatro",
          "75"  => "setenta e cinco",
          "76"  => "setenta e seis",
          "77"  => "setenta e sete",
          "78"  => "setenta e oito",
          "79"  => "setenta e nove",
          "80"  => "oitenta",
          "81"  => "oitenta e um",
          "82"  => "oitenta e dois",
          "83"  => "oitenta e três",
          "84"  => "oitenta e quatro",
          "85"  => "oitenta e cinco",
          "86"  => "oitenta e seis",
          "87"  => "oitenta e sete",
          "88"  => "oitenta e oito",
          "89"  => "oitenta e nove",
          "90"  => "noventa",
          "91"  => "noventa e um",
          "92"  => "noventa e dois",
          "93"  => "noventa e três",
          "94"  => "noventa e quatro",
          "95"  => "noventa e cinco",
          "96"  => "noventa e seis",
          "97"  => "noventa e sete",
          "98"  => "noventa e oito",
          "99"  => "noventa e nove",
          "100" => "cem",
        },
  ro => {
          "0"   => "zero",
          "1"   => "unu",
          "2"   => "doi",
          "3"   => "trei",
          "4"   => "patru",
          "5"   => "cinci",
          "6"   => "sase",
          "7"   => "sapte",
          "8"   => "opt",
          "9"   => "noua",
          "10"  => "zece",
          "11"  => "unsprezece",
          "12"  => "doisprezece",
          "13"  => "treisprezece",
          "14"  => "paisprezece",
          "15"  => "cincisprezece",
          "16"  => "saisprezece",
          "17"  => "saptesprezece",
          "18"  => "optsprezece",
          "19"  => "nouasprezece",
          "20"  => "douazeci",
          "21"  => "douazecisiunu",
          "22"  => "douazecisidoi",
          "23"  => "douazecisitrei",
          "24"  => "douazecisipatru",
          "25"  => "douazecisicinci",
          "26"  => "douazecisisase",
          "27"  => "douazecisisapte",
          "28"  => "douazecisiopt",
          "29"  => "douazecisinoua",
          "30"  => "treizeci",
          "31"  => "treizecisiunu",
          "32"  => "treizecisidoi",
          "33"  => "treizecisitrei",
          "34"  => "treizecisipatru",
          "35"  => "treizecisicinci",
          "36"  => "treizecisisase",
          "37"  => "treizecisisapte",
          "38"  => "treizecisiopt",
          "39"  => "treizecisinoua",
          "40"  => "patruzeci",
          "41"  => "patruzecisiunu",
          "42"  => "patruzecisidoi",
          "43"  => "patruzecisitrei",
          "44"  => "patruzecisipatru",
          "45"  => "patruzecisicinci",
          "46"  => "patruzecisisase",
          "47"  => "patruzecisisapte",
          "48"  => "patruzecisiopt",
          "49"  => "patruzecisinoua",
          "50"  => "cincizeci",
          "51"  => "cincizecisiunu",
          "52"  => "cincizecisidoi",
          "53"  => "cincizecisitrei",
          "54"  => "cincizecisipatru",
          "55"  => "cincizecisicinci",
          "56"  => "cincizecisisase",
          "57"  => "cincizecisisapte",
          "58"  => "cincizecisiopt",
          "59"  => "cincizecisinoua",
          "60"  => "saizeci",
          "61"  => "saizecisiunu",
          "62"  => "saizecisidoi",
          "63"  => "saizecisitrei",
          "64"  => "saizecisipatru",
          "65"  => "saizecisicinci",
          "66"  => "saizecisisase",
          "67"  => "saizecisisapte",
          "68"  => "saizecisiopt",
          "69"  => "saizecisinoua",
          "70"  => "saptezeci",
          "71"  => "saptezecisiunu",
          "72"  => "saptezecisidoi",
          "73"  => "saptezecisitrei",
          "74"  => "saptezecisipatru",
          "75"  => "saptezecisicinci",
          "76"  => "saptezecisisase",
          "77"  => "saptezecisisapte",
          "78"  => "saptezecisiopt",
          "79"  => "saptezecisinoua",
          "80"  => "optzeci",
          "81"  => "optzecisiunu",
          "82"  => "optzecisidoi",
          "83"  => "optzecisitrei",
          "84"  => "optzecisipatru",
          "85"  => "optzecisicinci",
          "86"  => "optzecisisase",
          "87"  => "optzecisisapte",
          "88"  => "optzecisiopt",
          "89"  => "optzecisinoua",
          "90"  => "nouazeci",
          "91"  => "nouazecisiunu",
          "92"  => "nouazecisidoi",
          "93"  => "nouazecisitrei",
          "94"  => "nouazecisipatru",
          "95"  => "nouazecisicinci",
          "96"  => "nouazecisisase",
          "97"  => "nouazecisisapte",
          "98"  => "nouazecisiopt",
          "99"  => "nouazecisinoua",
          "100" => "o suta",
        },
  ru => {
"0" => "ноль",
          "1" => "один",
          "2" => "два",
          "3" => "три",
          "4" => "четыре",
          "5" => "пять",
          "6" => "шестерки",
          "7" => "семь",
          "8" => "восьмерки",
          "9" => "девять",
          "10" => "десять",
          "11" => "одиннадцать",
          "12" => "двенадцать",
          "13" => "тринадцать",
          "14" => "четырнадцать",
          "15" => "пятнадцать",
          "16" => "шестнадцать",
          "17" => "семнадцать",
          "18" => "восемнадцать",
          "19" => "девятнадцати",
          "20" => "двадцать",
          "21" => "двадцать один",
          "22" => "двадцать два",
          "23" => "двадцать три",
          "24" => "двадцать четыре",
          "25" => "двадцать пять",
          "26" => "двадцать шесть",
          "27" => "двадцать семь",
          "28" => "двадцать восемь",
          "29" => "двадцать девять",
          "30" => "тридцать",
          "31" => "тридцать один",
          "32" => "тридцать два",
          "33" => "тридцать три",
          "34" => "тридцать четыре",
          "35" => "тридцать пять",
          "36" => "тридцать шесть",
          "37" => "тридцать семь",
          "38" => "тридцать восемь",
          "39" => "тридцать девять",
          "40" => "сорок",
          "41" => "сорок один",
          "42" => "сорок два",
          "43" => "сорок три",
          "44" => "сорок четыре",
          "45" => "сорок пять",
          "46" => "сорок шесть",
          "47" => "сорок семь",
          "48" => "сорок восемь",
          "49" => "сорок девять",
          "50" => "пятьдесят",
          "51" => "пятьдесят один",
          "52" => "пятьдесят два",
          "53" => "пятьдесят три",
          "54" => "пятьдесят четыре",
          "55" => "пятьдесят пять",
          "56" => "пятьдесят шесть",
          "57" => "пятьдесят семь",
          "58" => "пятьдесят восемь",
          "59" => "пятьдесят девять",
          "60" => "шестьдесят",
          "61" => "шестьдесят один",
          "62" => "шестьдесят два",
          "63" => "шестьдесят три",
          "64" => "шестьдесят четыре",
          "65" => "шестьдесят пять",
          "66" => "шестьдесят шесть",
          "67" => "шестьдесят семь",
          "68" => "шестьдесят восемь",
          "69" => "шестьдесят девять",
          "70" => "семьдесят",
          "71" => "семьдесят один",
          "72" => "семьдесят два",
          "73" => "семьдесят три",
          "74" => "семьдесят четыре",
          "75" => "семьдесят пять",
          "76" => "семьдесят шесть",
          "77" => "семьдесят семь",
          "78" => "семьдесят восемь",
          "79" => "семьдесят девять",
          "80" => "восемьдесят",
          "81" => "восемьдесят один",
          "82" => "восемьдесят два",
          "83" => "восемьдесят три",
          "84" => "восемьдесят четыре",
          "85" => "восемьдесят пять",
          "86" => "восемьдесят шесть",
          "87" => "восемьдесят семь",
          "88" => "восемьдесят восемь",
          "89" => "восемьдесят девять",
          "90" => "девяносто",
          "91" => "девяносто один",
          "92" => "девяносто два",
          "93" => "девяносто три",
          "94" => "девяносто четыре",
          "95" => "девяносто пять",
          "96" => "девяносто шесть",
          "97" => "девяносто семь",
          "98" => "девяносто восемь",
          "99" => "девяносто девять",
          "100" => "сто",        },
  sv => {
          "0"   => "noll",
          "1"   => "en",
          "2"   => "två",
          "3"   => "tre",
          "4"   => "fyra",
          "5"   => "fem",
          "6"   => "sex",
          "7"   => "sju",
          "8"   => "åtta",
          "9"   => "nio",
          "10"  => "tio",
          "11"  => "elva",
          "12"  => "tolv",
          "13"  => "tretton",
          "14"  => "fjorton",
          "15"  => "femton",
          "16"  => "sexton",
          "17"  => "sjutton",
          "18"  => "arton",
          "19"  => "nitton",
          "20"  => "tjugo",
          "21"  => "tjugoen",
          "22"  => "tjugotvå",
          "23"  => "tjugotre",
          "24"  => "tjugofyra",
          "25"  => "tjugofem",
          "26"  => "tjugosex",
          "27"  => "tjugosju",
          "28"  => "tjugoåtta",
          "29"  => "tjugonio",
          "30"  => "trettio",
          "31"  => "trettioen",
          "32"  => "trettiotvå",
          "33"  => "trettiotre",
          "34"  => "trettiofyra",
          "35"  => "trettiofem",
          "36"  => "trettiosex",
          "37"  => "trettiosju",
          "38"  => "trettioåtta",
          "39"  => "trettionio",
          "40"  => "fyrtio",
          "41"  => "fyrtioen",
          "42"  => "fyrtiotvå",
          "43"  => "fyrtiotre",
          "44"  => "fyrtiofyra",
          "45"  => "fyrtiofem",
          "46"  => "fyrtiosex",
          "47"  => "fyrtiosju",
          "48"  => "fyrtioåtta",
          "49"  => "fyrtionio",
          "50"  => "femtio",
          "51"  => "femtioen",
          "52"  => "femtiotvå",
          "53"  => "femtiotre",
          "54"  => "femtiofyra",
          "55"  => "femtiofem",
          "56"  => "femtiosex",
          "57"  => "femtiosju",
          "58"  => "femtioåtta",
          "59"  => "femtinie",
          "60"  => "sextio",
          "61"  => "sextioen",
          "62"  => "sextiotvå",
          "63"  => "sextiotre",
          "64"  => "sextiofyra",
          "65"  => "sextiofem",
          "66"  => "sextiosex",
          "67"  => "sextiosju",
          "68"  => "sextioåtta",
          "69"  => "sextionio",
          "70"  => "sjuttio",
          "71"  => "sjuttioen",
          "72"  => "sjuttiotvå",
          "73"  => "sjuttiotre",
          "74"  => "sjuttiofyra",
          "75"  => "sjuttiofem",
          "76"  => "sjuttiosex",
          "77"  => "sjuttiosju",
          "78"  => "sjuttioåtta",
          "79"  => "sjuttionio",
          "80"  => "åttio",
          "81"  => "åttioen",
          "82"  => "åttiotvå",
          "83"  => "åttiotre",
          "84"  => "åttiofyra",
          "85"  => "åttiofem",
          "86"  => "åttiosex",
          "87"  => "åttiosju",
          "88"  => "åttioåtta",
          "89"  => "åttionio",
          "90"  => "nittio",
          "91"  => "nittioen",
          "92"  => "nittiotvå",
          "93"  => "Nittiotre",
          "94"  => "nittiofyra",
          "95"  => "nittiofem",
          "96"  => "Nittiosex",
          "97"  => "Nittiosju",
          "98"  => "nittioåtta",
          "99"  => "nittionio",
          "100" => "hundra",
        },
  tr => {
          "0" => "sıfır",
          "1" => "bir",
          "2" => "iki",
          "3" => "üç",
          "4" => "dört",
          "5" => "beş",
          "6" => "altı",
          "7" => "yedi",
          "8" => "sekiz",
          "9" => "dokuz",
          "10" => "on",
          "11" => "onbir",
          "12" => "oniki",
          "13" => "onüç",
          "14" => "ondört",
          "15" => "on beş",
          "16" => "on altı",
          "17" => "on yedi",
          "18" => "on sekiz",
          "19" => "on dokuz",
          "20" => "yirmi",
          "21" => "yirmi bir",
          "22" => "yirmi iki",
          "23" => "yirmi üç",
          "24" => "yirmi dört",
          "25" => "yirmi beş",
          "26" => "yirmi altı",
          "27" => "yirmi yedi",
          "28" => "yirmi sekiz",
          "29" => "yirmi dokuz",
          "30" => "otuz",
          "31" => "otuz bir",
          "32" => "otuz iki",
          "33" => "otuz üç",
          "34" => "otuz dört",
          "35" => "otuz beş",
          "36" => "otuz altı",
          "37" => "otuz yedi",
          "38" => "otuz sekiz",
          "39" => "otuz dokuz",
          "40" => "kırk",
          "41" => "kırk bir",
          "42" => "kırk iki",
          "43" => "kırk üç",
          "44" => "kırk dört",
          "45" => "kırk beş",
          "46" => "kırk altı",
          "47" => "kırk yedi",
          "48" => "kırk sekiz",
          "49" => "kırk dokuz",
          "50" => "elli",
          "51" => "elli bir",
          "52" => "elli iki",
          "53" => "elli üç",
          "54" => "elli dört",
          "55" => "elli beş",
          "56" => "elli altı",
          "57" => "elli yedi",
          "58" => "elli sekiz",
          "59" => "elli dokuz",
          "60" => "altmış",
          "61" => "altmış bir",
          "62" => "altmış iki",
          "63" => "altmış üç",
          "64" => "altmış dört",
          "65" => "altmış beş",
          "66" => "altmış altı",
          "67" => "altmış yedi",
          "68" => "altmış sekiz",
          "69" => "altmış dokuz",
          "70" => "yetmiş",
          "71" => "yetmiş bir",
          "72" => "yetmiş iki",
          "73" => "yetmiş üç",
          "74" => "yetmiş dört",
          "75" => "yetmiş beş",
          "76" => "yetmiş altı",
          "77" => "yetmiş yedi",
          "78" => "yetmiş sekiz",
          "79" => "yetmiş dokuz",
          "80" => "seksen",
          "81" => "seksen bir",
          "82" => "seksen iki",
          "83" => "seksen üç",
          "84" => "seksen dört",
          "85" => "seksen beş",
          "86" => "seksen altı",
          "87" => "seksen yedi",
          "88" => "seksen sekiz",
          "89" => "seksen dokuz",
          "90" => "doksan",
          "91" => "doksanla bir",
          "92" => "doksan iki",
          "93" => "doksan üç",
          "94" => "doksan dört",
          "95" => "doksan beş",
          "96" => "doksan altı",
          "97" => "doksan yedi",
          "98" => "doksan sekiz",
          "99" => "doksan dokuz",
          "100" => "yüz"
         },
  de => {0=>"null",
         1=>"eins",
         2=>"zwei",
         3=>"drei",
         4=>"vier",
         5=>"fünf",
         6=>"sechs",
         7=>"sieben",
         8=>"acht",
         9=>"neun",
        10=>"zehn",
        11=>"elf",
        12=>"zwölf",
        13=>"dreizehn",
        14=>"vierzehn",
        15=>"fünfzehn",
        16=>"sechzehn",
        17=>"siebzehn",
        18=>"achtzehn",
        19=>"neunzehn",
        20=>"zwanzig",
        21=>"einundzwanzig",
        22=>"zweiundzwanzig",
        23=>"dreiundzwanzig",
        24=>"vierundzwanzig",
        25=>"fünfundzwanzig",
        26=>"sechsundzwanzig",
        27=>"siebenundzwanzig",
        28=>"achtundzwanzig",
        29=>"neunundzwanzig",
        30=>"dreiβig",
        31=>"einunddreiβig",
        32=>"zweiunddreißig",
        33=>"dreiunddreißig",
        34=>"vierunddreißig",
        35=>"fünfunddreißig",
        36=>"sechsunddreißig",
        37=>"siebenunddreißig",
        38=>"achtunddreißig",
        39=>"neununddreißig",
        40=>"vierzig",
        41=>"einundvierzig",
        42=>"zweiundvierzig",
        43=>"dreiundvierzig",
        44=>"vierundvierzig",
        45=>"fünfundvierzig",
        46=>"sechsundvierzig",
        47=>"siebenundvierzig",
        48=>"achtundvierzig",
        49=>"neunundvierzig",
        50=>"fünfzig",
        51=>"einundfünfzig",
        52=>"zweiundfünfzig",
        53=>"dreiundfünfzig",
        54=>"vierundfünfzig",
        55=>"fünfundfünfzig",
        56=>"sechsundfünfzig",
        57=>"siebenundfünfzig",
        58=>"achtundfünfzig",
        59=>"neunundfünfzig",
        60=>"sechzig",
        61=>"einundsechzig",
        62=>"zweiundsechzig",
        63=>"dreiundsechzig",
        64=>"vierundsechzig",
        65=>"fünfundsechzig",
        66=>"sechsundsechzig",
        67=>"siebenundsechzig",
        68=>"achtundsechzig",
        69=>"neunundsechzig",
        70=>"siebzig",
        71=>"einundsiebzig",
        72=>"zweiundsiebzig",
        73=>"dreiundsiebzig",
        74=>"vierundsiebzig",
        75=>"fünfundsiebzig",
        76=>"sechsundsiebzig",
        77=>"siebenundsiebzig",
        78=>"achtundsiebzig",
        79=>"neunundsiebzig",
        80=>"achtzig",
        81=>"einundachtzig",
        82=>"zweiundachtzig",
        83=>"dreiundachtzig",
        84=>"vierundachtzig",
        85=>"fünfundachtzig",
        86=>"sechsundachtzig",
        87=>"siebenundachtzig",
        88=>"achtundachtzig",
        89=>"neunundachtzig",
        90=>"neunzig",
        91=>"einundneunzig",
        92=>"zweiundneunzig",
        93=>"dreiundneunzig",
        94=>"vierundneunzig",
        95=>"fünfundneunzig",
        96=>"sechsundneunzig",
        97=>"siebenundneunzig",
        98=>"achtundneunzig",
        99=>"neunundneunzig",
       100=>"ein hundert",
      },
  fr => {0=>'zéro',
      1=>'un',
      2=>'deux',
      3=>'trois',
      4=>'quatre',
      5=>'cinq',
      6=>'six',
      7=>'sept',
      8=>'huit',
      9=>'neuf',
      10=>'dix',
      11=>'onze',
      12=>'douze',
      13=>'treize',
      14=>'quatorze',
      15=>'quinze',
      16=>'seize',
      17=>'dix-sept',
      18=>'dix-huit',
      19=>'dix neuf',
      20=>'vingt',
      21=>'vingt et un',
      22=>'vingt-deux',
      23=>'vingt-trois',
      24=>'vingt-quatre',
      25=>'vingt-cinq',
      26=>'vingt-six',
      27=>'vingt-sept',
      28=>'vingt-huit',
      29=>'vingt-neuf',
      30=>'trente',
      31=>'trente et un',
      32=>'trente-deux',
      33=>'trente-trois',
      34=>'trente-quatre',
      35=>'trente-cinq',
      36=>'trente-six',
      37=>'trente-sept',
      38=>'trente-huit',
      39=>'trente-neuf',
      40=>'quarante',
      41=>'quarante et un',
      42=>'quarante-deux',
      43=>'quarante-trois',
      44=>'quarante-quatre',
      45=>'quarante-cinq',
      46=>'quarante-six',
      47=>'quarante-sept',
      48=>'quarante-huit',
      49=>'quarante-neuf',
      50=>'cinquante',
      51=>'cinquante et un',
      52=>'cinquante-deux',
      53=>'cinquante-trois',
      54=>'cinquante-quatre',
      55=>'cinquante-cinq',
      56=>'cinquante-six',
      57=>'cinquante-sept',
      58=>'cinquante-huit',
      59=>'cinquante-neuf',
      60=>'soixante',
      61=>'soixante et un',
      62=>'soixante-deux',
      63=>'soixante-trois',
      64=>'soixante-quatre',
      65=>'soixante-cinq',
      66=>'soixante-six',
      67=>'soixante-sept',
      68=>'soixante-huit',
      69=>'soixante-neuf',
      70=>'soixante-dix',
      71=>'soixante et onze',
      72=>'soixante-douze',
      73=>'soixante-treize',
      74=>'soixante-quatorze',
      75=>'soixante-quinze',
      76=>'soixante-seize',
      77=>'soixante-dix-sept',
      78=>'soixante-dix-huit',
      79=>'soixante-dix-neuf',
      80=>'quatre-vingts',
      81=>'quatre-vingt-un',
      82=>'quatre-vingt-deux',
      83=>'quatre-vingt-trois',
      84=>'quatre-vingt-quatre',
      85=>'quatre-vingt-cinq',
      86=>'quatre-vingt-six',
      87=>'quatre-vingt-sept',
      88=>'quatre-vingt-huit',
      89=>'quatre-vingt-neuf',
      90=>'quatre-vingt-dix',
      91=>'quatre-vingt-un',
      92=>'quatre-vingt-douze',
      93=>'quatre-vingt-treize',
      94=>'quatre-vingt-quatorze',
      95=>'quatre-vingt-quinze',
      96=>'quatre-vingt-seize',
      97=>'quatre-vingt-dix-sept',
      98=>'quatre-vingt-dix-huit',
      99=>'quatre-vingt-dix-neuf',
      100=>'cent',
     },
   }
 }

#-------------------------------------------------------------------------------
# Test
#-------------------------------------------------------------------------------

sub test
 {eval join('', <Text::Numbers::100::DATA>) || die $@
 }

test unless caller();

# Documentation
#extractDocumentation unless caller;

#-------------------------------------------------------------------------------
# Export
#-------------------------------------------------------------------------------

require Exporter;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

@ISA          = qw(Exporter);
@EXPORT       = qw();
@EXPORT_OK    = qw();
%EXPORT_TAGS  = (all=>[@EXPORT, @EXPORT_OK]);

1;

=pod

=encoding utf-8

=head1 Name

Text::Numbers::100 - Translate the numbers from 0 to 100 into various languages

=head1 Synopsis

 use Text::Numbers::100;

 ok Text::Numbers::100::translate(qw(es),  42) eq "cuarentay dos";
 ok Text::Numbers::100::translate(qw(de),  42) eq "zwei und vierzig";
 ok Text::Numbers::100::translate(qw(tr), 100) eq "yüz";
 ok Text::Numbers::100::translate(qw(ru),  61) eq "шестьдесят один";

=head1 Description

 Text::Numbers::100::translate($language, $number)

Translates a number from 0 to 100 into text in the following languages:

 cy da de en es fr is it ja nb nl pl pt ro ru sv tr

=head1 Installation

Standard Module::Build process for building and installing modules:

  perl Build.PL
  ./Build
  ./Build test
  ./Build install

=head1 Author

philiprbrenan@gmail.com

http://www.appaapps.com

=head1 Copyright

Copyright (c) 2017 Philip R Brenan.

This module is free software. It may be used, redistributed and/or modified
under the same terms as Perl itself.

=cut

__DATA__
use Test::More tests=>22;

ok Text::Numbers::100::translate(qw(es),  42) eq "cuarentay dos";
ok Text::Numbers::100::translate(qw(de),  42) eq "zweiundvierzig";
ok Text::Numbers::100::translate(qw(tr), 100) eq "yüz";
ok Text::Numbers::100::translate(qw(ru),  61) eq "шестьдесят один";

if (1)
 {my $t = translations;
  for(sort keys %$t)
   {my $n = $t->{$_};
    ok scalar(keys %$n) eq 101;
   }
 }

ok join(' ', Text::Numbers::100::languages) eq
   join(' ', qw(cy da de en es fr is it ja nb nl pl pt ro ru sv tr));
