use Date::Convert::French_Rev;

my $n = 1;

sub g2r {
  my $n      = shift;
  my $date_r = shift;
  my $format = shift;
  my $date = new Date::Convert::Gregorian @_;
  convert Date::Convert::French_Rev $date;
  my $date_resul = $date->date_string($format);
  if ($date_r eq $date_resul)
    { print "ok $n\n" }
  else
    { print "not ok $n : expected $date_r, got $date_resul\n" }
}


@tests = ([" 1 Vendmiaire I",                     "", 1792,  9, 22],
	  ["Jour des Rcompenses I",        "%EJ %EY", 1793,  9, 21],
	  [" 1 Vendmiaire II",                    "", 1793,  9, 22],
	  ["Jour des Rcompenses II",       "%EJ %EY", 1794,  9, 21],
	  [" 1 Vendmiaire III",                   "", 1794,  9, 22],
	  ["Jour de la Rvolution III",     "%EJ %EY", 1795,  9, 22],
	  [" 1 Vendmiaire IV",                    "", 1795,  9, 23],
	  ["Jour des Rcompenses IV",       "%EJ %EY", 1796,  9, 21],
	  [" 1 Vendmiaire V",                     "", 1796,  9, 22],
	  ["Jour des Rcompenses V",        "%EJ %EY", 1797,  9, 21],
	  [" 1 Vendmiaire VI",                    "", 1797,  9, 22],
	  ["Jour des Rcompenses VI",       "%EJ %EY", 1798,  9, 21],
	  [" 1 Vendmiaire VII",                   "", 1798,  9, 22],
	  ["Jour de la Rvolution VII",     "%EJ %EY", 1799,  9, 22],
	  [" 1 Vendmiaire VIII",                  "", 1799,  9, 23],
	  ["Jour des Rcompenses VIII",     "%EJ %EY", 1800,  9, 22],
	  [" 1 Vendmiaire IX",                    "", 1800,  9, 23],
	  ["Jour des Rcompenses IX",       "%EJ %EY", 1801,  9, 22],
	  [" 1 Vendmiaire X",                     "", 1801,  9, 23],
	  ["Jour des Rcompenses X",        "%EJ %EY", 1802,  9, 22],
	  [" 1 Vendmiaire LVI",                   "", 1847,  9, 23],
	  ["Jour de la Rvolution LVI",     "%EJ %EY", 1848,  9, 22],
	  [" 1 Vendmiaire LVII",                  "", 1848,  9, 23],
	  ["Jour des Rcompenses LVII",     "%EJ %EY", 1849,  9, 22],
	  [" 1 Vendmiaire LVIII",                 "", 1849,  9, 23],
	  ["Jour des Rcompenses LVIII",    "%EJ %EY", 1850,  9, 22],
	  [" 1 Vendmiaire C",                     "", 1891,  9, 23],
	  ["Jour des Rcompenses C",        "%EJ %EY", 1892,  9, 21],
	  [" 1 Vendmiaire CI",                    "", 1892,  9, 22],
	  ["Jour des Rcompenses CI",       "%EJ %EY", 1893,  9, 21],
	  [" 1 Vendmiaire CVIII",                 "", 1899,  9, 22],
	  ["Jour de la Rvolution CVIII",   "%EJ %EY", 1900,  9, 22],
	  [" 1 Vendmiaire CC",                    "", 1991,  9, 23],
	  ["Jour des Rcompenses CC",       "%EJ %EY", 1992,  9, 21],
	  [" 1 Vendmiaire CCI",                   "", 1992,  9, 22],
	  ["Jour des Rcompenses CCI",      "%EJ %EY", 1993,  9, 21],
	  [" 1 Vendmiaire CCVIII",                "", 1999,  9, 22],
	  ["Jour de la Rvolution CCVIII",  "%EJ %EY", 2000,  9, 21],
	  [" 1 Vendmiaire CCC",                   "", 2091,  9, 22],
	  ["Jour des Rcompenses CCC",      "%EJ %EY", 2092,  9, 20],
	  [" 1 Vendmiaire CCCI",                  "", 2092,  9, 21],
	  ["Jour des Rcompenses CCCI",     "%EJ %EY", 2093,  9, 20],
	  [" 1 Vendmiaire CCCVIII",               "", 2099,  9, 21],
	  ["Jour de la Rvolution CCCVIII", "%EJ %EY", 2100,  9, 21],
	  [" 1 Vendmiaire CD",                    "", 2191,  9, 22],
	  ["Jour de la Rvolution CD",      "%EJ %EY", 2192,  9, 21],
	  [" 1 Vendmiaire CDI",                   "", 2192,  9, 22],
	  ["Jour des Rcompenses CDI",      "%EJ %EY", 2193,  9, 21],
	  [" 1 Vendmiaire CDVIII",                "", 2199,  9, 22],
	  ["Jour de la Rvolution CDVIII",  "%EJ %EY", 2200,  9, 22],
	  );

printf "1..%d\n", scalar @tests;

foreach (@tests) { g2r $n++, @$_ }
