/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class DefaultInfoImpl
implements DefaultInfo,
Formatable {
    private DataValueDescriptor defaultValue;
    private String defaultText;
    private int type;
    private static final int BITS_MASK_IS_DEFAULTVALUE_AUTOINC = 1;

    public DefaultInfoImpl() {
    }

    public DefaultInfoImpl(boolean bl, String string, DataValueDescriptor dataValueDescriptor) {
        this.type = DefaultInfoImpl.calcType(bl);
        this.defaultText = string;
        this.defaultValue = dataValueDescriptor;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public String toString() {
        if (this.isDefaultValueAutoinc()) {
            return "GENERATED_BY_DEFAULT";
        }
        return this.defaultText;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.defaultText = (String)objectInput.readObject();
        this.defaultValue = (DataValueDescriptor)objectInput.readObject();
        this.type = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.defaultText);
        objectOutput.writeObject(this.defaultValue);
        objectOutput.writeInt(this.type);
    }

    public int getTypeFormatId() {
        return 326;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DataValueDescriptor dataValueDescriptor) {
        this.defaultValue = dataValueDescriptor;
    }

    public boolean isDefaultValueAutoinc() {
        return (this.type & 1) != 0;
    }

    private static int calcType(boolean bl) {
        int n = 0;
        if (bl) {
            n |= 1;
        }
        return n;
    }
}

