# This Makefile.PL for Apache-AuthCookie was generated by
# Dist::Zilla::Plugin::MakeMaker::ApacheTest 0.03
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.38.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

# figure out if mod_perl v1 or v2 is installed.  DynamicPrereqs in the
# PluginBundle needs this to require the appropriate mod_perl module.
my $mp_version = mod_perl_version();

# configure Apache::Test
test_configure();

my %WriteMakefileArgs = (
  "ABSTRACT" => "Perl Authentication and Authorization via cookies",
  "AUTHOR" => "Michael Schout <mschout\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Apache::Test" => "1.39",
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Apache-AuthCookie",
  "LICENSE" => "perl",
  "NAME" => "Apache::AuthCookie",
  "PREREQ_PM" => {
    "Carp" => 0,
    "Class::Load" => "0.03",
    "Encode" => 0,
    "HTTP::Body" => 0,
    "Hash::MultiValue" => 0,
    "Test::More" => "0.94",
    "WWW::Form::UrlEncoded" => 0
  },
  "TEST_REQUIRES" => {
    "URI::Escape" => "1.31"
  },
  "VERSION" => "3.27",
  "clean" => {
    "FILES" => [
      "t/TEST"
    ]
  },
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Carp" => 0,
  "Class::Load" => "0.03",
  "Encode" => 0,
  "HTTP::Body" => 0,
  "Hash::MultiValue" => 0,
  "Test::More" => "0.94",
  "URI::Escape" => "1.31",
  "WWW::Form::UrlEncoded" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.032
if ($mp_version == 2) {     requires('mod_perl2', '1.999022'); } elsif ($mp_version == 1) {     requires('mod_perl', '1.27'); }

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub test_configure {
    require Apache::TestMM;

    # enable make test
    Apache::TestMM->import(qw(test clean));

    Apache::TestMM::filter_args();

    Apache::TestMM::generate_script('t/TEST');
}

sub mod_perl_version {
    # try MP2
    eval {
        require mod_perl2;
    };
    unless ($@) {
        return 2;
    }

    # try MP1
    eval {
        require mod_perl;
    };
    unless ($@) {
        if ($mod_perl::VERSION >= 1.99) {
            # mod_perl 2, prior to the mod_perl2 rename (1.99_21, AKA 2.0.0 RC5)
            die "mod_perl 2.0 RC5 or later is required\n";
        }

        return 1;
    }

    # assume mod_perl version 2 is wanted
    return 2;
}

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.032
sub _add_prereq {
  my ($mm_key, $module, $version_or_range) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
      and $WriteMakefileArgs{$mm_key}{$module} ne '0'
      and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
        and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ($module, $version_or_range) = @_;
  _add_prereq(PREREQ_PM => $module, $version_or_range);
}
