/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.AdjacentTextNodeMerger;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Orphan;

public class AdjacentTextNodeMergingIterator
implements LookaheadIterator {
    private SequenceIterator base;
    private Item current;
    private Item next;
    private int position = 0;

    public AdjacentTextNodeMergingIterator(SequenceIterator base) throws XPathException {
        this.base = base;
        this.next = base.next();
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() throws XPathException {
        this.current = this.next;
        if (this.current == null) {
            this.position = -1;
            return null;
        }
        this.next = this.base.next();
        if (AdjacentTextNodeMerger.isTextNode(this.current)) {
            FastStringBuffer fsb = new FastStringBuffer(256);
            fsb.append(this.current.getStringValueCS());
            while (this.next != null && AdjacentTextNodeMerger.isTextNode(this.next)) {
                fsb.append(this.next.getStringValueCS());
                this.next = this.base.next();
            }
            if (fsb.length() == 0) {
                return this.next();
            }
            Orphan o = new Orphan(((NodeInfo)this.current).getConfiguration());
            o.setNodeKind((short)3);
            o.setStringValue(fsb);
            this.current = o;
            ++this.position;
            return this.current;
        }
        ++this.position;
        return this.current;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public void close() {
        this.base.close();
    }

    public SequenceIterator getAnother() throws XPathException {
        return new AdjacentTextNodeMergingIterator(this.base.getAnother());
    }

    public int getProperties() {
        return 4;
    }
}

