/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleExpression
extends Expression
implements CallableExpression {
    public static final Expression[] NO_ARGUMENTS = new Expression[0];
    protected Expression[] arguments = NO_ARGUMENTS;

    public void setArguments(Expression[] sub) {
        this.arguments = sub;
        for (int i = 0; i < sub.length; ++i) {
            this.adoptChildExpression(sub[i]);
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return Arrays.asList(this.arguments).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != original) continue;
            this.arguments[i] = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = visitor.simplify(this.arguments[i]);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = visitor.typeCheck(this.arguments[i], contextItemType);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = visitor.optimize(this.arguments[i], contextItemType);
        }
        return this;
    }

    @Override
    public Expression copy() {
        throw new UnsupportedOperationException("SimpleExpression.copy()");
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] == null) continue;
            this.arguments[i] = this.doPromotion(this.arguments[i], offer);
        }
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        if ((this.getImplementationMethod() & 1) == 0) {
            return 49152;
        }
        return 24576;
    }

    @Override
    public int computeDependencies() {
        return super.computeDependencies();
    }

    @Override
    public final Item evaluateItem(XPathContext context) throws XPathException {
        return this.call(this.evaluateArguments(context), context).next();
    }

    public final SequenceIterator iterate(XPathContext context) throws XPathException {
        return this.call(this.evaluateArguments(context), context);
    }

    @Override
    public final void process(XPathContext context) throws XPathException {
        Item it;
        SequenceIterator<? extends Item> iter = this.call(this.evaluateArguments(context), context);
        while ((it = iter.next()) != null) {
            context.getReceiver().append(it, this.locationId, 2);
        }
    }

    private SequenceIterator[] evaluateArguments(XPathContext context) throws XPathException {
        SequenceIterator[] iters = new SequenceIterator[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            iters[i] = this.arguments[i].iterate(context);
        }
        return iters;
    }

    @Override
    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    public void explain(ExpressionPresenter destination) {
        destination.startElement("userExpression");
        destination.emitAttribute("class", this.getExpressionType());
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].explain(destination);
        }
        destination.endElement();
    }

    public String getExpressionType() {
        return this.getClass().getName();
    }
}

