package Email::Folder::Exchange;
use base qw(Email::Folder);

use strict;
use warnings;

use Email::Folder;
use Email::Folder::Exchange::WebDAV;
use Email::Folder::Exchange::EWS;

use URI;
use LWP::UserAgent;

sub new {
  my ($self, $class, $url, $username, $password) = ({}, @_);
	bless $self, $class;

	# guess user interface
	my $uri = URI->new($url);
	my $ua = LWP::UserAgent->new();

	# get root page
	$uri->path('/');
	my $response = $ua->get($uri->as_string);

	# if the server provides an X-OWA-Version header, this is an exchange >= 07 server
	if($response->header('X-OWA-Version')) {
	  return Email::Folder::Exchange::EWS->new($url, $username, $password);
	}
	else {
    return Email::Folder::Exchange::WebDAV->new($url, $username, $password);
	}
}
	

1;
