package Graphics::ColorNames::FamousLogo;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-04'; # DATE
our $DIST = 'Graphics-ColorNames-FamousLogo'; # DIST
our $VERSION = '0.001'; # VERSION

sub NamesRgbTable() {
    use integer;
    return {

        airbnb_red => "fd5c63",

        alibaba_orange => "ff6a00",

        amazon_orange => "ff9900",
        amazon_blue   => "146eb4",

        americanexpress_blue => "002663",
        americanexpress_gray => "4d4f53",

        android_green => "a4c639",

        att_blue => "00a8e0",

        baidu_red => "de0f17",
        baidu_blue => "2529d8",

        apple1980_blue   => "009ddc",
        apple1980_green  => "61bb46",
        apple1980_orange => "f5821f",
        apple1980_purple => "963d97",
        apple1980_red    => "e03a3e",
        apple1980_yellow => "fdb827",

        ballpark_black  => "1a1716",
        ballpark_blue   => "1d3f99",
        ballpark_red1   => "b2171d",
        ballpark_red2   => "ec0f20",
        ballpark_white  => "ffffff",
        ballpark_yellow => "f1d408",

        google_blue   => "3369e8",
        google_green  => "009925",
        google_red    => "d50f25",
        google_yellow => "eeb211",

        nascar_blue   => "02549e",
        nascar_purple => "88166d",
        nascar_red    => "bc2021",
        nascar_yellow => "edc240",

        nbc_blue   => "0089d0",
        nbc_green  => "0db14b",
        nbc_orange => "f37021",
        nbc_purple => "6460aa",
        nbc_red    => "cc004c",
        nbc_yellow => "fcb711",

        nfl_blue  => "003a73",
        nfl_red   => "da2127",
        nfl_white => "ffffff",
    };
}

1;
# ABSTRACT: Colors used in famous logos

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNames::FamousLogo - Colors used in famous logos

=head1 VERSION

This document describes version 0.001 of Graphics::ColorNames::FamousLogo (from Perl distribution Graphics-ColorNames-FamousLogo), released on 2023-12-04.

=head1 SYNOPSIS

  require Graphics::ColorNames::FamousLogo;

  $NameTable = Graphics::ColorNames::FoodColor->NamesRgbTable();
  $google_blue  = $NameTable->{"google_blue"};

=head1 DESCRIPTION

=for Pod::Coverage ^(.+)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNames-FamousLogo>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNames-FamousLogo>.

=head1 SEE ALSO

L<Graphics::ColorNames>

L<https://digitalsynopsis.com/design/brand-colors/>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNames-FamousLogo>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
